/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.TaskIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.AssertionOrderModulation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModuleCraig;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TaCheckAndRefinementPreferences;
import java.util.Arrays;

public class IpTcStrategyModuleSmtInterpolCraig<LETTER extends IIcfgTransition<?>>
extends IpTcStrategyModuleCraig<LETTER> {
    private static final InterpolationTechnique[] SUPPORTED_TECHNIQUES = new InterpolationTechnique[]{InterpolationTechnique.Craig_NestedInterpolation, InterpolationTechnique.Craig_TreeInterpolation};
    private final long mTimeoutInMillis;
    private final InterpolationTechnique mInterpolationTechnique;

    public IpTcStrategyModuleSmtInterpolCraig(TaskIdentifier taskIdentifier, IUltimateServiceProvider iUltimateServiceProvider, TaCheckAndRefinementPreferences<LETTER> taCheckAndRefinementPreferences, Counterexample<LETTER> counterexample, IPredicate iPredicate, IPredicate iPredicate2, AssertionOrderModulation<LETTER> assertionOrderModulation, IPredicateUnifier iPredicateUnifier, PredicateFactory predicateFactory, long l, InterpolationTechnique interpolationTechnique2) {
        super(taskIdentifier, iUltimateServiceProvider, taCheckAndRefinementPreferences, counterexample, iPredicate, iPredicate2, assertionOrderModulation, iPredicateUnifier, predicateFactory);
        this.mTimeoutInMillis = l;
        this.mInterpolationTechnique = interpolationTechnique2;
        assert (Arrays.stream(SUPPORTED_TECHNIQUES).anyMatch(interpolationTechnique -> interpolationTechnique == this.mInterpolationTechnique)) : "Unsupported interpolation technique " + String.valueOf(this.mInterpolationTechnique);
    }

    @Override
    protected ManagedScript constructManagedScript() {
        long l = this.computeTimeout(this.mTimeoutInMillis);
        SolverBuilder.SolverMode solverMode = SolverBuilder.SolverMode.Internal_SMTInterpol;
        SolverBuilder.SolverSettings solverSettings = this.mPrefs.constructSolverSettings(this.mTaskIdentifier).setSolverMode(solverMode).setSmtInterpolTimeout(l);
        return this.createExternalManagedScript(solverSettings);
    }

    @Override
    protected final InterpolationTechnique getInterpolationTechnique() {
        return this.mInterpolationTechnique;
    }
}

