/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class MinimizeDfaHopcroftArrays<LETTER, STATE>
extends AbstractMinimizeNwa<LETTER, STATE> {
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private ArrayList<STATE> mInt2state;
    private HashMap<STATE, Integer> mState2int;
    private ArrayList<LETTER> mInt2letter;
    private HashMap<LETTER, Integer> mLetter2int;
    private int[] mLabels;
    private int[] mLabelTails;
    private int[] mLabelHeads;
    private int[] mNumberOfMarkedElemInSet;
    private int[] mSetsWithMarkedElements;
    private int[] mF;
    private int[] mAdjacent;
    private int[] mFinalStates;
    private int mNumberOfTransitions;
    private int mNumberOfStates;
    private int mNumberOfFinalStates;
    private int mInitialState;
    private int mNumberOfLetters;
    private int mW = 0;
    private Partition mBlocks;
    private Partition mCords;

    public MinimizeDfaHopcroftArrays(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, boolean bl) {
        this(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton, null, bl);
    }

    public MinimizeDfaHopcroftArrays(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs, boolean bl) {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iNestedWordAutomaton;
        this.printStartMessage();
        if (!this.isFiniteAutomaton()) {
            throw new UnsupportedOperationException("This class only supports minimization of finite automata.");
        }
        if (this.mOperand.size() > 0) {
            this.minimizeDfaHopcroft(partitionBackedSetOfPairs, bl);
        } else {
            this.directResultConstruction(this.mOperand);
        }
        this.printExitMessage();
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    private void minimizeDfaHopcroft(PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs, boolean bl) {
        this.mLogger.info((Object)"Start preprocessing data ... ");
        this.preprocessingData();
        this.mBlocks = new Partition();
        this.mCords = new Partition();
        this.mLogger.info((Object)"completed preprocessing data.");
        this.mLogger.info((Object)"Start intitializing partitions ... ");
        this.mBlocks.init(this.mNumberOfStates);
        this.makeInitialPartition(partitionBackedSetOfPairs);
        this.makeTransitionPartition();
        this.mLogger.info((Object)"completed initialization of partitions.");
        this.mAdjacent = new int[this.mNumberOfTransitions];
        this.mF = new int[this.mNumberOfStates + 1];
        this.makeAdjacent(this.mLabelHeads);
        this.mLogger.info((Object)"Start with Hopcroft - algorithm");
        int n = 1;
        int n2 = 0;
        while (n2 < this.mCords.mNumberOfSets) {
            int n3 = this.mCords.mFirst[n2];
            while (n3 < this.mCords.mPast[n2]) {
                this.mBlocks.mark(this.mLabelTails[this.mCords.mElements[n3]]);
                ++n3;
            }
            this.mBlocks.split();
            ++n2;
            while (n < this.mBlocks.mNumberOfSets) {
                n3 = this.mBlocks.mFirst[n];
                while (n3 < this.mBlocks.mPast[n]) {
                    int n4 = this.mF[this.mBlocks.mElements[n3]];
                    while (n4 < this.mF[this.mBlocks.mElements[n3] + 1]) {
                        this.mCords.mark(this.mAdjacent[n4]);
                        ++n4;
                    }
                    ++n3;
                }
                this.mCords.split();
                ++n;
            }
        }
        this.buildResult(bl);
    }

    private void preprocessingData() {
        this.mNumberOfFinalStates = this.mOperand.getFinalStates().size();
        this.mFinalStates = new int[this.mNumberOfFinalStates];
        this.mNumberOfStates = this.mOperand.size();
        this.mNumberOfLetters = this.mOperand.getVpAlphabet().getInternalAlphabet().size();
        this.initializeMappings();
        this.initializeLables();
        this.mInitialState = this.mState2int.get(this.mOperand.getInitialStates().iterator().next());
        Iterator<STATE> iterator = this.mOperand.getFinalStates().iterator();
        int n = -1;
        while (iterator.hasNext()) {
            this.mFinalStates[++n] = this.mState2int.get(iterator.next());
        }
    }

    private void initializeMappings() {
        this.mInt2state = new ArrayList(this.mNumberOfStates);
        this.mState2int = new HashMap(MinimizeDfaHopcroftArrays.computeHashCap(this.mNumberOfStates));
        this.mInt2letter = new ArrayList(this.mNumberOfLetters);
        this.mLetter2int = new HashMap(MinimizeDfaHopcroftArrays.computeHashCap(this.mNumberOfLetters));
        int n = -1;
        for (Object object : this.mOperand.getStates()) {
            this.mInt2state.add(object);
            this.mState2int.put(object, ++n);
        }
        n = -1;
        for (Object object : this.mOperand.getVpAlphabet().getInternalAlphabet()) {
            this.mInt2letter.add(object);
            this.mLetter2int.put(object, ++n);
        }
    }

    private void initializeLables() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        int n = 0;
        int n2 = 0;
        while (n2 < this.mInt2state.size()) {
            STATE STATE = this.mInt2state.get(n2);
            for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(STATE)) {
                arrayList.add(this.mLetter2int.get(outgoingInternalTransition.getLetter()));
                arrayList3.add(this.mState2int.get(STATE));
                arrayList2.add(this.mState2int.get(outgoingInternalTransition.getSucc()));
                ++n;
            }
            ++n2;
        }
        this.mNumberOfTransitions = n;
        this.mLabels = new int[this.mNumberOfTransitions];
        this.mLabelHeads = new int[this.mNumberOfTransitions];
        this.mLabelTails = new int[this.mNumberOfTransitions];
        n2 = 0;
        while (n2 < this.mNumberOfTransitions) {
            this.mLabels[n2] = (Integer)arrayList.get(n2);
            this.mLabelHeads[n2] = (Integer)arrayList2.get(n2);
            this.mLabelTails[n2] = (Integer)arrayList3.get(n2);
            ++n2;
        }
    }

    private void makeInitialPartition(PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs) {
        this.mSetsWithMarkedElements = new int[this.mNumberOfTransitions + 1];
        this.mNumberOfMarkedElemInSet = new int[this.mNumberOfTransitions + 1];
        if (partitionBackedSetOfPairs == null || partitionBackedSetOfPairs.getRelation().isEmpty()) {
            if (this.mNumberOfFinalStates > 0) {
                int[] nArray = this.mFinalStates;
                int n = this.mFinalStates.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    this.mBlocks.mark(n3);
                    ++n2;
                }
                this.mBlocks.split();
            }
        } else {
            Iterator iterator = partitionBackedSetOfPairs.getRelation().iterator();
            while (iterator.hasNext()) {
                Set set = (Set)iterator.next();
                for (Object e : set) {
                    this.mBlocks.mark(this.mState2int.get(e));
                }
                this.mBlocks.split();
            }
        }
    }

    private void makeTransitionPartition() {
        this.mCords.init(this.mNumberOfTransitions);
        if (this.mNumberOfTransitions > 0) {
            Integer[] integerArray = new Integer[this.mCords.mElements.length];
            System.arraycopy(this.mCords.mElements, 0, integerArray, 0, integerArray.length);
            Arrays.sort(integerArray, (n, n2) -> Integer.compare(this.mLabels[n], this.mLabels[n2]));
            System.arraycopy(integerArray, 0, this.mCords.mElements, 0, integerArray.length);
            this.mNumberOfMarkedElemInSet[0] = 0;
            this.mCords.mNumberOfSets = 0;
            int n3 = this.mLabels[this.mCords.mElements[0]];
            int n4 = 0;
            while (n4 < this.mNumberOfTransitions) {
                int n5 = this.mCords.mElements[n4];
                if (this.mLabels[n5] != n3) {
                    n3 = this.mLabels[n5];
                    this.mCords.mPast[this.mCords.mNumberOfSets++] = n4;
                    this.mCords.mFirst[this.mCords.mNumberOfSets] = n4;
                    this.mNumberOfMarkedElemInSet[this.mCords.mNumberOfSets] = 0;
                }
                this.mCords.mSetElemBelongsTo[n5] = this.mCords.mNumberOfSets;
                this.mCords.mLocationOfElem[n5] = n4++;
            }
            this.mCords.mPast[this.mCords.mNumberOfSets++] = this.mNumberOfTransitions;
        }
    }

    private void makeAdjacent(int[] nArray) {
        int n = 0;
        while (n <= this.mNumberOfStates) {
            this.mF[n] = 0;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.mNumberOfTransitions) {
            int n3 = nArray[n2];
            this.mF[n3] = this.mF[n3] + 1;
            ++n2;
        }
        n = 0;
        while (n < this.mNumberOfStates) {
            int n4 = n + 1;
            this.mF[n4] = this.mF[n4] + this.mF[n];
            ++n;
        }
        n2 = this.mNumberOfTransitions - 1;
        while (n2 >= 0) {
            int n5 = nArray[n2];
            int n6 = this.mF[n5] - 1;
            this.mF[n5] = n6;
            this.mAdjacent[n6] = n2--;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void buildResult(boolean bl) {
        int n;
        ArrayList<STATE> arrayList;
        int n2;
        ArrayList arrayList2 = new ArrayList(this.mBlocks.mNumberOfSets);
        int n3 = this.mBlocks.mSetElemBelongsTo[this.mInitialState];
        int[] nArray = new int[this.mNumberOfFinalStates];
        int n4 = 0;
        while (n4 < this.mNumberOfFinalStates) {
            nArray[n4] = this.mBlocks.mSetElemBelongsTo[this.mFinalStates[n4]];
            ++n4;
        }
        HashMap hashMap = bl ? new HashMap(MinimizeDfaHopcroftArrays.computeHashCap(this.mOperand.size())) : null;
        this.startResultConstruction();
        int n5 = 0;
        while (n5 < this.mBlocks.mNumberOfSets) {
            boolean bl2;
            void var10_14;
            n2 = this.mBlocks.mFirst[n5];
            int n6 = this.mBlocks.mPast[n5];
            arrayList = new ArrayList(n6 - n2);
            int n7 = n2;
            while (var10_14 < n6) {
                bl2 = this.mBlocks.mElements[var10_14];
                arrayList.add(this.mInt2state.get(bl2 ? 1 : 0));
                ++var10_14;
            }
            Object object = this.mStateFactory.merge(arrayList);
            if (hashMap != null) {
                for (Object e : arrayList) {
                    hashMap.put(e, object);
                }
            }
            arrayList2.add(object);
            bl2 = false;
            int[] nArray2 = nArray;
            int n8 = nArray.length;
            n = 0;
            while (n < n8) {
                int n9 = nArray2[n];
                if (n5 == n9) {
                    bl2 = true;
                    break;
                }
                ++n;
            }
            boolean bl3 = n5 == n3;
            this.addState(bl3, bl2, object);
            ++n5;
        }
        n5 = 0;
        while (n5 < this.mBlocks.mNumberOfSets) {
            n2 = this.mBlocks.mFirst[n5];
            STATE STATE = this.mInt2state.get(this.mBlocks.mElements[n2]);
            arrayList = arrayList2.get(n5);
            for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(STATE)) {
                int n10 = this.mState2int.get(outgoingInternalTransition.getSucc());
                n = this.mBlocks.mSetElemBelongsTo[n10];
                Object e = arrayList2.get(n);
                this.addInternalTransition(arrayList, outgoingInternalTransition.getLetter(), e);
            }
            this.finishResultConstruction(hashMap, true);
            ++n5;
        }
    }

    @Override
    protected Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        return this.checkLanguageEquivalence(iMinimizationCheckResultStateFactory);
    }

    public class Partition {
        private int mNumberOfSets;
        private int[] mElements;
        private int[] mLocationOfElem;
        private int[] mSetElemBelongsTo;
        private int[] mFirst;
        private int[] mPast;

        public void init(int n) {
            this.mNumberOfSets = n > 0 ? 1 : 0;
            this.mElements = new int[n];
            this.mLocationOfElem = new int[n];
            this.mSetElemBelongsTo = new int[n];
            this.mFirst = new int[n];
            this.mPast = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.mElements[n2] = this.mLocationOfElem[n2] = n2;
                this.mSetElemBelongsTo[n2] = 0;
                ++n2;
            }
            if (this.mNumberOfSets == 1) {
                this.mFirst[0] = 0;
                this.mPast[0] = n;
            }
        }

        public void mark(int n) {
            int n2 = this.mSetElemBelongsTo[n];
            int n3 = this.mLocationOfElem[n];
            int n4 = this.mFirst[n2] + MinimizeDfaHopcroftArrays.this.mNumberOfMarkedElemInSet[n2];
            this.mElements[n3] = this.mElements[n4];
            this.mLocationOfElem[this.mElements[n3]] = n3;
            this.mElements[n4] = n;
            this.mLocationOfElem[n] = n4;
            if (MinimizeDfaHopcroftArrays.this.mNumberOfMarkedElemInSet[n2] == 0) {
                MinimizeDfaHopcroftArrays.this.mSetsWithMarkedElements[MinimizeDfaHopcroftArrays.this.mW++] = n2;
            }
            int n5 = n2;
            MinimizeDfaHopcroftArrays.this.mNumberOfMarkedElemInSet[n5] = MinimizeDfaHopcroftArrays.this.mNumberOfMarkedElemInSet[n5] + 1;
        }

        public void split() {
            while (MinimizeDfaHopcroftArrays.this.mW > 0) {
                int n;
                int n2;
                if ((n2 = this.mFirst[n = MinimizeDfaHopcroftArrays.this.mSetsWithMarkedElements[--MinimizeDfaHopcroftArrays.this.mW]] + MinimizeDfaHopcroftArrays.this.mNumberOfMarkedElemInSet[n]) == this.mPast[n]) {
                    MinimizeDfaHopcroftArrays.this.mNumberOfMarkedElemInSet[n] = 0;
                    continue;
                }
                if (MinimizeDfaHopcroftArrays.this.mNumberOfMarkedElemInSet[n] <= this.mPast[n] - n2) {
                    this.mFirst[this.mNumberOfSets] = this.mFirst[n];
                    this.mPast[this.mNumberOfSets] = this.mFirst[n] = n2;
                } else {
                    this.mPast[this.mNumberOfSets] = this.mPast[n];
                    this.mFirst[this.mNumberOfSets] = this.mPast[n] = n2;
                }
                int n3 = this.mFirst[this.mNumberOfSets];
                while (n3 < this.mPast[this.mNumberOfSets]) {
                    this.mSetElemBelongsTo[this.mElements[n3]] = this.mNumberOfSets;
                    ++n3;
                }
                MinimizeDfaHopcroftArrays.this.mNumberOfMarkedElemInSet[this.mNumberOfSets++] = 0;
                MinimizeDfaHopcroftArrays.this.mNumberOfMarkedElemInSet[n] = 0;
            }
        }
    }
}

