/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders.DawgBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgStateFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class MappedDawgBuilder<LETTER, COLNAMES, V1, V2>
extends DawgBuilder<LETTER> {
    private final DawgStateFactory<LETTER> mDawgStateFactory;
    private final DawgFactory<LETTER, COLNAMES> mDawgFactory;
    private final Function<V1, V2> mOperation;
    private final Map<DawgState<LETTER, V1>, DawgState<LETTER, V2>> mCache;

    public MappedDawgBuilder(DawgFactory<LETTER, COLNAMES> dawgFactory, Function<V1, V2> function) {
        this.mDawgFactory = dawgFactory;
        this.mDawgStateFactory = this.mDawgFactory.getDawgStateFactory();
        this.mOperation = function;
        this.mCache = new HashMap<DawgState<LETTER, V1>, DawgState<LETTER, V2>>();
    }

    public DawgState<LETTER, V2> map(DawgState<LETTER, V1> dawgState) {
        DawgState<LETTER, Object> dawgState2 = this.mCache.get(dawgState);
        if (dawgState2 != null) {
            return dawgState2;
        }
        if (dawgState.isFinal()) {
            dawgState2 = this.mDawgStateFactory.createFinalState(this.mOperation.apply(dawgState.getFinalValue()));
        } else {
            HashMap hashMap = new HashMap();
            for (Map.Entry<DawgState<LETTER, V1>, DawgLetter<LETTER>> entry : dawgState.getTransitions().entrySet()) {
                MappedDawgBuilder.addLetterToMap(hashMap, this.map(entry.getKey()), entry.getValue());
            }
            dawgState2 = this.mDawgStateFactory.createIntermediateState(hashMap);
        }
        this.mCache.put(dawgState, dawgState2);
        return dawgState2;
    }
}

