/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.LoopAccelerationUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanDecomposition;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanLoopAccelerationStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanUpdate;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.LinearUpdate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.SimultaneousUpdate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JordanLoopAcceleration {
    private static final boolean CONCATENATE_WITH_NEGATION_OF_GUARD = false;
    private static final boolean REFLEXIVE_TRANSITIVE_CLOSURE = false;
    public static final String UNSUPPORTED_PREFIX = "JordanLoopAcceleration failed";

    private JordanLoopAcceleration() {
    }

    public static JordanLoopAccelerationResult accelerateLoop(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, UnmodifiableTransFormula unmodifiableTransFormula, boolean bl) {
        UnmodifiableTransFormula unmodifiableTransFormula2;
        int n;
        SimultaneousUpdate simultaneousUpdate;
        ILogger iLogger = iUltimateServiceProvider.getLoggingService().getLogger(JordanLoopAcceleration.class);
        try {
            simultaneousUpdate = SimultaneousUpdate.fromTransFormula((IUltimateServiceProvider)iUltimateServiceProvider, (TransFormula)unmodifiableTransFormula, (ManagedScript)managedScript);
        }
        catch (SimultaneousUpdate.SimultaneousUpdateException simultaneousUpdateException) {
            JordanLoopAccelerationStatisticsGenerator jordanLoopAccelerationStatisticsGenerator = new JordanLoopAccelerationStatisticsGenerator(-1, -1, -1, -1, (NestedMap2<Integer, Integer, Integer>)new NestedMap2(), simultaneousUpdateException.getMessage());
            return new JordanLoopAccelerationResult(JordanLoopAccelerationResult.AccelerationStatus.SIMULTANEOUS_UPDATE_FAILED, simultaneousUpdateException.getMessage(), null, jordanLoopAccelerationStatisticsGenerator);
        }
        int n2 = simultaneousUpdate.getDeterministicAssignment().size();
        int n3 = simultaneousUpdate.getDeterministicArrayWrites().size();
        int n4 = simultaneousUpdate.getHavocedVars().size();
        Set<Sort> set = JordanLoopAcceleration.getNonIntegerSorts(simultaneousUpdate.getDeterministicAssignment().keySet());
        if (!set.isEmpty()) {
            String string = "Some updated variables are of non-integer sorts : " + String.valueOf(set);
            JordanLoopAccelerationStatisticsGenerator jordanLoopAccelerationStatisticsGenerator = new JordanLoopAccelerationStatisticsGenerator(n2, n4, n3, -1, (NestedMap2<Integer, Integer, Integer>)new NestedMap2(), string);
            return new JordanLoopAccelerationResult(JordanLoopAccelerationResult.AccelerationStatus.NONINTEGER_UPDATE, string, null, jordanLoopAccelerationStatisticsGenerator);
        }
        Set set2 = simultaneousUpdate.getHavocedVars().stream().map(IProgramVar::getTermVariable).collect(Collectors.toSet());
        for (Map.Entry entry : simultaneousUpdate.getDeterministicAssignment().entrySet()) {
            if (DataStructureUtils.haveEmptyIntersection(new HashSet<TermVariable>(Arrays.asList(((Term)entry.getValue()).getFreeVars())), set2)) continue;
            throw new UnsupportedOperationException("JordanLoopAcceleration failed Havoced var is read!");
        }
        for (Map.Entry entry : simultaneousUpdate.getDeterministicArrayWrites().entrySet()) {
            n = 0;
            while (n < ((MultiDimensionalNestedStore)entry.getValue()).getIndices().size()) {
                if (!DataStructureUtils.haveEmptyIntersection(new HashSet(((ArrayIndex)((MultiDimensionalNestedStore)entry.getValue()).getIndices().get(n)).getFreeVars()), set2)) {
                    throw new UnsupportedOperationException("JordanLoopAcceleration failed Havoced var is read!");
                }
                if (!DataStructureUtils.haveEmptyIntersection(new HashSet<TermVariable>(Arrays.asList(((Term)((MultiDimensionalNestedStore)entry.getValue()).getValues().get(n)).getFreeVars())), set2)) {
                    throw new UnsupportedOperationException("JordanLoopAcceleration failed Havoced var is read!");
                }
                ++n;
            }
        }
        set2 = LinearUpdate.fromSimultaneousUpdate(managedScript, simultaneousUpdate);
        if (set2.getFirst() == null) {
            Map.Entry entry;
            assert (set2.getSecond() != null);
            entry = new JordanLoopAccelerationStatisticsGenerator(n2, n4, n3, -1, (NestedMap2<Integer, Integer, Integer>)new NestedMap2(), (String)set2.getSecond());
            return new JordanLoopAccelerationResult(JordanLoopAccelerationResult.AccelerationStatus.NONLINEAR_UPDATE, (String)set2.getSecond(), null, (JordanLoopAccelerationStatisticsGenerator)((Object)entry));
        }
        int n5 = ((LinearUpdate)set2.getFirst()).getReadonlyVariables().size();
        JordanUpdate jordanUpdate = JordanUpdate.fromLinearUpdate((LinearUpdate)set2.getFirst());
        if (jordanUpdate.getStatus() == JordanDecomposition.JordanDecompositionStatus.UNSUPPORTED_EIGENVALUES) {
            JordanLoopAccelerationStatisticsGenerator jordanLoopAccelerationStatisticsGenerator = new JordanLoopAccelerationStatisticsGenerator(n2, n4, n3, n5, (NestedMap2<Integer, Integer, Integer>)new NestedMap2(), "Unsupported eigenvalues");
            return new JordanLoopAccelerationResult(JordanLoopAccelerationResult.AccelerationStatus.UNSUPPORTED_EIGENVALUES, null, null, jordanLoopAccelerationStatisticsGenerator);
        }
        assert (jordanUpdate.isBlockSizeConsistent(n2, n5)) : "inconsistent blocksize";
        n = jordanUpdate.isAlternatingClosedFormRequired() ? 1 : 0;
        try {
            unmodifiableTransFormula2 = JordanLoopAcceleration.createLoopAccelerationFormula(iLogger, iUltimateServiceProvider, managedScript, simultaneousUpdate, (LinearUpdate)set2.getFirst(), jordanUpdate, unmodifiableTransFormula, bl, n != 0);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            JordanLoopAccelerationStatisticsGenerator jordanLoopAccelerationStatisticsGenerator = new JordanLoopAccelerationStatisticsGenerator(n2, n4, n3, n5, jordanUpdate.getJordanBlockSizes(), unsupportedOperationException.getMessage());
            return new JordanLoopAccelerationResult(JordanLoopAccelerationResult.AccelerationStatus.OTHER, null, null, jordanLoopAccelerationStatisticsGenerator);
        }
        JordanLoopAccelerationStatisticsGenerator jordanLoopAccelerationStatisticsGenerator = new JordanLoopAccelerationStatisticsGenerator(n2, n4, n3, n5, jordanUpdate.getJordanBlockSizes(), "");
        if (n != 0) {
            jordanLoopAccelerationStatisticsGenerator.reportAlternatingAcceleration();
        } else {
            jordanLoopAccelerationStatisticsGenerator.reportSequentialAcceleration();
        }
        if (QuantifierUtils.isQuantifierFree((Term)unmodifiableTransFormula2.getFormula())) {
            jordanLoopAccelerationStatisticsGenerator.reportQuantifierFreeResult();
        }
        return new JordanLoopAccelerationResult(JordanLoopAccelerationResult.AccelerationStatus.SUCCESS, null, unmodifiableTransFormula2, jordanLoopAccelerationStatisticsGenerator);
    }

    private static Set<Sort> getNonIntegerSorts(Set<IProgramVar> set) {
        HashSet<Sort> hashSet = new HashSet<Sort>();
        for (IProgramVar iProgramVar : set) {
            if (SmtSortUtils.isIntSort((Sort)iProgramVar.getSort())) continue;
            hashSet.add(iProgramVar.getSort());
        }
        return hashSet;
    }

    private static ClosedFormOfUpdate computeClosedFormOfUpdate(ManagedScript managedScript, SimultaneousUpdate simultaneousUpdate, TermVariable termVariable, Map<IProgramVar, TermVariable> map, Map<TermVariable, Term> map2) {
        Object object;
        Object object22;
        Object object32;
        for (Map.Entry object42 : simultaneousUpdate.getDeterministicArrayWrites().entrySet()) {
            int n = 0;
            while (n < ((MultiDimensionalNestedStore)object42.getValue()).getIndices().size()) {
                object32 = (ArrayIndex)((MultiDimensionalNestedStore)object42.getValue()).getIndices().get(n);
                for (Object object22 : object32.getFreeVars()) {
                    if (!SmtSortUtils.isArraySort((Sort)object22.getSort())) continue;
                    throw new UnsupportedOperationException("ArrayIndex contains some array variable");
                }
                if (!((SimultaneousUpdate.NondetArrayWriteConstraints)simultaneousUpdate.getNondetArrayWriteConstraints().get(object42.getKey())).isNondeterministicArrayUpdate(n)) {
                    object22 = (Term)((MultiDimensionalNestedStore)object42.getValue()).getValues().get(n);
                    object = ArrayStore.extractStores((Term)object22, (boolean)true);
                    if (!object.isEmpty()) {
                        throw new UnsupportedOperationException("Value contains some stores");
                    }
                    List list = MultiDimensionalSelect.extractSelectDeep((Term)object22);
                    if (list.size() > 1) {
                        throw new UnsupportedOperationException(String.format("Written value contains %s selects: %s", list.size(), list));
                    }
                    if (list.size() == 1) {
                        MultiDimensionalSelect multiDimensionalSelect = (MultiDimensionalSelect)list.get(0);
                        if (((MultiDimensionalNestedStore)object42.getValue()).getArray() == multiDimensionalSelect.getArray()) {
                            throw new UnsupportedOperationException(String.format("Array update for index %s writes a value that reads the same array at index %s", object32, multiDimensionalSelect.getIndex()));
                        }
                        throw new UnsupportedOperationException(String.format("Update of array %s with value that reads from array %s", ((MultiDimensionalNestedStore)object42.getValue()).getArray(), multiDimensionalSelect.getArray()));
                    }
                    for (TermVariable termVariable2 : Arrays.asList(object22.getFreeVars())) {
                        if (!SmtSortUtils.isArraySort((Sort)termVariable2.getSort())) continue;
                        throw new UnsupportedOperationException("Written value contains modified array variable");
                    }
                }
                ++n;
            }
        }
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        HashMap<IProgramVar, Term> hashMap2 = new HashMap();
        for (Map.Entry<IProgramVar, TermVariable> entry : map.entrySet()) {
            hashMap2.put((IProgramVar)entry.getKey().getTermVariable(), (Term)entry.getValue());
        }
        for (Map.Entry iProgramVar : map2.entrySet()) {
            hashMap.put((TermVariable)iProgramVar.getKey(), Substitution.apply((ManagedScript)managedScript, hashMap2, (Term)((Term)iProgramVar.getValue())));
        }
        hashMap2 = new HashMap<IProgramVar, Term>();
        for (IProgramVar hashMap22 : simultaneousUpdate.getDeterministicAssignment().keySet()) {
            hashMap2.put(hashMap22, (Term)hashMap.get(hashMap22.getTermVariable()));
        }
        HashMap<TermVariable, Term> hashMap3 = new HashMap<TermVariable, Term>(hashMap);
        for (Object object32 : simultaneousUpdate.getReadonlyVars()) {
            object = hashMap3.put(object32.getTermVariable(), (Term)map.get(object32));
            if (object != null) {
                throw new AssertionError((Object)String.format("Contradiction: %s is readonly and modified", object32));
            }
        }
        object32 = JordanLoopAcceleration.applySubstitutionToIndexAndValue(managedScript, hashMap3, simultaneousUpdate.getDeterministicArrayWrites());
        object22 = new ClosedFormOfUpdate(hashMap2, (Map<IProgramVar, MultiDimensionalNestedStore>)object32, simultaneousUpdate.getNondetArrayWriteConstraints());
        JordanLoopAcceleration.checkIndices(managedScript, (Map<IProgramVar, MultiDimensionalNestedStore>)object32, termVariable);
        return object22;
    }

    private static void checkIndices(ManagedScript managedScript, Map<IProgramVar, MultiDimensionalNestedStore> map, TermVariable termVariable) {
        for (Map.Entry<IProgramVar, MultiDimensionalNestedStore> entry : map.entrySet()) {
            MultiDimensionalNestedStore multiDimensionalNestedStore = entry.getValue();
            for (ArrayIndex arrayIndex : multiDimensionalNestedStore.getIndices()) {
                JordanLoopAcceleration.checkIndex(managedScript, arrayIndex, termVariable);
            }
        }
    }

    private static void checkIndex(ManagedScript managedScript, ArrayIndex arrayIndex, TermVariable termVariable) {
        List<IPolynomialTerm> list = arrayIndex.stream().map(term -> PolynomialTermTransformer.convert((Script)managedScript.getScript(), (Term)term)).collect(Collectors.toList());
        if (!JordanLoopAcceleration.isStrictlyMonotone(list, termVariable)) {
            throw new UnsupportedOperationException("JordanLoopAcceleration failed Index not moving: " + String.valueOf(arrayIndex));
        }
    }

    private static boolean isStrictlyMonotone(List<IPolynomialTerm> list, TermVariable termVariable) {
        boolean bl = false;
        for (IPolynomialTerm iPolynomialTerm : list) {
            for (Map.Entry entry : iPolynomialTerm.getMonomial2Coefficient().entrySet()) {
                Monomial.Occurrence occurrence = ((Monomial)entry.getKey()).isExclusiveVariable((Term)termVariable);
                if (occurrence == Monomial.Occurrence.NON_EXCLUSIVE_OR_SUBTERM) {
                    throw new UnsupportedOperationException("JordanLoopAcceleration failed Probably not monotone: " + String.valueOf(entry.getKey()));
                }
                if (occurrence != Monomial.Occurrence.AS_EXCLUSIVE_VARIABlE) continue;
                bl = true;
            }
        }
        return bl;
    }

    private static Map<IProgramVar, MultiDimensionalNestedStore> applySubstitutionToIndexAndValue(ManagedScript managedScript, Map<? extends Term, ? extends Term> map, Map<IProgramVar, MultiDimensionalNestedStore> map2) {
        HashMap<IProgramVar, MultiDimensionalNestedStore> hashMap = new HashMap<IProgramVar, MultiDimensionalNestedStore>();
        for (Map.Entry<IProgramVar, MultiDimensionalNestedStore> entry : map2.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().applySubstitution(managedScript, map));
        }
        return hashMap;
    }

    private static Term constructGuardOfClosedForm(ManagedScript managedScript, UnmodifiableTransFormula unmodifiableTransFormula, Map<IProgramVar, Term> map, Map<IProgramVar, TermVariable> map2) {
        HashMap<IProgramVar, Object> hashMap = new HashMap<IProgramVar, Object>();
        for (IProgramVar iProgramVar : unmodifiableTransFormula.getInVars().keySet()) {
            Term term = map.get(iProgramVar);
            if (term != null) {
                hashMap.put(iProgramVar, term);
                continue;
            }
            TermVariable termVariable = map2.get(iProgramVar);
            if (termVariable != null) {
                hashMap.put(iProgramVar, termVariable);
                continue;
            }
            hashMap.put(iProgramVar, (Term)unmodifiableTransFormula.getInVars().get(iProgramVar));
        }
        return TransFormulaUtils.renameInvars((TransFormula)unmodifiableTransFormula, (ManagedScript)managedScript, hashMap);
    }

    private static UnmodifiableTransFormula createLoopAccelerationFormula(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, SimultaneousUpdate simultaneousUpdate, LinearUpdate linearUpdate, JordanUpdate jordanUpdate, UnmodifiableTransFormula unmodifiableTransFormula, boolean bl, boolean bl2) {
        Term term;
        Term term2;
        Object object;
        int n = jordanUpdate.computeSizeOfLargestEv0Block();
        assert (n >= 0);
        UnmodifiableTransFormula unmodifiableTransFormula2 = TransFormulaUtils.computeGuard((UnmodifiableTransFormula)unmodifiableTransFormula, (ManagedScript)managedScript, (IUltimateServiceProvider)iUltimateServiceProvider);
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>(unmodifiableTransFormula.getInVars());
        Term term3 = JordanLoopAcceleration.constructXPrimeEqualsX(managedScript, hashMap, unmodifiableTransFormula.getOutVars());
        ArrayList<Term> arrayList = new ArrayList<Term>();
        if (n > 1) {
            int n2 = 1;
            while (n2 < n) {
                object = new ArrayList();
                int n3 = 1;
                while (n3 <= n2) {
                    term2 = JordanLoopAcceleration.constructGuardForFixedIteration(managedScript, simultaneousUpdate.getHavocedVars(), unmodifiableTransFormula2, n3, jordanUpdate, simultaneousUpdate, hashMap);
                    object.add(term2);
                    ++n3;
                }
                Term term4 = SmtUtils.and((Script)managedScript.getScript(), (Collection)object);
                term2 = jordanUpdate.constructClosedForm(managedScript, n2);
                ClosedFormOfUpdate closedFormOfUpdate = JordanLoopAcceleration.computeClosedFormOfUpdate(managedScript, simultaneousUpdate, null, hashMap, (Map<TermVariable, Term>)term2);
                Term term5 = JordanLoopAcceleration.constructClosedUpdateConstraint(managedScript.getScript(), unmodifiableTransFormula, simultaneousUpdate, closedFormOfUpdate.getScalarUpdates());
                if (!closedFormOfUpdate.getArrayUpdates().isEmpty()) {
                    throw new UnsupportedOperationException(String.format("JordanLoopAcceleration failed Consider first %s iterations separately for arrays", n));
                }
                Term term6 = SmtUtils.and((Script)managedScript.getScript(), (Term[])new Term[]{term4, term5});
                arrayList.add(term6);
                ++n2;
            }
        }
        if (bl2) {
            if (!simultaneousUpdate.getDeterministicArrayWrites().isEmpty()) {
                throw new UnsupportedOperationException("JordanLoopAcceleration failed If alternating form is required we do not yet support arrays");
            }
            if (n > 1) {
                throw new UnsupportedOperationException(String.format("JordanLoopAcceleration failed If alternating form is required we cannot yet consider first %s iterations separately", n));
            }
            object = managedScript.constructFreshTermVariable("itFinHalf", SmtSortUtils.getIntSort((Script)managedScript.getScript()));
            term = JordanLoopAcceleration.createLoopAccelerationTermAlternating(iLogger, iUltimateServiceProvider, managedScript, simultaneousUpdate, linearUpdate, jordanUpdate, unmodifiableTransFormula, unmodifiableTransFormula2, (TermVariable)object, hashMap);
        } else {
            object = managedScript.constructFreshTermVariable("itFin", SmtSortUtils.getIntSort((Script)managedScript.getScript()));
            int n4 = Math.max(n, 1);
            term = JordanLoopAcceleration.createLoopAccelerationTermSequential(iUltimateServiceProvider, managedScript, simultaneousUpdate, jordanUpdate, unmodifiableTransFormula, unmodifiableTransFormula2, (TermVariable)object, hashMap, n4);
        }
        arrayList.add(term);
        Term term7 = SmtUtils.or((Script)managedScript.getScript(), arrayList);
        term2 = JordanLoopAcceleration.buildAccelerationTransFormula(iLogger, managedScript, iUltimateServiceProvider, unmodifiableTransFormula, term7, bl, (TermVariable)object, hashMap);
        assert (LoopAccelerationUtils.checkSomePropertiesOfLoopAccelerationFormula(iUltimateServiceProvider, managedScript, unmodifiableTransFormula, (UnmodifiableTransFormula)term2, false));
        return term2;
    }

    private static UnmodifiableTransFormula buildAccelerationTransFormula(ILogger iLogger, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, UnmodifiableTransFormula unmodifiableTransFormula, Term term, boolean bl, TermVariable termVariable, Map<IProgramVar, TermVariable> map) {
        UnmodifiableTransFormula unmodifiableTransFormula2;
        Term term2 = new NnfTransformer(managedScript, iUltimateServiceProvider, NnfTransformer.QuantifierHandling.KEEP).transform(term);
        Term term3 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)term2);
        Term term4 = SmtUtils.simplify((ManagedScript)managedScript, (Term)term3, (Term)managedScript.term(null, "true", new Term[0]), (IUltimateServiceProvider)iUltimateServiceProvider, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA2);
        if (bl) {
            TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(map, unmodifiableTransFormula.getOutVars(), unmodifiableTransFormula.getNonTheoryConsts().isEmpty(), unmodifiableTransFormula.getNonTheoryConsts(), unmodifiableTransFormula.getBranchEncoders().isEmpty(), (Collection)unmodifiableTransFormula.getBranchEncoders(), unmodifiableTransFormula.getAuxVars().isEmpty());
            transFormulaBuilder.setInfeasibility(unmodifiableTransFormula.isInfeasible());
            Term term5 = SmtUtils.quantifier((Script)managedScript.getScript(), (int)0, Collections.singleton(termVariable), (Term)term4);
            term5 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA2, (Term)term5);
            transFormulaBuilder.setFormula(term5);
            unmodifiableTransFormula2 = transFormulaBuilder.finishConstruction(managedScript);
        } else {
            TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(map, unmodifiableTransFormula.getOutVars(), unmodifiableTransFormula.getNonTheoryConsts().isEmpty(), unmodifiableTransFormula.getNonTheoryConsts(), unmodifiableTransFormula.getBranchEncoders().isEmpty(), (Collection)unmodifiableTransFormula.getBranchEncoders(), false);
            transFormulaBuilder.addAuxVar(termVariable);
            transFormulaBuilder.setInfeasibility(unmodifiableTransFormula.isInfeasible());
            transFormulaBuilder.setFormula(term4);
            unmodifiableTransFormula2 = transFormulaBuilder.finishConstruction(managedScript);
        }
        return unmodifiableTransFormula2;
    }

    private static Term createLoopAccelerationTermSequential(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, SimultaneousUpdate simultaneousUpdate, JordanUpdate jordanUpdate, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, TermVariable termVariable, Map<IProgramVar, TermVariable> map, int n) {
        Term term;
        if (n < 1) {
            throw new IllegalArgumentException("Cannot construct constraint for non-positive iterations");
        }
        Script script = managedScript.getScript();
        Map<TermVariable, Term> map2 = jordanUpdate.constructClosedForm(managedScript, termVariable, null, Iterations.ALL);
        ClosedFormOfUpdate closedFormOfUpdate = JordanLoopAcceleration.computeClosedFormOfUpdate(managedScript, simultaneousUpdate, termVariable, unmodifiableTransFormula.getInVars(), map2);
        map2 = closedFormOfUpdate.getScalarUpdates();
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int n2 = 1;
        while (n2 < n) {
            term = JordanLoopAcceleration.constructGuardForFixedIteration(managedScript, simultaneousUpdate.getHavocedVars(), unmodifiableTransFormula2, n2, jordanUpdate, simultaneousUpdate, map);
            arrayList.add(term);
            ++n2;
        }
        arrayList.add(JordanLoopAcceleration.constructGuardForFixedIteration(managedScript, simultaneousUpdate.getHavocedVars(), unmodifiableTransFormula2, n, jordanUpdate, simultaneousUpdate, map));
        Term term2 = script.term(">=", new Term[]{termVariable, script.numeral(BigInteger.valueOf(n))});
        arrayList.add(term2);
        term = managedScript.constructFreshTermVariable("it", SmtSortUtils.getIntSort((Script)script));
        Term term3 = JordanLoopAcceleration.constructIterationRange(script, BigInteger.valueOf(n), (TermVariable)term, BigInteger.ONE, termVariable);
        Object object = jordanUpdate.constructClosedForm(managedScript, (TermVariable)term, null, Iterations.ALL);
        ClosedFormOfUpdate closedFormOfUpdate2 = JordanLoopAcceleration.computeClosedFormOfUpdate(managedScript, simultaneousUpdate, (TermVariable)term, map, object);
        Term term4 = JordanLoopAcceleration.constructGuardAfterIntermediateIterations(managedScript, simultaneousUpdate.getHavocedVars(), unmodifiableTransFormula2, closedFormOfUpdate2.getScalarUpdates());
        object = Util.implies((Script)script, (Term[])new Term[]{term3, term4});
        HashSet<Term> hashSet = new HashSet<Term>();
        hashSet.add(term);
        Term term5 = SmtUtils.quantifier((Script)script, (int)1, hashSet, (Term)object);
        arrayList.add(term5);
        object = JordanLoopAcceleration.constructArrayUpdateConstraints(iUltimateServiceProvider, managedScript, unmodifiableTransFormula, termVariable, (TermVariable)term, closedFormOfUpdate2);
        arrayList.addAll((Collection<Term>)object);
        term3 = JordanLoopAcceleration.constructClosedUpdateConstraint(script, unmodifiableTransFormula, simultaneousUpdate, map2);
        arrayList.add(term3);
        closedFormOfUpdate2 = SmtUtils.and((Script)script, arrayList);
        return closedFormOfUpdate2;
    }

    private static List<Term> constructArrayUpdateConstraints(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, UnmodifiableTransFormula unmodifiableTransFormula, TermVariable termVariable, TermVariable termVariable2, ClosedFormOfUpdate closedFormOfUpdate) {
        ArrayIndex arrayIndex;
        ArrayList<Term> arrayList;
        StringBuilder stringBuilder;
        MultiDimensionalNestedStore multiDimensionalNestedStore;
        Script script = managedScript.getScript();
        for (Map.Entry<IProgramVar, MultiDimensionalNestedStore> entry : closedFormOfUpdate.getArrayUpdates().entrySet()) {
            IProgramVar iProgramVar = entry.getKey();
            multiDimensionalNestedStore = entry.getValue();
            if (multiDimensionalNestedStore.getIndices().size() <= 1) continue;
            stringBuilder = new StringBuilder();
            int n = 0;
            int n2 = 0;
            arrayList = multiDimensionalNestedStore.getIndices();
            int term2 = 0;
            while (term2 < arrayList.size()) {
                int term3 = term2 + 1;
                while (term3 < arrayList.size()) {
                    ++n;
                    arrayIndex = ((ArrayIndex)arrayList.get(term2)).minus(script, (ArrayIndex)arrayList.get(term3));
                    stringBuilder.append(arrayIndex);
                    stringBuilder.append(" ");
                    if (arrayIndex.getFreeVars().isEmpty()) {
                        ++n2;
                    }
                    ++term3;
                }
                ++term2;
            }
            if (n <= n2) continue;
            throw new UnsupportedOperationException(String.format("%s updates on array %s. %s indexPairs, %s moving in lockstep. Differences: %s", arrayList.size(), iProgramVar, n, n2, stringBuilder.toString()));
        }
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        for (Map.Entry entry : closedFormOfUpdate.getArrayUpdates().entrySet()) {
            Term term;
            multiDimensionalNestedStore = (IProgramVar)entry.getKey();
            stringBuilder = (MultiDimensionalNestedStore)entry.getValue();
            List<TermVariable> list = JordanLoopAcceleration.constructIdxTermVariables(managedScript, stringBuilder.getDimension());
            Term[] termArray = new Term[stringBuilder.getIndices().size()];
            arrayList = JordanLoopAcceleration.constructIterationRange(script, BigInteger.ZERO, termVariable2, BigInteger.ONE, termVariable);
            int n = 0;
            while (n < stringBuilder.getIndices().size()) {
                ArrayIndex arrayIndex2 = (ArrayIndex)stringBuilder.getIndices().get(n);
                arrayIndex = SmtUtils.pairwiseEquality((Script)script, list, (List)arrayIndex2);
                termArray[n] = SmtUtils.and((Script)script, (Term[])new Term[]{arrayList, arrayIndex});
                ++n;
            }
            arrayList = new ArrayList<Term>();
            Term term2 = new MultiDimensionalSelect((Term)unmodifiableTransFormula.getOutVars().get(multiDimensionalNestedStore), new ArrayIndex(list)).toTerm(script);
            Term term3 = new ArrayList();
            int n3 = 0;
            while (n3 < stringBuilder.getIndices().size()) {
                Term term4;
                if (!closedFormOfUpdate.getNondetArrayWriteConstraints().get(multiDimensionalNestedStore).isNondeterministicArrayUpdate(n3)) {
                    Term term5;
                    term4 = (Term)stringBuilder.getValues().get(n3);
                    term = term5 = SmtUtils.equality((Script)script, (Term[])new Term[]{term2, term4});
                } else {
                    term = closedFormOfUpdate.getNondetArrayWriteConstraints().get(multiDimensionalNestedStore).constructConstraints(script, n3, term2);
                }
                term4 = SmtUtils.implies((Script)script, (Term)termArray[n3], (Term)term);
                term3.add(term4);
                ++n3;
            }
            arrayIndex = SmtUtils.quantifier((Script)script, (int)1, Collections.singleton(termVariable2), (Term)SmtUtils.and((Script)script, term3));
            term = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (Term)arrayIndex, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA2);
            arrayList.add(term);
            term2 = SmtUtils.equality((Script)script, (Term[])new Term[]{new MultiDimensionalSelect((Term)unmodifiableTransFormula.getOutVars().get(multiDimensionalNestedStore), new ArrayIndex(list)).toTerm(script), new MultiDimensionalSelect((Term)unmodifiableTransFormula.getInVars().get(multiDimensionalNestedStore), new ArrayIndex(list)).toTerm(script)});
            term3 = SmtUtils.quantifier((Script)script, (int)0, Collections.singleton(termVariable2), (Term)SmtUtils.or((Script)script, (Term[])termArray));
            arrayIndex = SmtUtils.implies((Script)script, (Term)SmtUtils.not((Script)managedScript.getScript(), (Term)term3), (Term)term2);
            term = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (Term)arrayIndex, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA2);
            arrayList.add(term);
            term2 = SmtUtils.and((Script)script, arrayList);
            term3 = SmtUtils.quantifier((Script)script, (int)1, list, (Term)term2);
            arrayList2.add(term3);
        }
        return arrayList2;
    }

    private static List<TermVariable> constructIdxTermVariables(ManagedScript managedScript, int n) {
        assert (n >= 1);
        Sort sort = SmtSortUtils.getIntSort((Script)managedScript.getScript());
        if (n == 1) {
            return Collections.singletonList(managedScript.constructFreshTermVariable("idx", sort));
        }
        if (n == 2) {
            return Arrays.asList(managedScript.constructFreshTermVariable("idxDim1", sort), managedScript.constructFreshTermVariable("idxDim2", sort));
        }
        throw new UnsupportedOperationException("JordanLoopAcceleration failed Dimension not yet supported: " + n);
    }

    private static Term constructIterationRange(Script script, BigInteger bigInteger, TermVariable termVariable, BigInteger bigInteger2, TermVariable termVariable2) {
        Term term = script.term("<=", new Term[]{script.numeral(bigInteger), termVariable});
        Term term2 = script.term("<=", new Term[]{termVariable, SmtUtils.minus((Script)script, (Term[])new Term[]{termVariable2, script.numeral(bigInteger2)})});
        return Util.and((Script)script, (Term[])new Term[]{term, term2});
    }

    private static Term constructGuardForFixedIteration(ManagedScript managedScript, Set<IProgramVar> set, UnmodifiableTransFormula unmodifiableTransFormula, int n, JordanUpdate jordanUpdate, SimultaneousUpdate simultaneousUpdate, Map<IProgramVar, TermVariable> map) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        if (n == 1) {
            return unmodifiableTransFormula.getFormula();
        }
        Map<TermVariable, Term> map2 = jordanUpdate.constructClosedForm(managedScript, n - 1);
        ClosedFormOfUpdate closedFormOfUpdate = JordanLoopAcceleration.computeClosedFormOfUpdate(managedScript, simultaneousUpdate, null, map, map2);
        return JordanLoopAcceleration.constructGuardAfterIntermediateIterations(managedScript, set, unmodifiableTransFormula, closedFormOfUpdate.getScalarUpdates());
    }

    private static Term constructGuardAfterIntermediateIterations(ManagedScript managedScript, Set<IProgramVar> set, UnmodifiableTransFormula unmodifiableTransFormula, Map<IProgramVar, Term> map) {
        HashMap<IProgramVar, TermVariable> hashMap = JordanLoopAcceleration.constructHavocReplacementsForIntermediateIteration(managedScript, set);
        HashSet hashSet = new HashSet(hashMap.values());
        Term term = JordanLoopAcceleration.constructGuardOfClosedForm(managedScript, unmodifiableTransFormula, map, hashMap);
        return SmtUtils.quantifier((Script)managedScript.getScript(), (int)0, hashSet, (Term)term);
    }

    private static Term constructGuardAfterFinalIteration(ManagedScript managedScript, Set<IProgramVar> set, Map<IProgramVar, TermVariable> map, UnmodifiableTransFormula unmodifiableTransFormula, Map<IProgramVar, Term> map2) {
        HashMap<IProgramVar, TermVariable> hashMap = JordanLoopAcceleration.constructHavocReplacementsForFinalIteration(set, map);
        return JordanLoopAcceleration.constructGuardOfClosedForm(managedScript, unmodifiableTransFormula, map2, hashMap);
    }

    private static HashMap<IProgramVar, TermVariable> constructHavocReplacementsForIntermediateIteration(ManagedScript managedScript, Set<IProgramVar> set) {
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>();
        for (IProgramVar iProgramVar : set) {
            String string = iProgramVar.getTermVariable().getName() + "_havocIntermIteration";
            hashMap.put(iProgramVar, managedScript.variable(string, iProgramVar.getSort()));
        }
        return hashMap;
    }

    private static HashMap<IProgramVar, TermVariable> constructHavocReplacementsForFinalIteration(Set<IProgramVar> set, Map<IProgramVar, TermVariable> map) {
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>();
        for (IProgramVar iProgramVar : set) {
            hashMap.put(iProgramVar, map.get(iProgramVar));
        }
        return hashMap;
    }

    private static Term constructClosedUpdateConstraint(Script script, UnmodifiableTransFormula unmodifiableTransFormula, SimultaneousUpdate simultaneousUpdate, Map<IProgramVar, Term> map) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Map.Entry entry : simultaneousUpdate.getDeterministicAssignment().entrySet()) {
            Term term = (Term)unmodifiableTransFormula.getOutVars().get(entry.getKey());
            Term term2 = map.get(entry.getKey());
            Term term3 = SmtUtils.binaryEquality((Script)script, (Term)term, (Term)term2);
            arrayList.add(term3);
        }
        return SmtUtils.and((Script)script, arrayList);
    }

    @Deprecated
    private static Term constructArrayUpdateEquality(Script script, Map<IProgramVar, TermVariable> map, NestedMap2<IProgramVar, ArrayIndex, Term> nestedMap2) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Triple triple : nestedMap2.entrySet()) {
            TermVariable termVariable = map.get(triple.getFirst());
            MultiDimensionalSelect multiDimensionalSelect = new MultiDimensionalSelect((Term)termVariable, (ArrayIndex)triple.getSecond());
            arrayList.add(SmtUtils.equality((Script)script, (Term[])new Term[]{multiDimensionalSelect.toTerm(script), (Term)triple.getThird()}));
        }
        return SmtUtils.and((Script)script, arrayList);
    }

    private static Term createLoopAccelerationTermAlternating(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, SimultaneousUpdate simultaneousUpdate, LinearUpdate linearUpdate, JordanUpdate jordanUpdate, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, TermVariable termVariable, Map<IProgramVar, TermVariable> map) {
        Script script = managedScript.getScript();
        Sort sort = SmtSortUtils.getIntSort((Script)script);
        Term term = script.term(">", new Term[]{termVariable, script.numeral(BigInteger.ZERO)});
        Term term2 = jordanUpdate.constructClosedForm(managedScript, null, termVariable, Iterations.EVEN);
        ClosedFormOfUpdate closedFormOfUpdate = JordanLoopAcceleration.computeClosedFormOfUpdate(managedScript, simultaneousUpdate, null, map, term2);
        term2 = JordanLoopAcceleration.constructGuardAfterFinalIteration(managedScript, simultaneousUpdate.getHavocedVars(), unmodifiableTransFormula.getOutVars(), unmodifiableTransFormula2, closedFormOfUpdate.getScalarUpdates());
        Term term3 = jordanUpdate.constructClosedForm(managedScript, null, termVariable, Iterations.ODD);
        ClosedFormOfUpdate closedFormOfUpdate2 = JordanLoopAcceleration.computeClosedFormOfUpdate(managedScript, simultaneousUpdate, null, map, term3);
        term3 = JordanLoopAcceleration.constructGuardAfterFinalIteration(managedScript, simultaneousUpdate.getHavocedVars(), unmodifiableTransFormula.getOutVars(), unmodifiableTransFormula2, closedFormOfUpdate2.getScalarUpdates());
        TermVariable termVariable2 = managedScript.constructFreshTermVariable("itHalf", sort);
        Term term4 = script.term("<=", new Term[]{script.numeral(BigInteger.ONE), termVariable2});
        Term term5 = script.term("<=", new Term[]{termVariable2, script.term("-", new Term[]{termVariable, script.numeral(BigInteger.ONE)})});
        Term term6 = Util.and((Script)script, (Term[])new Term[]{term4, term5});
        Term term7 = jordanUpdate.constructClosedForm(managedScript, null, termVariable2, Iterations.EVEN);
        ClosedFormOfUpdate closedFormOfUpdate3 = JordanLoopAcceleration.computeClosedFormOfUpdate(managedScript, simultaneousUpdate, null, map, term7);
        term7 = JordanLoopAcceleration.constructGuardAfterIntermediateIterations(managedScript, simultaneousUpdate.getHavocedVars(), unmodifiableTransFormula2, closedFormOfUpdate3.getScalarUpdates());
        Term term8 = Util.implies((Script)script, (Term[])new Term[]{term6, term7});
        Term term9 = script.term("<=", new Term[]{script.numeral(BigInteger.ZERO), termVariable2});
        Term term10 = Util.and((Script)script, (Term[])new Term[]{term9, term5});
        Term term11 = jordanUpdate.constructClosedForm(managedScript, null, termVariable2, Iterations.ODD);
        ClosedFormOfUpdate closedFormOfUpdate4 = JordanLoopAcceleration.computeClosedFormOfUpdate(managedScript, simultaneousUpdate, null, map, term11);
        term11 = JordanLoopAcceleration.constructGuardAfterIntermediateIterations(managedScript, simultaneousUpdate.getHavocedVars(), unmodifiableTransFormula2, closedFormOfUpdate4.getScalarUpdates());
        Term term12 = Util.implies((Script)script, (Term[])new Term[]{term10, term11});
        Term term13 = Util.and((Script)script, (Term[])new Term[]{term8, term12});
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        hashSet.add(termVariable2);
        Term term14 = SmtUtils.quantifier((Script)script, (int)1, hashSet, (Term)term13);
        Term term15 = script.term("<=", new Term[]{termVariable2, termVariable});
        Term term16 = Util.and((Script)script, (Term[])new Term[]{term4, term15});
        Term term17 = Util.implies((Script)script, (Term[])new Term[]{term16, term7});
        Term term18 = Util.implies((Script)script, (Term[])new Term[]{term10, term11});
        Term term19 = Util.and((Script)script, (Term[])new Term[]{term17, term18});
        Term term20 = SmtUtils.quantifier((Script)script, (int)1, hashSet, (Term)term19);
        Term term21 = JordanLoopAcceleration.constructClosedUpdateConstraint(script, unmodifiableTransFormula, simultaneousUpdate, closedFormOfUpdate.getScalarUpdates());
        Term term22 = JordanLoopAcceleration.constructClosedUpdateConstraint(script, unmodifiableTransFormula, simultaneousUpdate, closedFormOfUpdate2.getScalarUpdates());
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(term);
        arrayList.add(unmodifiableTransFormula2.getFormula());
        arrayList.add(term14);
        arrayList.add(term21);
        Term term23 = SmtUtils.and((Script)script, arrayList);
        Term term24 = script.term(">=", new Term[]{termVariable, script.numeral(BigInteger.ZERO)});
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        arrayList2.add(term24);
        arrayList2.add(unmodifiableTransFormula2.getFormula());
        arrayList2.add(term20);
        arrayList2.add(term22);
        Term term25 = SmtUtils.and((Script)script, arrayList2);
        Term term26 = Util.or((Script)script, (Term[])new Term[]{term23, term25});
        return term26;
    }

    private static Term constructXPrimeEqualsX(ManagedScript managedScript, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        IProgramVar iProgramVar2;
        Term[] termArray = new Term[map2.size()];
        int n = 0;
        for (IProgramVar iProgramVar2 : map2.keySet()) {
            if (!map.containsKey(iProgramVar2)) {
                TermVariable termVariable = managedScript.constructFreshTermVariable(iProgramVar2.getGloballyUniqueId(), iProgramVar2.getTermVariable().getSort());
                map.put(iProgramVar2, termVariable);
            }
            termArray[n] = managedScript.term(null, "=", new Term[]{(Term)map2.get(iProgramVar2), (Term)map.get(iProgramVar2)});
            ++n;
        }
        iProgramVar2 = Util.and((Script)managedScript.getScript(), (Term[])termArray);
        return iProgramVar2;
    }

    private static boolean checkCorrectnessOfQuantifierElimination(ILogger iLogger, Script script, Term term, Term term2) {
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{term, Util.not((Script)script, (Term)term2)})) == Script.LBool.SAT) {
            throw new AssertionError((Object)"Something went wrong in quantifier elimination.");
        }
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{term, Util.not((Script)script, (Term)term2)})) == Script.LBool.UNKNOWN) {
            iLogger.warn((Object)"Unable to prove correctness of quantifier elimination.");
        }
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{term2, Util.not((Script)script, (Term)term)})) == Script.LBool.SAT) {
            throw new AssertionError((Object)"Something went wrong in quantifier elimination.");
        }
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{term2, Util.not((Script)script, (Term)term)})) == Script.LBool.UNKNOWN) {
            iLogger.warn((Object)"Unable to prove correctness of quantifier elimination.");
        }
        return true;
    }

    private static boolean checkPropertiesOfLoopAccelerationFormula(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, UnmodifiableTransFormula unmodifiableTransFormula, Map<IProgramVar, TermVariable> map, Term term, UnmodifiableTransFormula unmodifiableTransFormula2, Term term2, Term term3, Term term4, TermVariable termVariable, boolean bl) {
        IProgramVar iProgramVar2;
        Script script = managedScript.getScript();
        Term term5 = new NnfTransformer(managedScript, iUltimateServiceProvider, NnfTransformer.QuantifierHandling.KEEP).transform(term);
        Term term6 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)term5);
        Term term7 = SmtUtils.simplify((ManagedScript)managedScript, (Term)term6, (Term)managedScript.term(null, "true", new Term[0]), (IUltimateServiceProvider)iUltimateServiceProvider, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA2);
        assert (JordanLoopAcceleration.checkCorrectnessOfQuantifierElimination(iLogger, script, term, term7));
        script.echo(new QuotedObject("Check if formula equivalent to false"));
        if (Util.checkSat((Script)script, (Term)term) == Script.LBool.UNSAT) {
            iLogger.warn((Object)"Reflexive-transitive closure is equivalent to false");
        }
        Term term8 = Util.not((Script)script, (Term)term7);
        Term term9 = Util.not((Script)script, (Term)unmodifiableTransFormula2.getFormula());
        HashMap<TermVariable, ConstantTerm> hashMap = new HashMap<TermVariable, ConstantTerm>();
        if (bl) {
            hashMap.put(termVariable, (ConstantTerm)script.numeral(BigInteger.ONE));
        } else {
            hashMap.put(termVariable, (ConstantTerm)script.numeral(BigInteger.ZERO));
        }
        Term term10 = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)term4);
        Term term11 = Util.not((Script)script, (Term)term10);
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{unmodifiableTransFormula.getFormula(), term11, term8})) == Script.LBool.UNKNOWN) {
            iLogger.warn((Object)"Unable to prove that computed reflexive-transitive closure contains relation itself.");
        }
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{unmodifiableTransFormula.getFormula(), term11, term8})) == Script.LBool.SAT) {
            throw new AssertionError((Object)"Computed reflexive-transitive closure does not contain relation itself.Something went wrong in computation of loop acceleration formula.");
        }
        ArrayList<UnmodifiableTransFormula> arrayList = new ArrayList<UnmodifiableTransFormula>();
        arrayList.add(unmodifiableTransFormula);
        arrayList.add(unmodifiableTransFormula);
        UnmodifiableTransFormula unmodifiableTransFormula3 = TransFormulaUtils.sequentialComposition((ILogger)iLogger, (IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (boolean)true, (boolean)true, (boolean)false, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, arrayList);
        HashMap<TermVariable, TermVariable> hashMap2 = new HashMap<TermVariable, TermVariable>();
        for (IProgramVar iProgramVar2 : unmodifiableTransFormula3.getInVars().keySet()) {
            hashMap2.put((TermVariable)unmodifiableTransFormula3.getInVars().get(iProgramVar2), map.get(iProgramVar2));
        }
        for (IProgramVar iProgramVar2 : unmodifiableTransFormula3.getOutVars().keySet()) {
            hashMap2.put((TermVariable)unmodifiableTransFormula3.getOutVars().get(iProgramVar2), (TermVariable)unmodifiableTransFormula.getOutVars().get(iProgramVar2));
        }
        iProgramVar2 = Substitution.apply((ManagedScript)managedScript, hashMap2, (Term)unmodifiableTransFormula3.getFormula());
        HashMap hashMap3 = new HashMap();
        if (bl) {
            hashMap3.put(termVariable, (ConstantTerm)script.numeral(BigInteger.TWO));
        } else {
            hashMap3.put(termVariable, (ConstantTerm)script.numeral(BigInteger.ONE));
        }
        Term term12 = Util.not((Script)script, (Term)PureSubstitution.apply((Script)script, (Map)hashMap3, (Term)term3));
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{iProgramVar2, term12, term8})) == Script.LBool.UNKNOWN) {
            iLogger.warn((Object)"Unable to prove that computed reflexive-transitive closure contains sequentialcomposition of relation with itself.");
        }
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{iProgramVar2, term12, term8})) == Script.LBool.SAT) {
            throw new AssertionError((Object)"Computed reflexive-transitive closure does not contain sequential composition of relation with itself. Something went wrong in computation of loop acceleration formula.");
        }
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{term7, Util.not((Script)script, (Term)term2), term9})) == Script.LBool.UNKNOWN) {
            iLogger.warn((Object)"Unable to prove that havoc of all variables is a superset of the reflexivetransitive closure.");
        }
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{term7, Util.not((Script)script, (Term)term2), term9})) == Script.LBool.SAT) {
            throw new AssertionError((Object)"Havoc of all variables is not a superset of the reflexive transitive closure.Something went wrong in computation of loop acceleration formula.");
        }
        return true;
    }

    public static class ClosedFormOfUpdate {
        private final Map<IProgramVar, Term> mScalarUpdates;
        private final Map<IProgramVar, MultiDimensionalNestedStore> mArrayUpdates;
        private final Map<IProgramVar, SimultaneousUpdate.NondetArrayWriteConstraints> mNondetArrayWriteConstraints;

        public ClosedFormOfUpdate(Map<IProgramVar, Term> map, Map<IProgramVar, MultiDimensionalNestedStore> map2, Map<IProgramVar, SimultaneousUpdate.NondetArrayWriteConstraints> map3) {
            this.mScalarUpdates = map;
            this.mArrayUpdates = map2;
            this.mNondetArrayWriteConstraints = map3;
        }

        public Map<IProgramVar, Term> getScalarUpdates() {
            return this.mScalarUpdates;
        }

        public Map<IProgramVar, MultiDimensionalNestedStore> getArrayUpdates() {
            return this.mArrayUpdates;
        }

        public Map<IProgramVar, SimultaneousUpdate.NondetArrayWriteConstraints> getNondetArrayWriteConstraints() {
            return this.mNondetArrayWriteConstraints;
        }
    }

    static enum Iterations {
        ALL,
        EVEN,
        ODD;

    }

    public static class JordanLoopAccelerationResult {
        private final AccelerationStatus mAccelerationStatus;
        private final String mErrorMessage;
        private final UnmodifiableTransFormula mTransFormula;
        private final JordanLoopAccelerationStatisticsGenerator mJordanLoopAccelerationStatistics;

        public JordanLoopAccelerationResult(AccelerationStatus accelerationStatus, String string, UnmodifiableTransFormula unmodifiableTransFormula, JordanLoopAccelerationStatisticsGenerator jordanLoopAccelerationStatisticsGenerator) {
            this.mAccelerationStatus = accelerationStatus;
            this.mErrorMessage = string;
            this.mTransFormula = unmodifiableTransFormula;
            this.mJordanLoopAccelerationStatistics = jordanLoopAccelerationStatisticsGenerator;
        }

        public AccelerationStatus getAccelerationStatus() {
            return this.mAccelerationStatus;
        }

        public String getErrorMessage() {
            return this.mErrorMessage;
        }

        public UnmodifiableTransFormula getTransFormula() {
            return this.mTransFormula;
        }

        public JordanLoopAccelerationStatisticsGenerator getJordanLoopAccelerationStatistics() {
            return this.mJordanLoopAccelerationStatistics;
        }

        public static enum AccelerationStatus {
            SUCCESS,
            SIMULTANEOUS_UPDATE_FAILED,
            NONINTEGER_UPDATE,
            NONLINEAR_UPDATE,
            UNSUPPORTED_EIGENVALUES,
            OTHER;

        }
    }
}

