/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DoubleDeckerVisitor;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import java.util.Map;
import java.util.Set;

public class DoubleDeckerAutomaton<LETTER, STATE>
extends NestedWordAutomaton<LETTER, STATE>
implements IDoubleDeckerAutomaton<LETTER, STATE> {
    private static final String UP2DOWN_NOT_SET = "up2down not set";
    private Map<STATE, Map<STATE, DoubleDeckerVisitor.ReachFinal>> mUp2Down = null;

    public DoubleDeckerAutomaton(AutomataLibraryServices automataLibraryServices, VpAlphabet<LETTER> vpAlphabet, IEmptyStackStateFactory<STATE> iEmptyStackStateFactory) {
        super(automataLibraryServices, vpAlphabet, iEmptyStackStateFactory);
    }

    public boolean up2DownIsSet() {
        return this.mUp2Down != null;
    }

    @Override
    public Set<STATE> getDownStates(STATE STATE) {
        if (this.up2DownIsSet()) {
            return this.mUp2Down.get(STATE).keySet();
        }
        throw new AssertionError((Object)UP2DOWN_NOT_SET);
    }

    public void setUp2Down(Map<STATE, Map<STATE, DoubleDeckerVisitor.ReachFinal>> map) {
        if (this.up2DownIsSet()) {
            throw new AssertionError((Object)"up2down already set");
        }
        this.mUp2Down = map;
    }

    @Override
    public boolean isDoubleDecker(STATE STATE, STATE STATE2) {
        if (!this.up2DownIsSet()) {
            throw new AssertionError((Object)UP2DOWN_NOT_SET);
        }
        if (this.getStates().contains(STATE)) {
            Map<STATE, DoubleDeckerVisitor.ReachFinal> map = this.mUp2Down.get(STATE);
            if (this.getStates().contains(STATE2)) {
                return map.get(STATE2) != null;
            }
            return false;
        }
        return false;
    }
}

