/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import de.uni_freiburg.informatik.ultimate.util.CombinatoricsUtils;
import java.util.List;

public class isDetereministic<LETTER extends IRankedLetter, STATE>
extends GeneralOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final ITreeAutomatonBU<LETTER, STATE> mTreeAutomaton;
    private final boolean mResultTreeRun;

    public isDetereministic(AutomataLibraryServices automataLibraryServices, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU) {
        super(automataLibraryServices);
        this.mTreeAutomaton = iTreeAutomatonBU;
        this.mResultTreeRun = this.computeResult();
    }

    private boolean computeResult() {
        for (List<STATE> list : this.mTreeAutomaton.getSourceCombinations()) {
            for (TreeAutomatonRule<List<STATE>, STATE> treeAutomatonRule : this.mTreeAutomaton.getSuccessors(list)) {
                if (CombinatoricsUtils.iterateAll(this.mTreeAutomaton.getSuccessors(treeAutomatonRule.getSource(), treeAutomatonRule.getLetter())).size() == 1) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String startMessage() {
        return "Starting determinism check";
    }

    @Override
    public String exitMessage() {
        return "Exit determinism check";
    }

    @Override
    public Boolean getResult() {
        return this.mResultTreeRun;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }
}

