/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HistogramOfIterable<E> {
    private final Map<E, Integer> mHistogramMap;
    private final Integer[] mVisualizationArray;

    public HistogramOfIterable(Iterable<E> iterable) {
        this.mHistogramMap = HistogramOfIterable.generateHistogramMap(iterable);
        this.mVisualizationArray = HistogramOfIterable.generateVisualizationArray(this.mHistogramMap);
    }

    public static <E> Integer[] generateVisualizationArray(Map<E, Integer> map) {
        Integer[] integerArray = map.values().toArray(new Integer[map.size()]);
        Arrays.sort(integerArray, Collections.reverseOrder());
        return integerArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.mVisualizationArray);
    }

    public Integer[] getVisualizationArray() {
        return this.mVisualizationArray;
    }

    public int getMax() {
        return HistogramOfIterable.getMaxOfVisualizationArray(Arrays.asList(this.getVisualizationArray()));
    }

    public static int getMaxOfVisualizationArray(List<Integer> list) {
        if (list.isEmpty()) {
            return 0;
        }
        return list.get(0);
    }

    public static <E> Map<E, Integer> generateHistogramMap(Iterable<E> iterable) {
        HashMap<E, Integer> hashMap = new HashMap<E, Integer>();
        for (E e : iterable) {
            if (hashMap.containsKey(e)) {
                hashMap.put(e, (Integer)hashMap.get(e) + 1);
                continue;
            }
            hashMap.put(e, 1);
        }
        return hashMap;
    }

    public int hashCode() {
        return Objects.hash(this.mHistogramMap);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HistogramOfIterable histogramOfIterable = (HistogramOfIterable)object;
        return Objects.equals(this.mHistogramMap, histogramOfIterable.mHistogramMap);
    }
}

