/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import java.util.LinkedHashSet;

public class InterpolatorClauseInfo {
    private Term[] mLiterals;
    private final ClauseKind mNodeKind;
    private Term[] mResolutionArgs;
    private Annotation mLemmaAnnotation;

    public InterpolatorClauseInfo(Term term) {
        if (ProofRules.isProofRule("res", term)) {
            this.mNodeKind = ClauseKind.RESOLUTION;
        } else {
            AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
            this.mLemmaAnnotation = annotatedTerm.getAnnotations()[1];
            this.mNodeKind = this.mLemmaAnnotation.getKey() == ":rup" ? ClauseKind.RESOLUTION : (this.mLemmaAnnotation.getKey() == ":input" ? ClauseKind.INPUT : ClauseKind.LEMMA);
            this.mLiterals = InterpolatorClauseInfo.computeLiterals((Object[])annotatedTerm.getAnnotations()[0].getValue());
        }
    }

    public void computeResolutionLiterals(Interpolator interpolator) {
        Object object;
        assert (this.isResolution());
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        InterpolatorClauseInfo interpolatorClauseInfo = interpolator.mClauseTermInfos.get(this.mResolutionArgs[1]);
        Term term = this.mResolutionArgs[0];
        Term[] termArray = interpolatorClauseInfo.getLiterals();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = termArray[n2];
            if (object != term) {
                linkedHashSet.add(object);
            }
            ++n2;
        }
        object = interpolator.mClauseTermInfos.get(this.mResolutionArgs[2]);
        Term term2 = term.getTheory().term("not", new Term[]{term});
        Term[] termArray2 = ((InterpolatorClauseInfo)object).getLiterals();
        int n3 = termArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            Term term3 = termArray2[n4];
            if (term3 != term2) {
                linkedHashSet.add(term3);
            }
            ++n4;
        }
        this.mLiterals = linkedHashSet.toArray(new Term[linkedHashSet.size()]);
    }

    private static Term[] computeLiterals(Object[] objectArray) {
        assert (objectArray.length % 2 == 0);
        Term[] termArray = new Term[objectArray.length / 2];
        int n = 0;
        while (n < termArray.length) {
            Term term = (Term)objectArray[2 * n + 1];
            termArray[n] = objectArray[2 * n] == "+" ? term : term.getTheory().term("not", new Term[]{term});
            ++n;
        }
        return termArray;
    }

    public boolean isResolution() {
        return this.mNodeKind == ClauseKind.RESOLUTION;
    }

    public boolean isLeaf() {
        return this.mNodeKind != ClauseKind.RESOLUTION;
    }

    public ClauseKind getLeafKind() {
        return this.mNodeKind;
    }

    public String getLemmaType() {
        return this.mLemmaAnnotation.getKey();
    }

    public Object getLemmaAnnotation() {
        return this.mLemmaAnnotation.getValue();
    }

    public Term[] getLiterals() {
        return this.mLiterals;
    }

    public Term getPivotLiteral() {
        return this.mResolutionArgs[0];
    }

    public Term[] getResolutionArgs() {
        return this.mResolutionArgs;
    }

    public String getSource() {
        assert (this.mNodeKind == ClauseKind.INPUT);
        return (String)this.mLemmaAnnotation.getValue();
    }

    static enum ClauseKind {
        RESOLUTION,
        LEMMA,
        INPUT;

    }
}

