/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;
import java.io.IOException;

public class LoggerOption
extends Option {
    private String mDefaultDest;
    private final LogProxy mLogger;

    public LoggerOption(String string, LogProxy logProxy) {
        super(true, string);
        this.mDefaultDest = logProxy.getDestination();
        this.mLogger = logProxy;
    }

    private final void changeLoggerDest(String string) {
        try {
            this.mLogger.changeDestination(String.valueOf(string));
        }
        catch (IOException iOException) {
            throw new SMTLIBException("Could not change logging destination", (Throwable)iOException);
        }
    }

    @Override
    public void set(Object object) {
        if (object instanceof QuotedObject) {
            object = ((QuotedObject)object).getValue();
        }
        if (this.mLogger.canChangeDestination()) {
            this.changeLoggerDest(String.valueOf(object));
        } else {
            this.mLogger.warn("Attempt to change the destionation of the logger which cannot change its destination!");
        }
    }

    @Override
    public Object get() {
        return new QuotedObject(this.mLogger.getDestination());
    }

    @Override
    public void reset() {
        if (this.mLogger.canChangeDestination()) {
            this.changeLoggerDest(this.mDefaultDest);
        }
    }

    @Override
    public Object defaultValue() {
        return this.mDefaultDest;
    }

    @Override
    public Option copy() {
        return this;
    }

    @Override
    public void started() {
        this.mDefaultDest = this.mLogger.getDestination();
    }
}

