/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie.req2pea;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieExpressionTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.BoogieLocation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.BoogieDeclarations;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseBits;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.lib.srparse.Durations;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.pea2boogie.Activator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.IReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.PeaResultUtil;
import de.uni_freiburg.informatik.ultimate.pea2boogie.generator.RtInconcistencyConditionGenerator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.preferences.Pea2BoogiePreferences;
import de.uni_freiburg.informatik.ultimate.pea2boogie.req2pea.IReq2PeaAnnotator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.results.ReqCheck;
import de.uni_freiburg.informatik.ultimate.pea2boogie.translator.CheckedReqLocation;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.CrossProducts;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.simplifier.INormalFormable;
import de.uni_freiburg.informatik.ultimate.util.simplifier.NormalFormTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class ReqCheckAnnotator
implements IReq2PeaAnnotator {
    private static final boolean DEBUG_ONLY_FIRST_NON_TRIVIAL_RT_INCONSISTENCY = false;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final PeaResultUtil mPeaResultUtil;
    private final BoogieLocation mUnitLocation;
    private boolean mCheckVacuity;
    private int mCombinationNum;
    private boolean mCheckConsistency;
    private boolean mCheckComplement;
    private boolean mCheckRedundancy;
    private boolean mReportTrivialConsistency;
    private boolean mGenerateFailurePath;
    private boolean mSeparateInvariantHandling;
    private RtInconcistencyConditionGenerator mRtInconcistencyConditionGenerator;
    private final NormalFormTransformer<Expression> mNormalFormTransformer;
    private final IReqSymbolTable mSymbolTable;
    private final List<PatternType.ReqPeas> mReqPeas;
    private final Durations mDurations;

    public ReqCheckAnnotator(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, List<PatternType.ReqPeas> list, IReqSymbolTable iReqSymbolTable, Durations durations) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mSymbolTable = iReqSymbolTable;
        this.mReqPeas = list;
        this.mPeaResultUtil = new PeaResultUtil(this.mLogger, this.mServices);
        this.mUnitLocation = new BoogieLocation("", -1, -1, -1, -1);
        this.mNormalFormTransformer = new NormalFormTransformer((INormalFormable)new BoogieExpressionTransformer());
        this.mDurations = durations;
    }

    @Override
    public List<Statement> getStateChecks() {
        RtInconcistencyConditionGenerator rtInconcistencyConditionGenerator;
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mCheckVacuity = iPreferenceProvider.getBoolean("Check vacuity");
        if (iPreferenceProvider.getBoolean("Check rt-inconsistency")) {
            int n = this.mReqPeas.size();
            this.mCombinationNum = Math.min(n, iPreferenceProvider.getInt("Rt-inconsistency range"));
        } else {
            this.mCombinationNum = -1;
        }
        this.mCheckConsistency = iPreferenceProvider.getBoolean("Check consistency");
        this.mReportTrivialConsistency = iPreferenceProvider.getBoolean("Report trivial rt-consistency");
        this.mSeparateInvariantHandling = iPreferenceProvider.getBoolean("Always use all invariants during rt-inconsistency checks");
        this.mCheckConsistency = iPreferenceProvider.getBoolean("Check consistency");
        this.mCheckRedundancy = iPreferenceProvider.getEnum("PEA Transformation Mode", Pea2BoogiePreferences.PEATransformerMode.class) == Pea2BoogiePreferences.PEATransformerMode.REQ_RED;
        this.mLogger.info((Object)String.format("%s=%s, %s=%s, %s=%s, %s=%s, %s=%s, %s=%s", "Check vacuity", this.mCheckVacuity, "Rt-inconsistency range", this.mCombinationNum, "Check consistency", this.mCheckConsistency, "Report trivial rt-consistency", this.mReportTrivialConsistency, "Always use all invariants during rt-inconsistency checks", this.mSeparateInvariantHandling, "Generate failure path for rt-inconsistency", this.mGenerateFailurePath));
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>(this.mSymbolTable.getDeclarations());
        try {
            if (this.mCombinationNum >= 1) {
                BoogieDeclarations boogieDeclarations = new BoogieDeclarations(arrayList, this.mLogger);
                rtInconcistencyConditionGenerator = new RtInconcistencyConditionGenerator(this.mLogger, this.mServices, this.mPeaResultUtil, this.mSymbolTable, this.mReqPeas, boogieDeclarations, this.mDurations, this.mSeparateInvariantHandling);
            } else {
                rtInconcistencyConditionGenerator = null;
            }
        }
        catch (RtInconcistencyConditionGenerator.InvariantInfeasibleException invariantInfeasibleException) {
            this.mPeaResultUtil.infeasibleInvariant(invariantInfeasibleException);
            this.mRtInconcistencyConditionGenerator = null;
            return Collections.emptyList();
        }
        this.mRtInconcistencyConditionGenerator = rtInconcistencyConditionGenerator;
        return this.generateAnnotations();
    }

    private List<Statement> generateAnnotations() {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        if (this.mCheckConsistency) {
            arrayList.addAll(ReqCheckAnnotator.genCheckConsistency(this.mUnitLocation));
        }
        if (this.mCheckVacuity) {
            arrayList.addAll(this.genChecksNonVacuity(this.mUnitLocation));
        }
        if (this.mCheckComplement) {
            arrayList.addAll(this.genCheckComplement(this.mUnitLocation));
        }
        if (this.mCheckRedundancy) {
            arrayList.addAll(this.genChecksRedundancy(this.mUnitLocation));
        }
        arrayList.addAll(this.genChecksRTInconsistency(this.mUnitLocation));
        return arrayList;
    }

    private static List<Statement> genCheckConsistency(BoogieLocation boogieLocation) {
        ReqCheck reqCheck = new ReqCheck(Spec.CONSISTENCY);
        BooleanLiteral booleanLiteral = ExpressionFactory.createBooleanLiteral((ILocation)boogieLocation, (boolean)false);
        return Collections.singletonList(ReqCheckAnnotator.createAssert((Expression)booleanLiteral, reqCheck, "CONSISTENCY"));
    }

    private List<Statement> genCheckComplement(BoogieLocation boogieLocation) {
        PatternType.ReqPeas reqPeas;
        PatternType.ReqPeas reqPeas2;
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        PatternType.ReqPeas reqPeas3 = this.mReqPeas.get(0);
        Statement statement = this.genAssertComplement(reqPeas3, reqPeas2 = this.mReqPeas.get(1), reqPeas = this.mReqPeas.get(2), boogieLocation);
        if (statement != null) {
            arrayList.add(statement);
        }
        return arrayList;
    }

    private Statement genAssertComplement(PatternType.ReqPeas reqPeas, PatternType.ReqPeas reqPeas2, PatternType.ReqPeas reqPeas3, BoogieLocation boogieLocation) {
        Expression expression;
        Expression expression2;
        Expression expression3;
        Expression expression4;
        Expression expression5;
        Expression expression6;
        Expression expression7;
        Expression expression8;
        if (reqPeas.isStrict()) {
            expression8 = new ArrayList();
            expression7 = new ArrayList();
            this.genStrictPeaExpressions(reqPeas2, (List<Expression>)expression8, (List<Expression>)expression7, boogieLocation);
            expression6 = ExpressionFactory.or((ILocation)boogieLocation, expression7);
            expression5 = ExpressionFactory.or((ILocation)boogieLocation, expression8);
            expression4 = new ArrayList();
            expression3 = new ArrayList();
            this.genStrictPeaExpressions(reqPeas3, (List<Expression>)expression4, (List<Expression>)expression3, boogieLocation);
            expression2 = ExpressionFactory.or((ILocation)boogieLocation, (List)expression4);
            expression = ExpressionFactory.or((ILocation)boogieLocation, expression3);
        } else {
            expression5 = this.genPcInSinkExpression(reqPeas2, boogieLocation);
            expression6 = ExpressionFactory.constructUnaryExpression((ILocation)boogieLocation, (UnaryExpression.Operator)UnaryExpression.Operator.LOGICNEG, (Expression)expression5);
            expression2 = this.genPcInSinkExpression(reqPeas3, boogieLocation);
            expression = ExpressionFactory.constructUnaryExpression((ILocation)boogieLocation, (UnaryExpression.Operator)UnaryExpression.Operator.LOGICNEG, (Expression)expression2);
        }
        expression8 = ExpressionFactory.newBinaryExpression((ILocation)boogieLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression6, (Expression)expression2);
        expression7 = ExpressionFactory.newBinaryExpression((ILocation)boogieLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression5, (Expression)expression);
        expression4 = ExpressionFactory.newBinaryExpression((ILocation)boogieLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression8, (Expression)expression7);
        expression3 = ExpressionFactory.constructUnaryExpression((ILocation)boogieLocation, (UnaryExpression.Operator)UnaryExpression.Operator.LOGICNEG, (Expression)expression4);
        ReqCheck reqCheck = new ReqCheck(Spec.COMPLEMENT);
        String string = "Complement_" + reqPeas2.toString() + "_" + reqPeas3.toString();
        return ReqCheckAnnotator.createAssert(expression3, reqCheck, string);
    }

    private Expression genPcInSinkExpression(PatternType.ReqPeas reqPeas, BoogieLocation boogieLocation) {
        List list = reqPeas.getCounterTrace2Pea();
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (Map.Entry entry : list) {
            PhaseEventAutomata phaseEventAutomata = (PhaseEventAutomata)entry.getValue();
            List list2 = phaseEventAutomata.getPhases();
            int n = 0;
            while (n < list2.size()) {
                Phase phase = (Phase)list2.get(n);
                if (phase.getName().equals("sink")) {
                    Expression expression = this.genComparePhaseCounter(n, this.mSymbolTable.getPcName(phaseEventAutomata), boogieLocation);
                    arrayList.add(expression);
                }
                ++n;
            }
        }
        return ExpressionFactory.or((ILocation)boogieLocation, arrayList);
    }

    private void genStrictPeaExpressions(PatternType.ReqPeas reqPeas, List<Expression> list, List<Expression> list2, BoogieLocation boogieLocation) {
        List list3 = reqPeas.getCounterTrace2Pea();
        for (Map.Entry entry : list3) {
            PhaseEventAutomata phaseEventAutomata = (PhaseEventAutomata)entry.getValue();
            List list4 = phaseEventAutomata.getPhases();
            int n = 0;
            while (n < list4.size()) {
                Phase phase = (Phase)list4.get(n);
                Expression expression = this.genComparePhaseCounter(n, this.mSymbolTable.getPcName(phaseEventAutomata), boogieLocation);
                if (!phase.getModifiedConstraints().isEmpty()) {
                    Expression expression22;
                    List list5 = phase.getModifiedConstraints();
                    ArrayList<Expression> arrayList = new ArrayList<Expression>();
                    arrayList.add(expression);
                    ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
                    arrayList2.add(expression);
                    for (Expression expression22 : list5) {
                        Integer n2 = expression22.getVal(0);
                        String string = expression22.getVar();
                        Expression expression3 = this.genCompareClock(n2.floatValue(), string, BinaryExpression.Operator.COMPEQ, boogieLocation);
                        arrayList.add(expression3);
                        Expression expression4 = this.genCompareClock(n2.floatValue(), string, BinaryExpression.Operator.COMPLT, boogieLocation);
                        arrayList2.add(expression4);
                    }
                    expression22 = ExpressionFactory.and((ILocation)boogieLocation, arrayList);
                    list.add(expression22);
                    Expression expression5 = ExpressionFactory.and((ILocation)boogieLocation, arrayList2);
                    list2.add(expression5);
                } else if (phase.getTerminal()) {
                    list2.add(expression);
                }
                ++n;
            }
        }
    }

    private List<Statement> genChecksRTInconsistency(BoogieLocation boogieLocation) {
        int n;
        if (this.mRtInconcistencyConditionGenerator == null) {
            return Collections.emptyList();
        }
        List<Map.Entry<PatternType<?>, PhaseEventAutomata>> list = this.mRtInconcistencyConditionGenerator.getRelevantRequirements(this.mReqPeas);
        int n2 = list.size();
        if (this.mSeparateInvariantHandling) {
            long l = this.mReqPeas.stream().flatMap(reqPeas -> reqPeas.getCounterTrace2Pea().stream()).count();
            long l2 = l - (long)n2;
            this.mLogger.info((Object)String.format("%s of %s PEAs are invariant", l2, l));
        }
        int n3 = n = this.mCombinationNum <= n2 ? this.mCombinationNum : n2;
        if (n <= 0) {
            this.mLogger.info((Object)"No rt-inconsistencies possible");
            return Collections.emptyList();
        }
        if (this.mPeaResultUtil.isAlreadyAborted()) {
            throw new ToolchainCanceledException(new RunningTaskInfo(this.getClass(), "Already encountered errors"));
        }
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        List list2 = CrossProducts.subArrays((Object[])list.toArray(new Map.Entry[n2]), (int)n, (Object[])new Map.Entry[n]);
        int n4 = list2.size();
        if (n4 > 10000) {
            this.mLogger.warn((Object)("Computing rt-inconsistency assertions for " + n4 + " subsets, this might take a while..."));
        } else {
            this.mLogger.info((Object)("Computing rt-inconsistency assertions for " + n4 + " subsets"));
        }
        long l = System.currentTimeMillis();
        for (Map.Entry[] entryArray : list2) {
            Statement statement;
            if (n4 % 100 == 0 && !this.mServices.getProgressMonitorService().continueProcessing()) {
                throw new ToolchainCanceledException(this.getClass(), "Computing rt-inconsistency assertions, still " + n4 + " left");
            }
            if (n4 % 10 == 0) {
                long l3 = System.currentTimeMillis();
                this.mLogger.info("%s subsets remaining (took %s since last message)", new Object[]{n4, CoreUtil.humanReadableTime((long)(l3 - l), (TimeUnit)TimeUnit.MILLISECONDS, (int)2)});
                l = l3;
                this.mRtInconcistencyConditionGenerator.logStats();
            }
            if ((statement = this.genAssertRTInconsistency(entryArray)) != null) {
                arrayList.add(statement);
            }
            --n4;
        }
        this.mRtInconcistencyConditionGenerator.logStats();
        return arrayList;
    }

    private Statement genAssertRTInconsistency(Map.Entry<PatternType<?>, PhaseEventAutomata>[] entryArray) {
        Set<PhaseEventAutomata> set = Arrays.stream(entryArray).map(Map.Entry::getValue).collect(Collectors.toSet());
        assert (set.size() == entryArray.length);
        PhaseEventAutomata[] phaseEventAutomataArray = set.toArray(new PhaseEventAutomata[entryArray.length]);
        Expression expression = this.mRtInconcistencyConditionGenerator.generateNonDeadlockCondition(phaseEventAutomataArray);
        ReqCheck reqCheck = ReqCheckAnnotator.createReqCheck(Spec.RTINCONSISTENT, entryArray);
        if (expression == null) {
            if (this.mReportTrivialConsistency) {
                ILocation iLocation = this.mSymbolTable.getIdentifierExpression(this.mSymbolTable.getPcName(entryArray[0].getValue())).getLoc();
                AssertStatement assertStatement = ReqCheckAnnotator.createAssert((Expression)ExpressionFactory.createBooleanLiteral((ILocation)iLocation, (boolean)true), reqCheck, "RTINCONSISTENT_" + ReqCheckAnnotator.getAssertLabel(entryArray));
                this.mPeaResultUtil.intrinsicRtConsistencySuccess((IElement)assertStatement);
            }
            return null;
        }
        return ReqCheckAnnotator.createAssert(expression, reqCheck, "RTINCONSISTENT_" + ReqCheckAnnotator.getAssertLabel(entryArray));
    }

    private static String getAssertLabel(Map.Entry<PatternType<?>, PhaseEventAutomata>[] entryArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Map.Entry<PatternType<?>, PhaseEventAutomata>[] entryArray2 = entryArray;
        int n = entryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry<PatternType<?>, PhaseEventAutomata> entry = entryArray2[n2];
            stringBuilder.append(entry.getValue().getName() + "_");
            ++n2;
        }
        return stringBuilder.toString();
    }

    private static AssertStatement createAssert(Expression expression, ReqCheck reqCheck, String string) {
        CheckedReqLocation checkedReqLocation = new CheckedReqLocation(reqCheck);
        NamedAttribute[] namedAttributeArray = new NamedAttribute[]{new NamedAttribute((ILocation)checkedReqLocation, "check_" + string, new Expression[0])};
        AssertStatement assertStatement = new AssertStatement((ILocation)checkedReqLocation, namedAttributeArray, expression);
        reqCheck.annotate((IElement)assertStatement);
        return assertStatement;
    }

    @Override
    public PeaResultUtil getPeaResultUtil() {
        return this.mPeaResultUtil;
    }

    private List<Statement> genChecksNonVacuity(BoogieLocation boogieLocation) {
        if (!this.mCheckVacuity) {
            return Collections.emptyList();
        }
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        for (PatternType.ReqPeas reqPeas : this.mReqPeas) {
            PatternType patternType = reqPeas.getPattern();
            for (Map.Entry entry : reqPeas.getCounterTrace2Pea()) {
                Statement statement = this.genAssertNonVacuous(patternType, (PhaseEventAutomata)entry.getValue(), boogieLocation);
                if (statement == null) continue;
                arrayList.add(statement);
            }
        }
        return arrayList;
    }

    private Statement genAssertNonVacuous(PatternType<?> patternType, PhaseEventAutomata phaseEventAutomata, BoogieLocation boogieLocation) {
        PhaseBits phaseBits;
        List list = phaseEventAutomata.getPhases();
        int n = 0;
        for (Phase phase : list) {
            int n2;
            phaseBits = phase.getPhaseBits();
            if (phaseBits == null || (n2 = phaseBits.getActive()) <= n) continue;
            n = n2;
        }
        int n3 = 0;
        while (1 << n3 <= n) {
            ++n3;
        }
        ArrayList arrayList = new ArrayList();
        if (n3 > 0) {
            int n4 = 0;
            while (n4 < list.size()) {
                PhaseBits phaseBits2 = ((Phase)list.get(n4)).getPhaseBits();
                if (phaseBits2 == null || (phaseBits2.getActive() & 1 << n3 - 1) == 0) {
                    arrayList.add(this.genComparePhaseCounter(n4, this.mSymbolTable.getPcName(phaseEventAutomata), boogieLocation));
                }
                ++n4;
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        phaseBits = this.genDisjunction(arrayList, boogieLocation);
        ReqCheck reqCheck = ReqCheckAnnotator.createReqCheck(Spec.VACUOUS, patternType, phaseEventAutomata);
        String string = "VACUOUS_" + phaseEventAutomata.getName();
        return ReqCheckAnnotator.createAssert((Expression)phaseBits, reqCheck, string);
    }

    private List<Statement> genChecksRedundancy(BoogieLocation boogieLocation) {
        Object object;
        Expression expression;
        Expression expression2;
        if (!this.mCheckRedundancy) {
            return Collections.emptyList();
        }
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        ArrayList<Expression> arrayList3 = new ArrayList<Expression>();
        for (PatternType.ReqPeas reqPeas : this.mReqPeas) {
            expression2 = new ArrayList();
            expression = new ArrayList();
            if (reqPeas.isStrict()) {
                this.genStrictPeaExpressions(reqPeas, (List<Expression>)expression, (List<Expression>)expression2, boogieLocation);
            } else {
                object = this.genPcInSinkExpression(reqPeas, boogieLocation);
                expression2.add((Expression)ExpressionFactory.constructUnaryExpression((ILocation)boogieLocation, (UnaryExpression.Operator)UnaryExpression.Operator.LOGICNEG, (Expression)object));
                expression.add((Expression)object);
            }
            arrayList2.add(ExpressionFactory.or((ILocation)boogieLocation, expression2));
            arrayList3.add(ExpressionFactory.or((ILocation)boogieLocation, expression));
        }
        int n = 0;
        while (n < this.mReqPeas.size()) {
            Object object2;
            ArrayList arrayList4 = new ArrayList(arrayList2);
            arrayList4.remove(n);
            arrayList4.add((Expression)arrayList3.get(n));
            expression2 = ExpressionFactory.and((ILocation)boogieLocation, (List)arrayList4);
            expression = ExpressionFactory.constructUnaryExpression((ILocation)boogieLocation, (UnaryExpression.Operator)UnaryExpression.Operator.LOGICNEG, (Expression)expression2);
            object = new ArrayList();
            ArrayList<String> arrayList5 = new ArrayList<String>();
            Object object3 = this.mReqPeas.get(n).getCounterTrace2Pea().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                arrayList5.add(((PhaseEventAutomata)object2.getValue()).getName());
                object.add(this.mReqPeas.get(n).getPattern().getId());
            }
            object2 = new ReqCheck(Spec.REDUNDANCY, object.toArray(new String[object.size()]), arrayList5.toArray(new String[object.size()]));
            AssertStatement assertStatement = ReqCheckAnnotator.createAssert(expression, (ReqCheck)((Object)object2), (String)(object3 = "REDUNDANT_" + this.mReqPeas.get(n).getPattern().toString()));
            if (assertStatement != null) {
                arrayList.add((Statement)assertStatement);
            }
            ++n;
        }
        return arrayList;
    }

    @SafeVarargs
    private static ReqCheck createReqCheck(Spec spec, Map.Entry<PatternType<?>, PhaseEventAutomata> ... entryArray) {
        if (entryArray == null || entryArray.length == 0) {
            throw new IllegalArgumentException("subset cannot be null or empty");
        }
        String[] stringArray = new String[entryArray.length];
        String[] stringArray2 = new String[entryArray.length];
        int n = 0;
        while (n < entryArray.length) {
            stringArray[n] = entryArray[n].getKey().getId();
            stringArray2[n] = entryArray[n].getValue().getName();
            ++n;
        }
        return new ReqCheck(spec, stringArray, stringArray2);
    }

    private static ReqCheck createReqCheck(Spec spec, PatternType<?> patternType, PhaseEventAutomata phaseEventAutomata) {
        return ReqCheckAnnotator.createReqCheck(spec, new Map.Entry[]{new Pair(patternType, (Object)phaseEventAutomata)});
    }

    private Expression genDisjunction(List<Expression> list, BoogieLocation boogieLocation) {
        Iterator<Expression> iterator = list.iterator();
        if (!iterator.hasNext()) {
            return ExpressionFactory.createBooleanLiteral((ILocation)boogieLocation, (boolean)false);
        }
        Expression expression = iterator.next();
        while (iterator.hasNext()) {
            expression = ExpressionFactory.newBinaryExpression((ILocation)boogieLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression, (Expression)iterator.next());
        }
        return (Expression)this.mNormalFormTransformer.toNnf((Object)expression);
    }

    private Expression genComparePhaseCounter(int n, String string, BoogieLocation boogieLocation) {
        IdentifierExpression identifierExpression = this.mSymbolTable.getIdentifierExpression(string);
        IntegerLiteral integerLiteral = ExpressionFactory.createIntegerLiteral((ILocation)boogieLocation, (String)Integer.toString(n));
        return ExpressionFactory.newBinaryExpression((ILocation)boogieLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)identifierExpression, (Expression)integerLiteral);
    }

    private Expression genCompareClock(float f, String string, BinaryExpression.Operator operator, BoogieLocation boogieLocation) {
        IdentifierExpression identifierExpression = this.mSymbolTable.getIdentifierExpression(string);
        RealLiteral realLiteral = ExpressionFactory.createRealLiteral((ILocation)boogieLocation, (String)Float.toString(f));
        return ExpressionFactory.newBinaryExpression((ILocation)boogieLocation, (BinaryExpression.Operator)operator, (Expression)identifierExpression, (Expression)realLiteral);
    }

    @Override
    public List<Statement> getPreChecks() {
        return Collections.emptyList();
    }

    @Override
    public List<Statement> getPostTransitionChecks() {
        return Collections.emptyList();
    }
}

