/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.witnesschecking;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveDeadEnds;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveNonLiveStates;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.benchmark.LineCoverageCalculator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.witnesschecking.GraphMLWitnessProductAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.witnesschecking.YamlWitnessProductAutomaton;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessEdge;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessNode;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.ViolationSequence;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Waypoint;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Witness;
import java.util.List;
import java.util.stream.Collectors;

public class WitnessUtils {
    private static <LETTER extends IIcfgTransition<?>> IDoubleDeckerAutomaton<LETTER, IPredicate> reduce(INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> iNwaOutgoingLetterAndTransitionProvider, Property property, AutomataLibraryServices automataLibraryServices) throws AutomataOperationCanceledException {
        switch (property) {
            case NON_REACHABILITY: {
                return new RemoveDeadEnds(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider).getResult();
            }
            case TERMINATION: {
                return new RemoveNonLiveStates(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider).getResult();
            }
        }
        throw new AssertionError();
    }

    public static <LETTER extends IIcfgTransition<?>> IDoubleDeckerAutomaton<LETTER, IPredicate> constructGraphMLWitnessProduct(IUltimateServiceProvider iUltimateServiceProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<WitnessEdge, WitnessNode> iNwaOutgoingLetterAndTransitionProvider2, PredicateFactory predicateFactory, ILogger iLogger, Property property) throws AutomataOperationCanceledException {
        GraphMLWitnessProductAutomaton<LETTER> graphMLWitnessProductAutomaton = new GraphMLWitnessProductAutomaton<LETTER>(iUltimateServiceProvider, iNwaOutgoingLetterAndTransitionProvider, iNwaOutgoingLetterAndTransitionProvider2, predicateFactory);
        LineCoverageCalculator<LETTER> lineCoverageCalculator = new LineCoverageCalculator<LETTER>(iUltimateServiceProvider, iNwaOutgoingLetterAndTransitionProvider);
        IDoubleDeckerAutomaton<LETTER, IPredicate> iDoubleDeckerAutomaton = WitnessUtils.reduce(graphMLWitnessProductAutomaton, property, new AutomataLibraryServices(iUltimateServiceProvider));
        iLogger.info((Object)graphMLWitnessProductAutomaton.generateBadWitnessInformation());
        new LineCoverageCalculator<LETTER>(iUltimateServiceProvider, iNwaOutgoingLetterAndTransitionProvider, lineCoverageCalculator).reportCoverage("Witness product");
        return iDoubleDeckerAutomaton;
    }

    public static <LETTER extends IIcfgTransition<?>> IDoubleDeckerAutomaton<LETTER, IPredicate> constructYamlWitnessProduct(IUltimateServiceProvider iUltimateServiceProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> iNwaOutgoingLetterAndTransitionProvider, Witness witness, PredicateFactory predicateFactory, ILogger iLogger, Property property) throws AutomataOperationCanceledException {
        YamlWitnessProductAutomaton<LETTER> yamlWitnessProductAutomaton = new YamlWitnessProductAutomaton<LETTER>(iNwaOutgoingLetterAndTransitionProvider, witness, predicateFactory);
        iLogger.info("Constructing product of automaton with %d states and violation witness of the following lengths: %s", new Object[]{iNwaOutgoingLetterAndTransitionProvider.size(), witness.getEntries().stream().map(witnessEntry -> ((ViolationSequence)witnessEntry).getSegments().size()).collect(Collectors.toList())});
        IDoubleDeckerAutomaton<LETTER, IPredicate> iDoubleDeckerAutomaton = WitnessUtils.reduce(yamlWitnessProductAutomaton, property, new AutomataLibraryServices(iUltimateServiceProvider));
        List<Waypoint> list = yamlWitnessProductAutomaton.getUnmatchedFollowWaypoints();
        if (!list.isEmpty()) {
            iLogger.warn((Object)"Unmatched follow waypoints:");
            for (Waypoint waypoint : list) {
                iLogger.warn((Object)waypoint);
            }
        }
        return iDoubleDeckerAutomaton;
    }

    public static enum Property {
        NON_REACHABILITY,
        TERMINATION;

    }
}

