/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.sifa.preferences;

import de.uni_freiburg.informatik.ultimate.core.lib.preferences.UltimatePreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.BaseUltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.PreferenceType;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItemContainer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.CompoundDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.EqDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.ExplicitValueDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.IntervalDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.OctagonDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.fluid.AlwaysFluid;
import de.uni_freiburg.informatik.ultimate.lib.sifa.fluid.LogSizeWrapperFluid;
import de.uni_freiburg.informatik.ultimate.lib.sifa.fluid.NeverFluid;
import de.uni_freiburg.informatik.ultimate.lib.sifa.fluid.SizeLimitFluid;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.FixpointLoopSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.InterpretCallSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.ReUseSupersetCallSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.TopInputCallSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.plugins.sifa.Activator;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SifaPreferences
extends UltimatePreferenceInitializer {
    public static final String LABEL_ABSTRACT_DOMAIN = "Abstract Domain";
    private static final String DEFAULT_ABSTRACT_DOMAIN = CompoundDomain.class.getSimpleName();
    private static final String[] VALUES_ABSTRACT_DOMAIN = new String[]{ExplicitValueDomain.class.getSimpleName(), IntervalDomain.class.getSimpleName(), OctagonDomain.class.getSimpleName(), EqDomain.class.getSimpleName(), CompoundDomain.class.getSimpleName()};
    public static final String LABEL_LOOP_SUMMARIZER = "Loop Summarizer";
    private static final String DEFAULT_LOOP_SUMMARIZER = FixpointLoopSummarizer.class.getSimpleName();
    private static final String[] VALUES_LOOP_SUMMARIZER = new String[]{FixpointLoopSummarizer.class.getSimpleName()};
    public static final String LABEL_CALL_SUMMARIZER = "Call Summarizer";
    private static final String DEFAULT_CALL_SUMMARIZER = ReUseSupersetCallSummarizer.class.getSimpleName();
    private static final String[] VALUES_CALL_SUMMARIZER = new String[]{TopInputCallSummarizer.class.getSimpleName(), InterpretCallSummarizer.class.getSimpleName(), ReUseSupersetCallSummarizer.class.getSimpleName()};
    public static final String LABEL_FLUID = "Fluid";
    private static final String TOOLTIP_FLUID = "Decides when to apply abstraction";
    private static final String DEFAULT_FLUID = SizeLimitFluid.class.getSimpleName();
    private static final String[] VALUES_FLUID = new String[]{NeverFluid.class.getSimpleName(), SizeLimitFluid.class.getSimpleName(), AlwaysFluid.class.getSimpleName(), LogSizeWrapperFluid.class.getSimpleName()};
    public static final String LABEL_SIMPLIFICATION = "Simplification Technique";
    private static final SmtUtils.SimplificationTechnique DEFAULT_SIMPLIFICATION = SmtUtils.SimplificationTechnique.NONE;
    private static final SmtUtils.SimplificationTechnique[] VALUES_SIMPLIFICATION = SmtUtils.SimplificationTechnique.values();
    public static final Class<SmtUtils.SimplificationTechnique> CLASS_SIMPLIFICATION = SmtUtils.SimplificationTechnique.class;
    public static final String LABEL_EXPLVALDOM_MAX_PARALLEL_STATES = "Max. Parallel Explicit Values";
    private static final int DEFAULT_EXPLVALDOM_MAX_PARALLEL_STATES = 2;
    public static final String LABEL_INTERVALDOM_MAX_PARALLEL_STATES = "Max. Parallel Intervals";
    private static final int DEFAULT_INTERVALDOM_MAX_PARALLEL_STATES = 2;
    public static final String LABEL_OCTAGONDOM_MAX_PARALLEL_STATES = "Max. Parallel Octagon";
    private static final int DEFAULT_OCTAGONDOM_MAX_PARALLEL_STATES = 2;
    public static final String LABEL_EQDOM_MAX_PARALLEL_STATES = "Max. Parallel Equality";
    private static final int DEFAULT_EQDOM_MAX_PARALLEL_STATES = 2;
    public static final String LABEL_COMPOUNDDOM_SUBDOM = "CompoundDomain Intern Domains";
    private static final String DEFAULT_COMPOUNDDOM_SUBDOM = ExplicitValueDomain.class.getSimpleName() + ";" + IntervalDomain.class.getSimpleName();
    private static final String[] CHOICES_COMPOUNDDOM_SUBDOM = SifaPreferences.filter(VALUES_ABSTRACT_DOMAIN, string -> !CompoundDomain.class.getSimpleName().equals(string));
    private static final String TOOLTIP_COMPOUNDDOM_SUBDOM = "List subdomains separated by `;`. Valid subdomains are\n" + String.join((CharSequence)"\n", CHOICES_COMPOUNDDOM_SUBDOM);
    public static final String LABEL_LOGFLUID_INTERN_FLUID = "LogSizeWrapperFluid Intern Fluid";
    private static final String DEFAULT_LOGFLUID_INTERN_FLUID = DEFAULT_FLUID;
    private static final String[] VALUES_LOGFLUID_INTERN_FLUID_VALUES = SifaPreferences.filter(VALUES_FLUID, string -> !LogSizeWrapperFluid.class.getSimpleName().equals(string));
    public static final String LABEL_SIZELIMITFLUID_MAX_DAGSIZE = "SizeLimitFluid Max. DAG Size";
    public static final String TOOLTIP_SIZELIMITFLUID_MAX_DAGSIZE = "Abstract when formula's dag size exceeds\n(negative numbers disable this limit)";
    private static final int DEFAULT_SIZELIMITFLUID_MAX_DAGSIZE = -1;
    public static final String LABEL_SIZELIMITFLUID_MAX_DISJUNCTS = "SizeLimitFluid Max. Disjunctions";
    public static final String TOOLTIP_SIZELIMITFLUID_MAX_DISJUNCTS = "Abstract when formula has more disjuncts than\n(negative numbers disable this limit)";
    private static final int DEFAULT_SIZELIMITFLUID_MAX_DISJUNCTS = 8;

    public SifaPreferences() {
        super(Activator.PLUGIN_ID, "Sifa");
    }

    protected BaseUltimatePreferenceItem[] initDefaultPreferences() {
        UltimatePreferenceItemContainer ultimatePreferenceItemContainer = new UltimatePreferenceItemContainer(ExplicitValueDomain.class.getSimpleName());
        ultimatePreferenceItemContainer.addItem(SifaPreferences.integer(LABEL_EXPLVALDOM_MAX_PARALLEL_STATES, 2, 1, Integer.MAX_VALUE));
        UltimatePreferenceItemContainer ultimatePreferenceItemContainer2 = new UltimatePreferenceItemContainer(IntervalDomain.class.getSimpleName());
        ultimatePreferenceItemContainer2.addItem(SifaPreferences.integer(LABEL_INTERVALDOM_MAX_PARALLEL_STATES, 2, 1, Integer.MAX_VALUE));
        UltimatePreferenceItemContainer ultimatePreferenceItemContainer3 = new UltimatePreferenceItemContainer(OctagonDomain.class.getSimpleName());
        ultimatePreferenceItemContainer3.addItem(SifaPreferences.integer(LABEL_OCTAGONDOM_MAX_PARALLEL_STATES, 2, 1, Integer.MAX_VALUE));
        UltimatePreferenceItemContainer ultimatePreferenceItemContainer4 = new UltimatePreferenceItemContainer(EqDomain.class.getSimpleName());
        ultimatePreferenceItemContainer4.addItem(SifaPreferences.integer(LABEL_EQDOM_MAX_PARALLEL_STATES, 2, 1, Integer.MAX_VALUE));
        UltimatePreferenceItemContainer ultimatePreferenceItemContainer5 = new UltimatePreferenceItemContainer(CompoundDomain.class.getSimpleName());
        ultimatePreferenceItemContainer5.addItem(SifaPreferences.string(LABEL_COMPOUNDDOM_SUBDOM, TOOLTIP_COMPOUNDDOM_SUBDOM, DEFAULT_COMPOUNDDOM_SUBDOM, new SubdomainValidator()));
        UltimatePreferenceItemContainer ultimatePreferenceItemContainer6 = new UltimatePreferenceItemContainer(LogSizeWrapperFluid.class.getSimpleName());
        ultimatePreferenceItemContainer6.addItem(SifaPreferences.combo(LABEL_LOGFLUID_INTERN_FLUID, DEFAULT_LOGFLUID_INTERN_FLUID, VALUES_LOGFLUID_INTERN_FLUID_VALUES));
        UltimatePreferenceItemContainer ultimatePreferenceItemContainer7 = new UltimatePreferenceItemContainer(SizeLimitFluid.class.getSimpleName());
        ultimatePreferenceItemContainer7.addItem(SifaPreferences.integer(LABEL_SIZELIMITFLUID_MAX_DAGSIZE, TOOLTIP_SIZELIMITFLUID_MAX_DAGSIZE, -1));
        ultimatePreferenceItemContainer7.addItem(SifaPreferences.integer(LABEL_SIZELIMITFLUID_MAX_DISJUNCTS, TOOLTIP_SIZELIMITFLUID_MAX_DISJUNCTS, 8));
        return new BaseUltimatePreferenceItem[]{SifaPreferences.combo(LABEL_ABSTRACT_DOMAIN, DEFAULT_ABSTRACT_DOMAIN, VALUES_ABSTRACT_DOMAIN), SifaPreferences.combo(LABEL_LOOP_SUMMARIZER, DEFAULT_LOOP_SUMMARIZER, VALUES_LOOP_SUMMARIZER), SifaPreferences.combo(LABEL_CALL_SUMMARIZER, DEFAULT_CALL_SUMMARIZER, VALUES_CALL_SUMMARIZER), SifaPreferences.combo(LABEL_FLUID, TOOLTIP_FLUID, DEFAULT_FLUID, VALUES_FLUID), SifaPreferences.combo(LABEL_SIMPLIFICATION, DEFAULT_SIMPLIFICATION, VALUES_SIMPLIFICATION), ultimatePreferenceItemContainer, ultimatePreferenceItemContainer2, ultimatePreferenceItemContainer3, ultimatePreferenceItemContainer4, ultimatePreferenceItemContainer5, ultimatePreferenceItemContainer6, ultimatePreferenceItemContainer7};
    }

    public static IPreferenceProvider getPreferenceProvider(IUltimateServiceProvider iUltimateServiceProvider) {
        return iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID);
    }

    private static <T> UltimatePreferenceItem<T> combo(String string, T t, T[] TArray) {
        return new UltimatePreferenceItem(string, t, PreferenceType.Combo, (Object[])TArray);
    }

    private static <T> UltimatePreferenceItem<T> combo(String string, String string2, T t, T[] TArray) {
        return new UltimatePreferenceItem(string, t, string2, PreferenceType.Combo, (Object[])TArray);
    }

    private static UltimatePreferenceItem<Integer> integer(String string, int n) {
        return SifaPreferences.integer(string, n, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static UltimatePreferenceItem<Integer> integer(String string, int n, int n2, int n3) {
        return new UltimatePreferenceItem(string, (Object)n, PreferenceType.Integer, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)new UltimatePreferenceItem.IUltimatePreferenceItemValidator.IntegerValidator(n2, n3));
    }

    private static UltimatePreferenceItem<Integer> integer(String string, String string2, int n) {
        return new UltimatePreferenceItem(string, (Object)n, string2, PreferenceType.Integer);
    }

    private static UltimatePreferenceItem<String> string(String string, String string2, String string3, UltimatePreferenceItem.IUltimatePreferenceItemValidator<String> iUltimatePreferenceItemValidator) {
        return new UltimatePreferenceItem(string, (Object)string3, string2, PreferenceType.String, iUltimatePreferenceItemValidator);
    }

    private static UltimatePreferenceItem<Boolean> bool(String string, String string2, boolean bl) {
        return new UltimatePreferenceItem(string, (Object)bl, string2, PreferenceType.Boolean);
    }

    private static String[] filter(String[] stringArray, Predicate<String> predicate) {
        return (String[])Arrays.stream(stringArray).filter(predicate).toArray(String[]::new);
    }

    public static class SubdomainValidator
    implements UltimatePreferenceItem.IUltimatePreferenceItemValidator<String> {
        public static Stream<String> subdomains(String string) {
            return Arrays.stream(string.split(";"));
        }

        public boolean isValid(String string) {
            return SubdomainValidator.subdomains(string).allMatch(SubdomainValidator::isValidSubDom);
        }

        private static boolean isValidSubDom(String string) {
            return Arrays.stream(CHOICES_COMPOUNDDOM_SUBDOM).anyMatch(string2 -> string2.equals(string));
        }

        public String getInvalidValueErrorMessage(String string2) {
            return SubdomainValidator.subdomains(string2).filter(string -> !SubdomainValidator.isValidSubDom(string)).map(string -> String.format("Not a valid subdomain: %s", string)).collect(Collectors.joining("\n"));
        }
    }
}

