/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.StateContainer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.Summary;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.ITransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

class RunConstructor<LETTER, STATE> {
    private final AutomataLibraryServices mServices;
    private final NestedWordAutomatonReachableStates<LETTER, STATE> mNwars;
    private final StateContainer<LETTER, STATE> mStart;
    private final StateContainer<LETTER, STATE> mGoal;
    private final Set<SummaryWithObligation> mForbiddenSummaries;
    private final boolean mFindSummary;
    private final Summary<LETTER, STATE> mSummary;
    private final boolean mSummaryMustContainAccepting;
    private boolean mGoalFound;
    private final Set<StateContainerWithObligation> mVisited = new HashSet<StateContainerWithObligation>();

    public RunConstructor(AutomataLibraryServices automataLibraryServices, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates, StateContainer<LETTER, STATE> stateContainer) {
        this.mServices = automataLibraryServices;
        this.mNwars = nestedWordAutomatonReachableStates;
        this.mStart = stateContainer;
        this.mGoal = null;
        this.mForbiddenSummaries = Collections.emptySet();
        this.mFindSummary = false;
        this.mSummary = null;
        this.mSummaryMustContainAccepting = false;
    }

    public RunConstructor(AutomataLibraryServices automataLibraryServices, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates, Summary<LETTER, STATE> summary, boolean bl) {
        this.mServices = automataLibraryServices;
        this.mNwars = nestedWordAutomatonReachableStates;
        this.mStart = summary.getLinPred();
        this.mGoal = summary.getHierPred();
        this.mFindSummary = true;
        this.mSummary = summary;
        this.mSummaryMustContainAccepting = bl;
        SummaryWithObligation summaryWithObligation = new SummaryWithObligation(this.mSummary, this.mSummaryMustContainAccepting);
        this.mForbiddenSummaries = Collections.singleton(summaryWithObligation);
    }

    private RunConstructor(AutomataLibraryServices automataLibraryServices, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates, Summary<LETTER, STATE> summary, boolean bl, Set<SummaryWithObligation> set) {
        this.mServices = automataLibraryServices;
        this.mNwars = nestedWordAutomatonReachableStates;
        this.mStart = summary.getLinPred();
        this.mGoal = summary.getHierPred();
        this.mFindSummary = true;
        this.mSummary = summary;
        this.mSummaryMustContainAccepting = bl;
        SummaryWithObligation summaryWithObligation = new SummaryWithObligation(this.mSummary, this.mSummaryMustContainAccepting);
        this.mForbiddenSummaries = new HashSet<SummaryWithObligation>(set);
        this.mForbiddenSummaries.add(summaryWithObligation);
    }

    private Collection<TransitionWithObligation> findSuitablePredecessors(StateContainerWithObligation stateContainerWithObligation) {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        Set<TransitionWithObligation> set = this.findSuitablePredecessorsInternal(stateContainerWithObligation, treeMap);
        if (set != null) {
            return set;
        }
        set = this.findSuitablePredecessorsCall(stateContainerWithObligation, treeMap);
        if (set != null) {
            return set;
        }
        set = this.findSuitablePredecessorsReturn(stateContainerWithObligation, treeMap);
        if (set != null) {
            return set;
        }
        ArrayList<TransitionWithObligation> arrayList = new ArrayList<TransitionWithObligation>();
        for (Object v : treeMap.values()) {
            Object object;
            if (v instanceof TransitionWithObligation) {
                object = (TransitionWithObligation)v;
                assert (((ObjectWithObligation)object).getObject() instanceof IncomingInternalTransition || ((ObjectWithObligation)object).getObject() instanceof IncomingCallTransition);
                arrayList.add((TransitionWithObligation)object);
                continue;
            }
            assert (v instanceof SortedMap);
            object = (SortedMap)v;
            arrayList.addAll(object.values());
        }
        return arrayList;
    }

    private Set<TransitionWithObligation> findSuitablePredecessorsInternal(StateContainerWithObligation stateContainerWithObligation, SortedMap<Integer, Object> sortedMap) {
        for (IncomingInternalTransition<LETTER, STATE> incomingInternalTransition : this.mNwars.internalPredecessors(((StateContainer)stateContainerWithObligation.getObject()).getState())) {
            StateContainerWithObligation stateContainerWithObligation2;
            boolean bl;
            if (!this.mFindSummary && this.mNwars.isInitial(incomingInternalTransition.getPred())) {
                this.mGoalFound = true;
                return Collections.singleton(new TransitionWithObligation(incomingInternalTransition, false));
            }
            StateContainer<LETTER, STATE> stateContainer = this.mNwars.obtainStateContainer(incomingInternalTransition.getPred());
            if (this.mFindSummary && !stateContainer.getDownStates().containsKey(this.mGoal.getState())) continue;
            boolean bl2 = bl = stateContainerWithObligation.hasObligation() && !this.mNwars.isFinal(stateContainer.getState());
            if (bl) {
                assert (this.mFindSummary);
                if (!stateContainer.hasDownProp(this.mGoal.getState(), StateContainer.DownStateProp.REACHABLE_FROM_FINAL_WITHOUT_CALL)) continue;
            }
            if (this.mVisited.contains(stateContainerWithObligation2 = new StateContainerWithObligation(stateContainer, bl))) continue;
            int n = stateContainer.getSerialNumber();
            sortedMap.put(n, new TransitionWithObligation(incomingInternalTransition, bl));
        }
        return null;
    }

    private Set<TransitionWithObligation> findSuitablePredecessorsCall(StateContainerWithObligation stateContainerWithObligation, SortedMap<Integer, Object> sortedMap) {
        for (IncomingCallTransition<LETTER, STATE> incomingCallTransition : this.mNwars.callPredecessors(((StateContainer)stateContainerWithObligation.getObject()).getState())) {
            Integer n;
            StateContainer<LETTER, STATE> stateContainer = this.mNwars.obtainStateContainer(incomingCallTransition.getPred());
            if (this.mFindSummary) {
                if (!this.mGoal.equals(stateContainer) || stateContainerWithObligation.hasObligation()) continue;
                this.mGoalFound = true;
                return Collections.singleton(new TransitionWithObligation(incomingCallTransition, false));
            }
            assert (!stateContainerWithObligation.hasObligation());
            if (this.mNwars.isInitial(incomingCallTransition.getPred())) {
                this.mGoalFound = true;
                return Collections.singleton(new TransitionWithObligation(incomingCallTransition, false));
            }
            StateContainerWithObligation stateContainerWithObligation2 = new StateContainerWithObligation(stateContainer, false);
            if (this.mVisited.contains(stateContainerWithObligation2) || sortedMap.containsKey(n = Integer.valueOf(stateContainer.getSerialNumber()))) continue;
            sortedMap.put(n, new TransitionWithObligation(incomingCallTransition, false));
        }
        return null;
    }

    private Set<TransitionWithObligation> findSuitablePredecessorsReturn(StateContainerWithObligation stateContainerWithObligation, SortedMap<Integer, Object> sortedMap) {
        for (IncomingReturnTransition<LETTER, STATE> incomingReturnTransition : this.mNwars.returnPredecessors(((StateContainer)stateContainerWithObligation.getObject()).getState())) {
            TreeMap<Integer, TransitionWithObligation> treeMap;
            Integer n;
            Object v;
            StateContainerWithObligation stateContainerWithObligation2;
            boolean bl;
            if (!this.mFindSummary && this.mNwars.isInitial(incomingReturnTransition.getHierPred())) {
                this.mGoalFound = true;
                return Collections.singleton(new TransitionWithObligation(incomingReturnTransition, false));
            }
            StateContainer<LETTER, STATE> stateContainer = this.mNwars.obtainStateContainer(incomingReturnTransition.getHierPred());
            if (this.mFindSummary && !stateContainer.getDownStates().containsKey(this.mGoal.getState())) continue;
            Summary<LETTER, STATE> summary = new Summary<LETTER, STATE>(this.mNwars.obtainStateContainer(incomingReturnTransition.getHierPred()), this.mNwars.obtainStateContainer(incomingReturnTransition.getLinPred()), incomingReturnTransition.getLetter(), (StateContainer)stateContainerWithObligation.getObject());
            boolean bl2 = this.willSummarySatisfyObligation(stateContainerWithObligation, stateContainer, summary);
            SummaryWithObligation summaryWithObligation = new SummaryWithObligation(summary, false);
            if (bl2) {
                assert (!this.mForbiddenSummaries.contains(summaryWithObligation));
            } else if (this.mForbiddenSummaries.contains(summaryWithObligation)) continue;
            boolean bl3 = bl = stateContainerWithObligation.hasObligation() && !this.mNwars.isFinal(stateContainer.getState()) && !bl2;
            if (bl) {
                assert (this.mFindSummary);
                if (!stateContainer.hasDownProp(this.mGoal.getState(), StateContainer.DownStateProp.REACHABLE_FROM_FINAL_WITHOUT_CALL)) continue;
            }
            if (this.mVisited.contains(stateContainerWithObligation2 = new StateContainerWithObligation(stateContainer, bl)) || (v = sortedMap.get(n = Integer.valueOf(stateContainer.getSerialNumber()))) instanceof TransitionWithObligation) continue;
            assert (v == null || v instanceof SortedMap);
            if (v == null) {
                treeMap = new TreeMap<Integer, TransitionWithObligation>();
                sortedMap.put(n, treeMap);
            } else {
                treeMap = (TreeMap<Integer, TransitionWithObligation>)v;
            }
            StateContainer<LETTER, STATE> stateContainer2 = this.mNwars.obtainStateContainer(incomingReturnTransition.getLinPred());
            int n2 = stateContainer2.getSerialNumber();
            treeMap.put(n2, new TransitionWithObligation(incomingReturnTransition, bl));
        }
        return null;
    }

    private boolean willSummarySatisfyObligation(StateContainerWithObligation stateContainerWithObligation, StateContainer<LETTER, STATE> stateContainer, Summary<LETTER, STATE> summary) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = stateContainerWithObligation.hasObligation() && !this.mNwars.isFinal(stateContainer.getState()) && this.mNwars.isAccepting(summary);
        if (bl2) {
            boolean bl4;
            SummaryWithObligation summaryWithObligation = new SummaryWithObligation(summary, true);
            boolean bl5 = bl4 = !this.mForbiddenSummaries.contains(summaryWithObligation);
            bl = bl4;
        } else {
            bl = false;
        }
        return bl;
    }

    NestedRun<LETTER, STATE> constructRun() throws AutomataOperationCanceledException {
        StateContainerWithObligation stateContainerWithObligation;
        if (this.mServices.getProgressAwareTimer() != null && !this.mServices.getProgressAwareTimer().continueProcessing()) {
            throw new AutomataOperationCanceledException(this.getClass());
        }
        assert (!this.mSummaryMustContainAccepting || this.mGoal != null);
        if (!this.mFindSummary && this.mNwars.isInitial(this.mStart.getState())) {
            return new NestedRun(this.mStart.getState());
        }
        boolean bl = this.mSummaryMustContainAccepting && !this.mNwars.isFinal(this.mStart.getState());
        StateContainerWithObligation stateContainerWithObligation2 = stateContainerWithObligation = new StateContainerWithObligation(this.mStart, bl);
        ArrayDeque<Iterator<TransitionWithObligation>> arrayDeque = new ArrayDeque<Iterator<TransitionWithObligation>>();
        ArrayDeque<RunWithObligation> arrayDeque2 = new ArrayDeque<RunWithObligation>();
        return this.constructRunLoop(stateContainerWithObligation, stateContainerWithObligation2, arrayDeque, arrayDeque2);
    }

    private NestedRun<LETTER, STATE> constructRunLoop(StateContainerWithObligation stateContainerWithObligation, StateContainerWithObligation stateContainerWithObligation2, Deque<Iterator<TransitionWithObligation>> deque, Deque<RunWithObligation> deque2) throws AutomataOperationCanceledException, AssertionError {
        Object object = stateContainerWithObligation2;
        boolean bl = false;
        while (true) {
            Object object2;
            NestedRun nestedRun;
            Object object3;
            StateContainer<LETTER, STATE> stateContainer;
            Object object4;
            Object object5;
            if (bl) {
                bl = false;
            } else {
                assert (!this.mVisited.contains(object));
                this.mVisited.add((StateContainerWithObligation)object);
                assert (deque.size() == deque2.size());
                object5 = this.findSuitablePredecessors((StateContainerWithObligation)object);
                deque.push(object5.iterator());
            }
            while (!deque.peek().hasNext()) {
                deque.pop();
                if (deque2.isEmpty()) {
                    assert (this.mGoal != null);
                    return null;
                }
                object5 = deque2.pop();
                object4 = ((RunWithObligation)object5).getStateWithObligation();
                assert (this.mVisited.contains(object4));
                this.mVisited.remove(object4);
                if (deque2.isEmpty()) {
                    object = stateContainerWithObligation;
                    continue;
                }
                stateContainer = deque2.peek();
                object = ((RunWithObligation)((Object)stateContainer)).getStateWithObligation();
            }
            object5 = deque.peek().next();
            assert (object5 != null);
            object4 = (ITransitionlet)((ObjectWithObligation)object5).getObject();
            if (object4 instanceof IncomingInternalTransition) {
                object3 = (IncomingInternalTransition)object4;
                stateContainer = this.mNwars.obtainStateContainer(((IncomingInternalTransition)object3).getPred());
                nestedRun = new NestedRun(((IncomingInternalTransition)object3).getPred(), ((IncomingInternalTransition)object3).getLetter(), -2, ((StateContainer)((ObjectWithObligation)object).getObject()).getState());
            } else if (object4 instanceof IncomingCallTransition) {
                object3 = (IncomingCallTransition)object4;
                stateContainer = this.mNwars.obtainStateContainer(((IncomingCallTransition)object3).getPred());
                nestedRun = new NestedRun(((IncomingCallTransition)object3).getPred(), ((IncomingCallTransition)object3).getLetter(), Integer.MAX_VALUE, ((StateContainer)((ObjectWithObligation)object).getObject()).getState());
            } else if (object4 instanceof IncomingReturnTransition) {
                boolean bl2;
                object3 = (IncomingReturnTransition)object4;
                stateContainer = this.mNwars.obtainStateContainer(((IncomingReturnTransition)object3).getHierPred());
                object2 = new Summary<LETTER, STATE>(stateContainer, this.mNwars.obtainStateContainer(((IncomingReturnTransition)object3).getLinPred()), ((IncomingReturnTransition)object3).getLetter(), (StateContainer)((ObjectWithObligation)object).getObject());
                boolean bl3 = bl2 = ((ObjectWithObligation)object).hasObligation() && !((ObjectWithObligation)object5).hasObligation() && !this.mNwars.isFinal(stateContainer.getState());
                assert (!bl2 || this.mNwars.isAccepting((Summary<LETTER, STATE>)object2));
                RunConstructor<LETTER, STATE> runConstructor = new RunConstructor<LETTER, STATE>(this.mServices, this.mNwars, object2, bl2, this.mForbiddenSummaries);
                nestedRun = runConstructor.constructRun();
                if (nestedRun == null) {
                    bl = true;
                    continue;
                }
            } else {
                throw new AssertionError();
            }
            assert (this.isLastStateInRun((StateContainer)((ObjectWithObligation)object).getObject(), nestedRun));
            object3 = new StateContainerWithObligation(stateContainer, ((ObjectWithObligation)object5).hasObligation());
            object2 = new RunWithObligation((StateContainer)((ObjectWithObligation)object3).getObject(), ((ObjectWithObligation)object3).hasObligation(), nestedRun);
            deque2.push((RunWithObligation)object2);
            if (this.mGoalFound) {
                return this.constructResult(deque2);
            }
            object = object3;
        }
    }

    private NestedRun<LETTER, STATE> constructResult(Deque<RunWithObligation> deque) {
        Iterator<RunWithObligation> iterator = deque.descendingIterator();
        NestedRun<LETTER, STATE> nestedRun = iterator.next().getNestedRun();
        while (iterator.hasNext()) {
            nestedRun = iterator.next().getNestedRun().concatenate(nestedRun);
        }
        assert (this.isLastStateInRun(this.mStart, nestedRun));
        if (this.mFindSummary) {
            NestedRun<LETTER, STATE> nestedRun2 = new NestedRun<LETTER, STATE>(this.mSummary.getLinPred().getState(), this.mSummary.getLetter(), Integer.MIN_VALUE, this.mSummary.getSucc().getState());
            nestedRun = nestedRun.concatenate(nestedRun2);
        }
        return nestedRun;
    }

    private boolean isLastStateInRun(StateContainer<LETTER, STATE> stateContainer, NestedRun<LETTER, STATE> nestedRun) {
        return stateContainer.getState() == nestedRun.getStateAtPosition(nestedRun.getLength() - 1);
    }

    private static class ObjectWithObligation<E> {
        private final E mObject;
        private final boolean mFlag;

        public ObjectWithObligation(E e, boolean bl) {
            this.mObject = e;
            this.mFlag = bl;
        }

        public E getObject() {
            return this.mObject;
        }

        public boolean hasObligation() {
            return this.mFlag;
        }

        public int hashCode() {
            int n = 31 + (this.mFlag ? 1231 : 1237);
            n = 31 * n + (this.mObject == null ? 0 : this.mObject.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ObjectWithObligation objectWithObligation = (ObjectWithObligation)object;
            if (this.mFlag != objectWithObligation.mFlag) {
                return false;
            }
            return !(this.mObject == null ? objectWithObligation.mObject != null : !this.mObject.equals(objectWithObligation.mObject));
        }

        public String toString() {
            return "ObjectWithObligation [mObject=" + String.valueOf(this.mObject) + ", mFlag=" + this.mFlag + "]";
        }
    }

    private class RunWithObligation
    extends StateContainerWithObligation {
        private final NestedRun<LETTER, STATE> mNestedRun;

        public RunWithObligation(StateContainer<LETTER, STATE> stateContainer, boolean bl, NestedRun<LETTER, STATE> nestedRun) {
            super(stateContainer, bl);
            this.mNestedRun = nestedRun;
        }

        public NestedRun<LETTER, STATE> getNestedRun() {
            return this.mNestedRun;
        }

        public StateContainerWithObligation getStateWithObligation() {
            return new StateContainerWithObligation((StateContainer)this.getObject(), this.hasObligation());
        }
    }

    private class StateContainerWithObligation
    extends ObjectWithObligation<StateContainer<LETTER, STATE>> {
        public StateContainerWithObligation(StateContainer<LETTER, STATE> stateContainer, boolean bl) {
            super(stateContainer, bl);
        }
    }

    private class SummaryWithObligation
    extends ObjectWithObligation<Summary<LETTER, STATE>> {
        public SummaryWithObligation(Summary<LETTER, STATE> summary, boolean bl) {
            super(summary, bl);
        }
    }

    private class TransitionWithObligation
    extends ObjectWithObligation<ITransitionlet<LETTER, STATE>> {
        public TransitionWithObligation(ITransitionlet<LETTER, STATE> iTransitionlet, boolean bl) {
            super(iTransitionlet, bl);
        }
    }
}

