/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

class ProgramVariableTransferrer {
    private final ConstructionCache<ILocalProgramVar, ILocalProgramVar> mILocalProgramVarCC;
    private final ConstructionCache<IProgramNonOldVar, IProgramNonOldVar> mIProgramNonOldVarCC;
    private final ConstructionCache<IProgramConst, IProgramConst> mIProgramConstCC;

    public ProgramVariableTransferrer(final TermTransferrer termTransferrer, final ManagedScript managedScript) {
        this.mILocalProgramVarCC = new ConstructionCache((ConstructionCache.IValueConstruction)new ConstructionCache.IValueConstruction<ILocalProgramVar, ILocalProgramVar>(){

            public ILocalProgramVar constructValue(ILocalProgramVar iLocalProgramVar) {
                managedScript.lock((Object)this);
                ILocalProgramVar iLocalProgramVar2 = (ILocalProgramVar)ProgramVarUtils.transferProgramVar((TermTransferrer)termTransferrer, (IProgramVar)iLocalProgramVar);
                managedScript.unlock((Object)this);
                return iLocalProgramVar2;
            }
        });
        this.mIProgramNonOldVarCC = new ConstructionCache((ConstructionCache.IValueConstruction)new ConstructionCache.IValueConstruction<IProgramNonOldVar, IProgramNonOldVar>(){

            public IProgramNonOldVar constructValue(IProgramNonOldVar iProgramNonOldVar) {
                managedScript.lock((Object)this);
                IProgramNonOldVar iProgramNonOldVar2 = (IProgramNonOldVar)ProgramVarUtils.transferProgramVar((TermTransferrer)termTransferrer, (IProgramVar)iProgramNonOldVar);
                managedScript.unlock((Object)this);
                return iProgramNonOldVar2;
            }
        });
        this.mIProgramConstCC = new ConstructionCache(iProgramConst -> {
            String string = iProgramConst.getIdentifier();
            ApplicationTerm applicationTerm = (ApplicationTerm)termTransferrer.transform((Term)iProgramConst.getDefaultConstant());
            return new ProgramConst(string, applicationTerm, false);
        });
    }

    public ILocalProgramVar getOrConstruct(ILocalProgramVar iLocalProgramVar) {
        return (ILocalProgramVar)this.mILocalProgramVarCC.getOrConstruct((Object)iLocalProgramVar);
    }

    public IProgramNonOldVar getOrConstruct(IProgramNonOldVar iProgramNonOldVar) {
        return (IProgramNonOldVar)this.mIProgramNonOldVarCC.getOrConstruct((Object)iProgramNonOldVar);
    }

    public IProgramOldVar getOrConstruct(IProgramOldVar iProgramOldVar) {
        return ((IProgramNonOldVar)this.mIProgramNonOldVarCC.getOrConstruct((Object)iProgramOldVar.getNonOldVar())).getOldVar();
    }

    public IProgramConst getOrConstruct(IProgramConst iProgramConst) {
        return (IProgramConst)this.mIProgramConstCC.getOrConstruct((Object)iProgramConst);
    }

    public Map<ILocalProgramVar, ILocalProgramVar> getILocalProgramVarMap() {
        return Collections.unmodifiableMap(this.mILocalProgramVarCC);
    }

    public Map<IProgramNonOldVar, IProgramNonOldVar> getIProgramNonOldVarMap() {
        return Collections.unmodifiableMap(this.mIProgramNonOldVarCC);
    }

    public Map<IProgramConst, IProgramConst> getIProgramConstMap() {
        return Collections.unmodifiableMap(this.mIProgramConstCC);
    }

    public Map<Term, Term> getIProgramConstTermMap() {
        return this.getIProgramConstMap().entrySet().stream().collect(Collectors.toMap(entry -> ((IProgramConst)entry.getKey()).getDefaultConstant(), entry -> ((IProgramConst)entry.getValue()).getDefaultConstant()));
    }

    public IProgramVar translateProgramVar(IProgramVar iProgramVar) {
        IProgramVar iProgramVar2;
        if (iProgramVar instanceof ILocalProgramVar) {
            iProgramVar2 = (IProgramVar)this.getILocalProgramVarMap().get(iProgramVar);
        } else if (iProgramVar instanceof IProgramNonOldVar) {
            iProgramVar2 = (IProgramVar)this.getIProgramNonOldVarMap().get(iProgramVar);
        } else if (iProgramVar instanceof IProgramOldVar) {
            iProgramVar2 = this.getIProgramNonOldVarMap().get(((IProgramOldVar)iProgramVar).getNonOldVar()).getOldVar();
        } else {
            throw new UnsupportedOperationException(iProgramVar.getClass().getSimpleName());
        }
        assert (iProgramVar2 != null);
        return iProgramVar2;
    }

    public IProgramConst translateProgramConst(IProgramConst iProgramConst) {
        return this.getIProgramConstMap().get(iProgramConst);
    }
}

