/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie.generator;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.BoogieDeclarations;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.lib.pea.Transition;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IteRemover;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPushTermWalker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.lib.srparse.Durations;
import de.uni_freiburg.informatik.ultimate.lib.srparse.LiteralUtils;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.Activator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.CddToSmt;
import de.uni_freiburg.informatik.ultimate.pea2boogie.IReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.PeaResultUtil;
import de.uni_freiburg.informatik.ultimate.pea2boogie.generator.SimplePredicateFactory;
import de.uni_freiburg.informatik.ultimate.pea2boogie.generator.StrictInvariant;
import de.uni_freiburg.informatik.ultimate.pea2boogie.translator.EpsilonTransformer;
import de.uni_freiburg.informatik.ultimate.pea2boogie.translator.IEpsilonTransformer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.CrossProducts;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class RtInconcistencyConditionGenerator {
    private static final boolean ONLY_CONJUNCTIVE_INVARIANTS = false;
    private static final boolean SIMPLIFY_BEFORE_QELIM = false;
    private static final boolean TRY_SOLVER_BEFORE_QELIM = false;
    private static final boolean PRINT_STATS = true;
    private static final boolean PRINT_QUANTIFIED_FORMULAS = false;
    private static final boolean PRINT_NON_TRIVIAL_CHECKS = false;
    private static final boolean PRINT_PEA_DOT = false;
    private static final boolean PRINT_INDIVIDUAL_RT_INCONSISTENCY_CHECK = false;
    private static final String SOLVER_LOG_DIR = null;
    private final IReqSymbolTable mReqSymboltable;
    private final Term mPrimedInvariant;
    private final Script mScript;
    private final Term mTrue;
    private final Term mFalse;
    private final ManagedScript mManagedScript;
    private final Boogie2SMT mBoogie2Smt;
    private final Map<String, IProgramNonOldVar> mVars;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final boolean mSeparateInvariantHandling;
    private final CddToSmt mCddToSmt;
    private final ConstructionCache<Term, Term> mProjectionCache;
    private final ConstructionCache<Phase, Term> mPhaseNdcCache;
    private final ConstructionCache<Transition, Term> mNdcGuardTermCache;
    private final ConstructionCache<Phase, Term> mNdcStateInvariantCache;
    private final ConstructionCache<Transition, Term> mNdcClockInvariantCache;
    private int mQuantified;
    private int mPlain;
    private int mAfterSize;
    private int mBeforeSize;
    private int mTrivialConsistent;
    private int mGeneratedChecks;
    private int mQuantifiedQuery;
    private int mQelimQuery;
    private final Map<Term, Term> mConstInlineMap;
    private final ILogger mPQELogger;
    private final IEpsilonTransformer mEpsilonTransformer;

    public RtInconcistencyConditionGenerator(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, PeaResultUtil peaResultUtil, IReqSymbolTable iReqSymbolTable, List<PatternType.ReqPeas> list, BoogieDeclarations boogieDeclarations, Durations durations, boolean bl) throws InvariantInfeasibleException {
        this.mReqSymboltable = iReqSymbolTable;
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mPQELogger = this.mServices.getLoggingService().getLogger(RtInconcistencyConditionGenerator.class.getName() + ".PQE");
        this.mPQELogger.setLevel(ILogger.LogLevel.WARN);
        this.mServices.getLoggingService().setLogLevel(QuantifierPusher.class, ILogger.LogLevel.WARN);
        this.mScript = RtInconcistencyConditionGenerator.buildSolver(iUltimateServiceProvider);
        this.mManagedScript = new ManagedScript(iUltimateServiceProvider, this.mScript);
        this.mTrue = this.mScript.term("true", new Term[0]);
        this.mFalse = this.mScript.term("false", new Term[0]);
        this.mBoogie2Smt = new Boogie2SMT(this.mManagedScript, boogieDeclarations, iUltimateServiceProvider, false);
        this.mVars = this.mBoogie2Smt.getBoogie2SmtSymbolTable().getGlobalsMap();
        this.mSeparateInvariantHandling = bl;
        this.mPhaseNdcCache = new ConstructionCache(this::constructNdcPhase);
        this.mProjectionCache = new ConstructionCache(this::computeExistentialProjection);
        this.mNdcGuardTermCache = new ConstructionCache(this::constructNdcGuardTerm);
        this.mNdcStateInvariantCache = new ConstructionCache(this::constructNdcStateInvariant);
        this.mNdcClockInvariantCache = new ConstructionCache(this::constructNdcClockInvariantTerm);
        this.mQuantified = 0;
        this.mPlain = 0;
        this.mBeforeSize = 0;
        this.mAfterSize = 0;
        this.mTrivialConsistent = 0;
        this.mGeneratedChecks = 0;
        this.mQuantifiedQuery = 0;
        this.mQelimQuery = 0;
        this.mCddToSmt = new CddToSmt(iUltimateServiceProvider, peaResultUtil, this.mScript, this.mBoogie2Smt, boogieDeclarations, this.mReqSymboltable);
        boolean bl2 = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Use epsilon transformation during rt-inconsistency check");
        if (bl2) {
            this.mLogger.info("Using epsilon=%s for rt-consistency checks", new Object[]{SmtUtils.toString((Rational)durations.computeEpsilon())});
            this.mEpsilonTransformer = new EpsilonTransformer(this.mScript, durations.computeEpsilon(), this.mReqSymboltable);
        } else {
            this.mEpsilonTransformer = IEpsilonTransformer.identity();
        }
        Map<Term, Term> map = RtInconcistencyConditionGenerator.createConst2Value(this.mScript, this.mReqSymboltable, this.mBoogie2Smt);
        this.mConstInlineMap = Collections.unmodifiableMap(map);
        if (this.mSeparateInvariantHandling) {
            this.mPrimedInvariant = this.toNormalform(this.constructPrimedStateInvariant(list));
            this.mLogger.info((Object)("Finished generating primed state invariant of size " + new DAGSize().size(this.mPrimedInvariant)));
        } else {
            this.mPrimedInvariant = this.mTrue;
        }
    }

    private static Map<Term, Term> createConst2Value(Script script, IReqSymbolTable iReqSymbolTable, Boogie2SMT boogie2SMT) {
        Map<String, Expression> map = iReqSymbolTable.getConstToValue();
        Map map2 = boogie2SMT.getBoogie2SmtSymbolTable().getConstsMap();
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (Map.Entry<String, Expression> entry : map.entrySet()) {
            ProgramConst programConst = (ProgramConst)map2.get(entry.getKey());
            Optional optional = LiteralUtils.toTerm((Expression)entry.getValue(), (Script)script);
            if (!optional.isPresent()) {
                throw new IllegalArgumentException(BoogiePrettyPrinter.print((Expression)entry.getValue()) + " is no literal");
            }
            hashMap.put(programConst.getTerm(), (Term)optional.get());
        }
        return hashMap;
    }

    public List<Map.Entry<PatternType<?>, PhaseEventAutomata>> getRelevantRequirements(List<PatternType.ReqPeas> list) {
        ArrayList arrayList = new ArrayList();
        for (PatternType.ReqPeas reqPeas : list) {
            PatternType patternType = reqPeas.getPattern();
            for (Map.Entry entry2 : reqPeas.getCounterTrace2Pea()) {
                arrayList.add((Map.Entry<PatternType<?>, PhaseEventAutomata>)new Pair((Object)patternType, (Object)((PhaseEventAutomata)entry2.getValue())));
            }
        }
        if (this.mSeparateInvariantHandling) {
            return arrayList.stream().filter(entry -> this.filterReqs((PhaseEventAutomata)entry.getValue())).collect(Collectors.toList());
        }
        return arrayList;
    }

    private boolean filterReqs(PhaseEventAutomata phaseEventAutomata) {
        List list = phaseEventAutomata.getPhases();
        return list.size() != 1;
    }

    private static Script buildSolver(IUltimateServiceProvider iUltimateServiceProvider) throws AssertionError {
        SolverBuilder.SolverSettings solverSettings = SolverBuilder.constructSolverSettings().setSolverMode(SolverBuilder.SolverMode.External_ModelsAndUnsatCoreMode).setUseExternalSolver(SolverBuilder.ExternalSolver.Z3);
        if (SOLVER_LOG_DIR != null) {
            solverSettings = solverSettings.setDumpSmtScriptToFile(true, SOLVER_LOG_DIR, RtInconcistencyConditionGenerator.class.getSimpleName(), false);
        }
        return SolverBuilder.buildAndInitializeSolver((IUltimateServiceProvider)iUltimateServiceProvider, (SolverBuilder.SolverSettings)solverSettings, (String)"RtInconsistencySolver");
    }

    public Expression generateNonDeadlockCondition(PhaseEventAutomata[] phaseEventAutomataArray) {
        Object object2;
        List<int[]> list = RtInconcistencyConditionGenerator.createPhaseVector(phaseEventAutomataArray);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Object object2 : list) {
            PhaseEventAutomata phaseEventAutomata;
            assert (((int[])object2).length == phaseEventAutomataArray.length);
            ArrayList<Term> arrayList2 = new ArrayList<Term>();
            ArrayList<Term> arrayList3 = new ArrayList<Term>();
            int n = 0;
            while (n < ((int[])object2).length) {
                phaseEventAutomata = phaseEventAutomataArray[n];
                int n2 = object2[n];
                arrayList3.add(this.getPcPhaseEquality(this.mReqSymboltable.getPcName(phaseEventAutomata), n2));
                arrayList2.add((Term)this.mPhaseNdcCache.getOrConstruct((Object)((Phase)phaseEventAutomata.getPhases().get(n2))));
                ++n;
            }
            Term term = SmtUtils.and((Script)this.mScript, arrayList2);
            phaseEventAutomata = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term, this.mPrimedInvariant});
            Term term2 = (Term)this.mProjectionCache.getOrConstruct((Object)phaseEventAutomata);
            if (term2 instanceof QuantifiedFormula) {
                ++this.mQuantified;
            } else {
                ++this.mPlain;
            }
            if (term2 == this.mTrue) continue;
            Term term3 = SmtUtils.and((Script)this.mScript, arrayList3);
            Term term4 = SmtUtils.implies((Script)this.mScript, (Term)term3, (Term)term2);
            arrayList.add(term4);
        }
        if (arrayList.isEmpty()) {
            ++this.mTrivialConsistent;
            return null;
        }
        ++this.mGeneratedChecks;
        object2 = SmtUtils.and((Script)this.mScript, arrayList);
        return this.mBoogie2Smt.getTerm2Expression().translate((Term)object2);
    }

    private void printQuantifiedFormula(String string, Supplier<QuantifiedFormula> supplier) {
    }

    public void logStats() {
        this.mLogger.info((Object)String.format("%s checks, %s trivial consistent, %s non-trivial", this.mGeneratedChecks + this.mTrivialConsistent, this.mTrivialConsistent, this.mGeneratedChecks));
        this.mLogger.info((Object)String.format("Of %s formulas, %s were quantified, %s were plain. Needed %s quantifier elimination runs, %s quantified solver queries.", this.mQuantified + this.mPlain, this.mQuantified, this.mPlain, this.mQelimQuery, this.mQuantifiedQuery));
    }

    private Term constructNdcPhase(Phase phase) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Transition transition : phase.getTransitions()) {
            Phase phase2 = transition.getDest();
            Term term = (Term)this.mNdcGuardTermCache.getOrConstruct((Object)transition);
            Term term2 = (Term)this.mNdcClockInvariantCache.getOrConstruct((Object)transition);
            Term term3 = (Term)this.mNdcStateInvariantCache.getOrConstruct((Object)phase2);
            arrayList.add(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term, term3, term2}));
        }
        return SmtUtils.or((Script)this.mScript, arrayList);
    }

    private Term constructNdcGuardTerm(Transition transition) {
        return this.transformAndLog(transition.getGuard(), this.mEpsilonTransformer::transformGuard, "guard");
    }

    private Term constructNdcClockInvariantTerm(Transition transition) {
        return this.transformAndLog(new StrictInvariant().genStrictInv(transition.getDest().getClockInvariant(), transition.getResets()), this.mEpsilonTransformer::transformClockInvariant, "clock invariant");
    }

    private Term transformAndLog(CDD cDD, UnaryOperator<Term> unaryOperator, String string) {
        Term term;
        Term term2 = this.toNormalform(this.mCddToSmt.toSmt(cDD));
        if (term2 != (term = (Term)unaryOperator.apply(term2))) {
            this.mLogger.info("Epsilon-transformed %s %s to %s", new Object[]{string, term2, term});
        }
        return term;
    }

    private Term constructNdcStateInvariant(Phase phase) {
        return this.toNormalform(this.mCddToSmt.toSmt(phase.getStateInvariant().prime(this.mReqSymboltable.getConstVars())));
    }

    private Term simplifyAndLog(Term term) {
        return term;
    }

    private Term simplify(Term term) {
        return SmtUtils.simplify((ManagedScript)this.mManagedScript, (Term)term, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.POLY_PAC);
    }

    private Term constructPrimedStateInvariant(List<PatternType.ReqPeas> list) throws InvariantInfeasibleException {
        Map<PatternType, PatternType.ReqPeas> map;
        PatternType.ReqPeas reqPeas2;
        HashMap<PatternType, CDD> hashMap = new HashMap<PatternType, CDD>();
        for (PatternType.ReqPeas reqPeas2 : list) {
            for (Map.Entry entry2 : reqPeas2.getCounterTrace2Pea()) {
                if (this.filterReqs((PhaseEventAutomata)entry2.getValue())) continue;
                hashMap.put(reqPeas2.getPattern(), ((Phase)((PhaseEventAutomata)entry2.getValue()).getPhases().get(0)).getStateInvariant().prime(this.mReqSymboltable.getConstVars()));
            }
        }
        if (hashMap.isEmpty()) {
            return this.mTrue;
        }
        if (hashMap.size() == 1) {
            Map.Entry entry2;
            entry2 = hashMap.entrySet().iterator().next();
            reqPeas2 = this.mCddToSmt.toSmt((CDD)entry2.getValue());
            map = Collections.singletonMap((PatternType)entry2.getKey(), reqPeas2);
        } else {
            map = hashMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.mCddToSmt.toSmt((CDD)entry.getValue())));
            reqPeas2 = SmtUtils.and((Script)this.mScript, map.values());
        }
        return this.handleInconsistentStateInvariant(map, this.simplify(this.handleInconsistentStateInvariant(map, (Term)reqPeas2)));
    }

    private Term toNormalform(Term term) {
        Term term2 = new IteRemover(this.mManagedScript).transform(term);
        Term term3 = new NnfTransformer(this.mManagedScript, this.mServices, NnfTransformer.QuantifierHandling.KEEP).transform(term2);
        return new CommuhashNormalForm(this.mServices, this.mManagedScript.getScript()).transform(term3);
    }

    private Term handleInconsistentStateInvariant(Map<PatternType<?>, Term> map, Term term2) throws InvariantInfeasibleException {
        Term[] termArray;
        if (this.mFalse != term2) {
            return term2;
        }
        Function<TermVariable, IProgramVar> function = termVariable -> (IProgramVar)this.mVars.get(termVariable.getName());
        SimplePredicateFactory simplePredicateFactory = new SimplePredicateFactory(this.mManagedScript, function);
        this.mScript.push(1);
        HashMap hashMap = new HashMap();
        for (Map.Entry<PatternType<?>, Term> object2 : map.entrySet()) {
            termArray = object2.getValue();
            BasicPredicate basicPredicate = simplePredicateFactory.newPredicate((Term)termArray);
            Term term3 = SmtUtils.annotateAndAssert((Script)this.mScript, (Term)basicPredicate.getClosedFormula(), (String)object2.getKey().getId());
            hashMap.put(term3, object2.getKey());
        }
        Script.LBool lBool = this.mScript.checkSat();
        assert (lBool == Script.LBool.UNSAT);
        HashSet hashSet = new HashSet();
        termArray = this.mScript.getUnsatCore();
        Arrays.stream(termArray).map(term -> (PatternType)hashMap.get(term)).forEach(hashSet::add);
        this.mScript.pop(1);
        throw new InvariantInfeasibleException(hashSet);
    }

    private Term getTermVarTerm(String string) {
        IProgramNonOldVar iProgramNonOldVar = this.mVars.get(string);
        return iProgramNonOldVar.getTerm();
    }

    private Term computeExistentialProjection(Term term) {
        Term term2;
        Term term3 = this.inlineConsts(term);
        Term term4 = this.simplifyAndLog(term3);
        Set<TermVariable> set = this.getPrimedAndEventVars(term4.getFreeVars());
        if (set.isEmpty()) {
            return term;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Removing " + set.size() + " variables"));
        }
        QuantifiedFormula quantifiedFormula = (QuantifiedFormula)SmtUtils.quantifier((Script)this.mScript, (int)0, set, (Term)term4);
        ++this.mQelimQuery;
        try {
            term2 = this.tryToEliminate(quantifiedFormula);
        }
        catch (SMTLIBException sMTLIBException) {
            this.mLogger.fatal((Object)("Exception occured during PQE of " + String.valueOf(term)));
            throw sMTLIBException;
        }
        if (term2 instanceof QuantifiedFormula) {
            this.printQuantifiedFormula("Before qelim", () -> quantifiedFormula);
            this.printQuantifiedFormula("After qelim", () -> (QuantifiedFormula)term2);
            if (this.querySolverIsTrue(term2)) {
                return this.mTrue;
            }
            this.printQuantifiedFormula("After solver", () -> (QuantifiedFormula)term2);
        }
        return term2;
    }

    private Term inlineConsts(Term term) {
        return PureSubstitution.apply((ManagedScript)this.mManagedScript, this.mConstInlineMap, (Term)term);
    }

    private boolean querySolverIsTrue(Term term) {
        Script.LBool lBool;
        Term term2 = this.mScript.term("distinct", new Term[]{this.mTrue, term});
        if (term instanceof QuantifiedFormula) {
            ++this.mQuantifiedQuery;
        }
        return (lBool = SmtUtils.checkSatTerm((Script)this.mScript, (Term)term2)) == Script.LBool.UNSAT;
    }

    private Set<TermVariable> getPrimedAndEventVars(TermVariable[] termVariableArray) {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        Set<String> set = this.mReqSymboltable.getPrimedVars();
        Set<String> set2 = this.mReqSymboltable.getEventVars();
        Set<String> set3 = this.mReqSymboltable.getStateVars();
        TermVariable[] termVariableArray2 = termVariableArray;
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray2[n2];
            Expression expression = this.mBoogie2Smt.getTerm2Expression().translate((Term)termVariable);
            if (!(expression instanceof IdentifierExpression)) {
                throw new AssertionError();
            }
            String string = ((IdentifierExpression)expression).getIdentifier();
            if (set.contains(string) || set2.contains(string) || set3.contains(string)) {
                hashSet.add(termVariable);
            }
            ++n2;
        }
        return hashSet;
    }

    private static List<int[]> createPhaseVector(PhaseEventAutomata[] phaseEventAutomataArray) {
        int[][] nArrayArray = new int[phaseEventAutomataArray.length][];
        int n = 0;
        while (n < phaseEventAutomataArray.length) {
            PhaseEventAutomata phaseEventAutomata = phaseEventAutomataArray[n];
            int n2 = phaseEventAutomata.getPhases().size();
            nArrayArray[n] = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                nArrayArray[n][n3] = n3;
                ++n3;
            }
            ++n;
        }
        return CrossProducts.crossProduct((int[][])nArrayArray);
    }

    private Term getPcPhaseEquality(String string, int n) {
        return SmtUtils.binaryEquality((Script)this.mScript, (Term)this.getTermVarTerm(string), (Term)this.mScript.numeral(Integer.toString(n)));
    }

    private Term tryToEliminate(QuantifiedFormula quantifiedFormula) {
        Term term = QuantifierPushTermWalker.eliminate((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (boolean)false, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.LIGHT, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)quantifiedFormula);
        if (new SubtermPropertyChecker(QuantifiedFormula.class::isInstance).isSatisfiedBySomeSubterm(term)) {
            return QuantifierPushTermWalker.eliminate((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)term);
        }
        return term;
    }

    public static final class InvariantInfeasibleException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final Collection<PatternType<?>> mResponsibleRequirements;

        private InvariantInfeasibleException(Collection<PatternType<?>> collection) {
            super("Some invariants are already infeasible. Responsible requirements: " + collection.stream().map(PatternType::getId).collect(Collectors.joining(", ")));
            this.mResponsibleRequirements = collection;
        }

        public Collection<PatternType<?>> getResponsibleRequirements() {
            return this.mResponsibleRequirements;
        }
    }
}

