/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;

public class SegmentMatcher {
    private final char[] prefixForBinarySearch;
    private final char[] prefixForMatching;
    private final Pattern regexp;
    private final int minNameLength;
    private final boolean singleSegment;

    public SegmentMatcher(char[] pattern) {
        if (pattern == null || pattern.length == 0) {
            this.prefixForMatching = CharArrayUtils.EMPTY;
            this.prefixForBinarySearch = CharArrayUtils.EMPTY;
            this.regexp = null;
            this.minNameLength = 0;
            this.singleSegment = true;
        } else {
            StringBuilder regexpBuffer = new StringBuilder("^");
            int i = 0;
            int lengthOfFirstSegment = 0;
            int segmentCount = 0;
            while (i < pattern.length) {
                char currentChar;
                boolean separatorSpecified = false;
                while (i < pattern.length) {
                    currentChar = pattern[i];
                    if (Character.isLetterOrDigit(currentChar)) break;
                    regexpBuffer.append(Pattern.quote(String.valueOf(currentChar)));
                    separatorSpecified = true;
                    ++i;
                }
                if (i < pattern.length) {
                    currentChar = pattern[i];
                    if (Character.isDigit(currentChar)) {
                        regexpBuffer.append(currentChar);
                        ++i;
                        while (i < pattern.length) {
                            currentChar = pattern[i];
                            if (Character.isDigit(currentChar)) {
                                regexpBuffer.append(currentChar);
                                ++i;
                                continue;
                            }
                            break;
                        }
                    } else {
                        char lower = Character.toLowerCase(currentChar);
                        char upper = Character.toUpperCase(currentChar);
                        if (segmentCount == 0 || separatorSpecified) {
                            regexpBuffer.append(currentChar);
                        } else {
                            regexpBuffer.append("(_[");
                            regexpBuffer.append(lower);
                            regexpBuffer.append(upper);
                            regexpBuffer.append("]|");
                            regexpBuffer.append(upper);
                            regexpBuffer.append(')');
                        }
                        ++i;
                        while (i < pattern.length) {
                            currentChar = pattern[i];
                            if (Character.isLetter(currentChar) && !Character.isUpperCase(currentChar)) {
                                lower = currentChar;
                                upper = Character.toUpperCase(currentChar);
                                regexpBuffer.append('[');
                                regexpBuffer.append(lower);
                                regexpBuffer.append(upper);
                                regexpBuffer.append(']');
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                }
                regexpBuffer.append(".*");
                if (segmentCount == 0) {
                    lengthOfFirstSegment = i;
                }
                ++segmentCount;
            }
            this.regexp = Pattern.compile(regexpBuffer.toString());
            this.singleSegment = segmentCount == 1;
            this.prefixForMatching = pattern;
            this.prefixForBinarySearch = CharArrayUtils.extract(pattern, 0, lengthOfFirstSegment);
            this.minNameLength = pattern.length;
        }
    }

    public boolean match(char[] name) {
        if (this.matchPrefix(name)) {
            return true;
        }
        if (this.singleSegment) {
            return false;
        }
        return this.matchSegments(name);
    }

    public boolean matchPrefix(char[] name) {
        return CharArrayUtils.equals(name, 0, this.prefixForMatching.length, this.prefixForMatching, true);
    }

    public boolean matchSegments(char[] name) {
        if (name == null) {
            return false;
        }
        if (name.length < this.minNameLength) {
            return false;
        }
        if (this.regexp == null) {
            return true;
        }
        Matcher matcher = this.regexp.matcher(String.valueOf(name));
        return matcher.find();
    }

    public static boolean match(char[] pattern, char[] name) {
        return new SegmentMatcher(pattern).match(name);
    }

    public char[] getPrefixForBinarySearch() {
        return this.prefixForBinarySearch;
    }

    public boolean matchRequiredAfterBinarySearch() {
        return !this.singleSegment;
    }
}

