/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.graphml.AbstractMetadata;
import edu.uci.ics.jung.io.graphml.DataMetadata;
import edu.uci.ics.jung.io.graphml.EdgeMetadata;
import edu.uci.ics.jung.io.graphml.EndpointMetadata;
import edu.uci.ics.jung.io.graphml.ExceptionConverter;
import edu.uci.ics.jung.io.graphml.GraphMetadata;
import edu.uci.ics.jung.io.graphml.HyperEdgeMetadata;
import edu.uci.ics.jung.io.graphml.NodeMetadata;
import edu.uci.ics.jung.io.graphml.parser.AbstractElementParser;
import edu.uci.ics.jung.io.graphml.parser.ParserContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphElementParser<G extends Hypergraph<V, E>, V, E>
extends AbstractElementParser<G, V, E> {
    public GraphElementParser(ParserContext<G, V, E> parserContext) {
        super(parserContext);
    }

    @Override
    public GraphMetadata parse(XMLEventReader xmlEventReader, StartElement start) throws GraphIOException {
        try {
            GraphMetadata graphMetadata = new GraphMetadata();
            Iterator iterator = start.getAttributes();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                String name = attribute.getName().getLocalPart();
                String value = attribute.getValue();
                if (graphMetadata.getId() == null && "id".equals(name)) {
                    graphMetadata.setId(value);
                    continue;
                }
                if (graphMetadata.getEdgeDefault() == null && "edgedefault".equals(name)) {
                    graphMetadata.setEdgeDefault("directed".equals(value) ? GraphMetadata.EdgeDefault.DIRECTED : GraphMetadata.EdgeDefault.UNDIRECTED);
                    continue;
                }
                graphMetadata.setProperty(name, value);
            }
            if (graphMetadata.getEdgeDefault() == null) {
                throw new GraphIOException("Element 'graph' is missing attribute 'edgedefault'");
            }
            HashMap idToVertexMap = new HashMap();
            LinkedList<EdgeMetadata> edgeMetadata = new LinkedList<EdgeMetadata>();
            LinkedList<HyperEdgeMetadata> hyperEdgeMetadata = new LinkedList<HyperEdgeMetadata>();
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    Object edge;
                    AbstractMetadata metadata;
                    StartElement element = (StartElement)event;
                    String name = element.getName().getLocalPart();
                    if ("desc".equals(name)) {
                        String desc = (String)this.getParser(name).parse(xmlEventReader, element);
                        graphMetadata.setDescription(desc);
                    } else if ("data".equals(name)) {
                        DataMetadata data = (DataMetadata)this.getParser(name).parse(xmlEventReader, element);
                        graphMetadata.addData(data);
                    } else if ("node".equals(name)) {
                        metadata = (NodeMetadata)this.getParser(name).parse(xmlEventReader, element);
                        Object vertex = this.getParserContext().createVertex((NodeMetadata)metadata);
                        ((NodeMetadata)metadata).setVertex(vertex);
                        idToVertexMap.put(((NodeMetadata)metadata).getId(), vertex);
                        graphMetadata.addNodeMetadata(vertex, (NodeMetadata)metadata);
                    } else if ("edge".equals(name)) {
                        metadata = (EdgeMetadata)this.getParser(name).parse(xmlEventReader, element);
                        if (((EdgeMetadata)metadata).isDirected() == null) {
                            ((EdgeMetadata)metadata).setDirected(graphMetadata.getEdgeDefault() == GraphMetadata.EdgeDefault.DIRECTED);
                        }
                        edge = this.getParserContext().createEdge((EdgeMetadata)metadata);
                        edgeMetadata.add((EdgeMetadata)metadata);
                        ((EdgeMetadata)metadata).setEdge(edge);
                        graphMetadata.addEdgeMetadata(edge, (EdgeMetadata)metadata);
                    } else if ("hyperedge".equals(name)) {
                        metadata = (HyperEdgeMetadata)this.getParser(name).parse(xmlEventReader, element);
                        edge = this.getParserContext().createHyperEdge((HyperEdgeMetadata)metadata);
                        hyperEdgeMetadata.add((HyperEdgeMetadata)metadata);
                        ((HyperEdgeMetadata)metadata).setEdge(edge);
                        graphMetadata.addHyperEdgeMetadata(edge, (HyperEdgeMetadata)metadata);
                    } else {
                        this.getUnknownParser().parse(xmlEventReader, element);
                    }
                }
                if (!event.isEndElement()) continue;
                EndElement end = (EndElement)event;
                this.verifyMatch(start, end);
                break;
            }
            this.applyKeys(graphMetadata);
            Object graph = this.getParserContext().createGraph(graphMetadata);
            graphMetadata.setGraph(graph);
            this.addVerticesToGraph(graph, idToVertexMap.values());
            this.addEdgesToGraph(graph, edgeMetadata, idToVertexMap);
            this.addHyperEdgesToGraph(graph, hyperEdgeMetadata, idToVertexMap);
            return graphMetadata;
        }
        catch (Exception e) {
            ExceptionConverter.convert(e);
            return null;
        }
    }

    private void addVerticesToGraph(G graph, Collection<V> vertices) {
        for (V vertex : vertices) {
            graph.addVertex(vertex);
        }
    }

    private void addEdgesToGraph(G graph, Collection<EdgeMetadata> metadata, Map<String, V> idToVertexMap) throws GraphIOException {
        for (EdgeMetadata emd : metadata) {
            Object edge = emd.getEdge();
            V source = idToVertexMap.get(emd.getSource());
            V target = idToVertexMap.get(emd.getTarget());
            if (source == null || target == null) {
                throw new GraphIOException("edge references undefined source or target vertex. Source: " + emd.getSource() + ", Target: " + emd.getTarget());
            }
            if (graph instanceof Graph) {
                ((Graph)graph).addEdge(edge, source, target, emd.isDirected() != false ? EdgeType.DIRECTED : EdgeType.UNDIRECTED);
                continue;
            }
            graph.addEdge((Object)edge, new Pair<V>(source, target));
        }
    }

    private void addHyperEdgesToGraph(G graph, Collection<HyperEdgeMetadata> metadata, Map<String, V> idToVertexMap) throws GraphIOException {
        for (HyperEdgeMetadata emd : metadata) {
            Object edge = emd.getEdge();
            ArrayList<V> verticies = new ArrayList<V>();
            List<EndpointMetadata> endpoints = emd.getEndpoints();
            for (EndpointMetadata ep : endpoints) {
                V v = idToVertexMap.get(ep.getNode());
                if (v == null) {
                    throw new GraphIOException("hyperedge references undefined vertex: " + ep.getNode());
                }
                verticies.add(v);
            }
            graph.addEdge((Object)edge, verticies);
        }
    }
}

