/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.blockencoding;

import de.uni_freiburg.informatik.ultimate.core.model.IGenerator;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.BlockEncodingObserver;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.preferences.BlockEncodingPreferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BlockEncoding
implements IGenerator {
    private static final SmtUtils.SimplificationTechnique SIMPLIFICATION_TECHNIQUE = SmtUtils.SimplificationTechnique.SIMPLIFY_DDA;
    private ILogger mLogger;
    private BlockEncodingObserver mObserver;
    private IUltimateServiceProvider mServices;
    private BlockEncodingBacktranslator mBacktranslator;
    private ModelType mOldGraphType;

    public ModelType getOutputDefinition() {
        return new ModelType(Activator.PLUGIN_ID, ModelType.Type.CFG, (Collection)this.mOldGraphType.getFileNames());
    }

    public boolean isGuiRequired() {
        return false;
    }

    public ITool.ModelQuery getModelQuery() {
        return ITool.ModelQuery.LAST;
    }

    public void setInputDefinition(ModelType modelType) {
        this.mOldGraphType = modelType;
    }

    public List<IObserver> getObservers() {
        ArrayList<IObserver> arrayList = new ArrayList<IObserver>();
        this.mObserver = new BlockEncodingObserver(this.mLogger, this.mServices, this.mBacktranslator, SIMPLIFICATION_TECHNIQUE);
        arrayList.add((IObserver)this.mObserver);
        return arrayList;
    }

    public void init() {
    }

    public String getPluginName() {
        return "BlockEncodingV2";
    }

    public String getPluginID() {
        return Activator.PLUGIN_ID;
    }

    public IElement getModel() {
        return this.mObserver.getModel();
    }

    public List<String> getDesiredToolIds() {
        return Collections.emptyList();
    }

    public IPreferenceInitializer getPreferences() {
        return new BlockEncodingPreferences();
    }

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mBacktranslator = new BlockEncodingBacktranslator(IcfgEdge.class, Term.class, this.mLogger);
        this.mServices.getBacktranslationService().addTranslator((ITranslator)this.mBacktranslator);
    }

    public void finish() {
    }
}

