/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.HeapLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValueFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.preferences.CACSLPreferenceInitializer;
import java.math.BigInteger;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class ArrayHandler {
    private final ExpressionTranslation mExpressionTranslation;
    private final ITypeHandler mTypeHandler;
    private final TypeSizes mTypeSizes;
    private final TranslationSettings mSettings;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final MemoryHandler mMemoryHandler;
    private final LocationFactory mLocationFactory;

    public ArrayHandler(TranslationSettings translationSettings, ExpressionTranslation expressionTranslation, ITypeHandler iTypeHandler, TypeSizes typeSizes, ExpressionResultTransformer expressionResultTransformer, MemoryHandler memoryHandler, LocationFactory locationFactory) {
        this.mSettings = translationSettings;
        this.mExpressionTranslation = expressionTranslation;
        this.mTypeHandler = iTypeHandler;
        this.mTypeSizes = typeSizes;
        this.mExprResultTransformer = expressionResultTransformer;
        this.mMemoryHandler = memoryHandler;
        this.mLocationFactory = locationFactory;
    }

    public ExpressionResult handleArraySubscriptExpression(ExpressionResult expressionResult, ExpressionResult expressionResult2, IASTNode iASTNode) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createCLocation(iASTNode);
        assert (expressionResult2.getLrValue().getCType().isIntegerType());
        LRValue lRValue = expressionResult.getLrValue();
        ICType iCType = lRValue.getCType().getUnderlyingType();
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        if (iCType instanceof CPointer) {
            ExpressionResult expressionResult3 = this.mExprResultTransformer.switchToRValue(expressionResult, cACSLLocation, iASTNode);
            LRValue lRValue2 = expressionResult3.getLrValue();
            assert (iCType.equals(lRValue2.getCType()));
            RValue rValue = (RValue)expressionResult2.getLrValue();
            ICType iCType2 = ((CPointer)iCType).getPointsToType();
            ExpressionResult expressionResult4 = this.mMemoryHandler.doPointerArithmeticWithConversion(4, cACSLLocation, lRValue2.getValue(), rValue, iCType2);
            expressionResultBuilder.addAllExceptLrValue(expressionResult3, expressionResult2, expressionResult4);
            HeapLValue heapLValue = LRValueFactory.constructHeapLValue(this.mTypeHandler, expressionResult4.getLrValue().getValue(), iCType2, false, null);
            expressionResultBuilder.setLrValue(heapLValue);
            return expressionResultBuilder.build();
        }
        assert (iCType instanceof CArray) : "cType not instanceof CArray";
        CArray cArray = (CArray)iCType.getUnderlyingType();
        ICType iCType3 = cArray.getValueType();
        if (lRValue instanceof HeapLValue) {
            Expression expression = ((HeapLValue)lRValue).getAddress();
            ExpressionResult expressionResult5 = this.mMemoryHandler.doPointerArithmeticWithConversion(4, cACSLLocation, expression, (RValue)expressionResult2.getLrValue(), iCType3);
            HeapLValue heapLValue = LRValueFactory.constructHeapLValue(this.mTypeHandler, expressionResult5.getLrValue().getValue(), iCType3, false, null);
            expressionResultBuilder.addAllExceptLrValue(expressionResult, expressionResult2, expressionResult5);
            expressionResultBuilder.setLrValue(heapLValue);
            return expressionResultBuilder.build();
        }
        if (lRValue instanceof LocalLValue) {
            ArrayLHS arrayLHS;
            Object object;
            LeftHandSide leftHandSide = ((LocalLValue)lRValue).getLhs();
            Expression expression = cArray.getBound();
            CPrimitive cPrimitive = cArray.getBoundType();
            ExpressionResult expressionResult6 = this.mExpressionTranslation.convertIntToInt(cACSLLocation, expressionResult2, cPrimitive);
            RValue rValue = (RValue)expressionResult6.getLrValue();
            if (leftHandSide instanceof ArrayLHS) {
                object = ((ArrayLHS)leftHandSide).getIndices();
                Expression[] expressionArray = new Expression[((Expression[])object).length + 1];
                System.arraycopy(object, 0, expressionArray, 0, ((Expression[])object).length);
                expressionArray[expressionArray.length - 1] = rValue.getValue();
                arrayLHS = ExpressionFactory.constructNestedArrayLHS((ILocation)cACSLLocation, (LeftHandSide)((ArrayLHS)leftHandSide).getArray(), (Expression[])expressionArray);
            } else {
                arrayLHS = ExpressionFactory.constructNestedArrayLHS((ILocation)cACSLLocation, (LeftHandSide)leftHandSide, (Expression[])new Expression[]{rValue.getValue()});
            }
            object = new LocalLValue((LeftHandSide)arrayLHS, iCType3, false, false, null);
            expressionResultBuilder.addAllExceptLrValue(expressionResult, expressionResult6);
            expressionResultBuilder.setLrValue((LRValue)object);
            this.addArrayBoundsCheckForCurrentIndex(cACSLLocation, rValue, expression, cPrimitive, expressionResultBuilder);
            return expressionResultBuilder.build();
        }
        if (lRValue instanceof RValue) {
            ExpressionResult expressionResult7 = this.mMemoryHandler.doPointerArithmeticWithConversion(4, cACSLLocation, lRValue.getValue(), (RValue)expressionResult2.getLrValue(), iCType3);
            expressionResultBuilder.addAllExceptLrValue(expressionResult, expressionResult2, expressionResult7);
            HeapLValue heapLValue = LRValueFactory.constructHeapLValue(this.mTypeHandler, expressionResult7.getLrValue().getValue(), iCType3, false, null);
            expressionResultBuilder.setLrValue(heapLValue);
            return expressionResultBuilder.build();
        }
        throw new UnsupportedSyntaxException(cACSLLocation, lRValue.getClass().getSimpleName() + " cannot be handled as array subscript.");
    }

    private void addArrayBoundsCheckForCurrentIndex(ILocation iLocation, RValue rValue, Expression expression, CPrimitive cPrimitive, ExpressionResultBuilder expressionResultBuilder) {
        if (this.mSettings.checkPointerDerefValidity() == CACSLPreferenceInitializer.CheckMode.IGNORE) {
            return;
        }
        CPrimitive cPrimitive2 = (CPrimitive)rValue.getCType().getUnderlyingType();
        Expression expression2 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive2, BigInteger.ZERO);
        Expression expression3 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 10, expression2, cPrimitive2, rValue.getValue(), cPrimitive2);
        Expression expression4 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 8, rValue.getValue(), cPrimitive2, expression, cPrimitive);
        Expression expression5 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression3, (Expression)expression4);
        switch (this.mSettings.checkPointerDerefValidity()) {
            case CHECK: {
                AssertStatement assertStatement = new AssertStatement(iLocation, expression5);
                Check check = new Check(Spec.ARRAY_INDEX);
                check.annotate((IElement)assertStatement);
                expressionResultBuilder.addStatement((Statement)assertStatement);
                break;
            }
            case ASSUME: {
                AssumeStatement assumeStatement = new AssumeStatement(iLocation, expression5);
                expressionResultBuilder.addStatement((Statement)assumeStatement);
                break;
            }
            case IGNORE: {
                throw new AssertionError((Object)"case handled before");
            }
            default: {
                throw new AssertionError((Object)"unknown value");
            }
        }
    }

    private static boolean isInnermostSubscriptExpression(IASTArraySubscriptExpression iASTArraySubscriptExpression) {
        return !(iASTArraySubscriptExpression.getArrayExpression() instanceof IASTArraySubscriptExpression);
    }
}

