/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MemorySliceUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import java.util.Map;

public class IdentifierReplacer
extends BoogieTransformer {
    private final Map<String, String> mOldIdToNewId;
    private final String mOldProcId;
    private final String mSuffix;

    public IdentifierReplacer(Map<String, String> map, String string, String string2) {
        this.mOldIdToNewId = map;
        this.mOldProcId = string;
        this.mSuffix = string2;
    }

    protected Body processBody(Body body) {
        return super.processBody(body);
    }

    protected Specification[] processSpecifications(Specification[] specificationArray) {
        return super.processSpecifications(specificationArray);
    }

    protected Specification processSpecification(Specification specification) {
        return super.processSpecification(specification);
    }

    protected LeftHandSide processLeftHandSide(LeftHandSide leftHandSide) {
        VariableLHS variableLHS = MemorySliceUtils.replaceLeftHandSide(leftHandSide, this.mOldIdToNewId, this.mOldProcId, this.mSuffix);
        if (variableLHS != null) {
            return variableLHS;
        }
        return super.processLeftHandSide(leftHandSide);
    }

    protected Expression processExpression(Expression expression) {
        IdentifierExpression identifierExpression = MemorySliceUtils.replaceIdentifierExpression(expression, this.mOldIdToNewId, this.mOldProcId, this.mSuffix);
        if (identifierExpression != null) {
            return identifierExpression;
        }
        return super.processExpression(expression);
    }

    protected Statement processStatement(Statement statement) {
        if (statement instanceof CallStatement) {
            CallStatement callStatement = (CallStatement)statement;
            if (callStatement.getMethodName().startsWith("read~int") || callStatement.getMethodName().startsWith("read~unchecked~int") || callStatement.getMethodName().startsWith("read~real") || callStatement.getMethodName().startsWith("read~unchecked~real") || callStatement.getMethodName().startsWith("read~$Pointer$") || callStatement.getMethodName().startsWith("read~unchecked~$Pointer$")) {
                assert (callStatement.getArguments().length == 2);
                VariableLHS[] variableLHSArray = this.processVariableLHSs(callStatement.getLhs());
                Expression[] expressionArray = this.processExpressions(callStatement.getArguments());
                CallStatement callStatement2 = new CallStatement(callStatement.getLoc(), callStatement.getAttributes(), callStatement.isForall(), variableLHSArray, callStatement.getMethodName() + this.mSuffix, expressionArray);
                ModelUtils.copyAnnotations((IElement)statement, (IElement)callStatement2);
                return callStatement2;
            }
            if (callStatement.getMethodName().startsWith("write~init~int") || callStatement.getMethodName().startsWith("write~int") || callStatement.getMethodName().startsWith("write~unchecked~int") || callStatement.getMethodName().startsWith("write~init~real") || callStatement.getMethodName().startsWith("write~real") || callStatement.getMethodName().startsWith("write~unchecked~real") || callStatement.getMethodName().startsWith("write~init~$Pointer$") || callStatement.getMethodName().startsWith("write~$Pointer$") || callStatement.getMethodName().startsWith("write~unchecked~$Pointer$")) {
                assert (callStatement.getArguments().length == 3);
                VariableLHS[] variableLHSArray = this.processVariableLHSs(callStatement.getLhs());
                Expression[] expressionArray = this.processExpressions(callStatement.getArguments());
                CallStatement callStatement3 = new CallStatement(callStatement.getLoc(), callStatement.getAttributes(), callStatement.isForall(), variableLHSArray, callStatement.getMethodName() + this.mSuffix, expressionArray);
                ModelUtils.copyAnnotations((IElement)statement, (IElement)callStatement3);
                return callStatement3;
            }
        }
        return super.processStatement(statement);
    }
}

