/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public class IncrementalPlicationChecker {
    private final ManagedScript mMgdScript;
    private final Term mLhs;
    private boolean mLhsIsAsserted;
    private Map<TermVariable, Term> mVar2ConstSubstitution;
    private final Plication mPlication;

    public static Validity convertLBool2Validity(Script.LBool lBool) {
        return switch (lBool) {
            case Script.LBool.SAT -> Validity.INVALID;
            case Script.LBool.UNKNOWN -> Validity.UNKNOWN;
            case Script.LBool.UNSAT -> Validity.VALID;
            default -> throw new MatchException(null, null);
        };
    }

    public static Script.LBool convertValidity2Lbool(Validity validity) {
        return switch (validity) {
            case Validity.INVALID -> Script.LBool.SAT;
            case Validity.NOT_CHECKED -> throw new AssertionError();
            case Validity.UNKNOWN -> Script.LBool.UNKNOWN;
            case Validity.VALID -> Script.LBool.UNSAT;
            default -> throw new MatchException(null, null);
        };
    }

    public IncrementalPlicationChecker(Plication plication, ManagedScript managedScript, Term term) {
        this.mPlication = plication;
        this.mMgdScript = managedScript;
        this.mLhs = term;
        this.mLhsIsAsserted = false;
    }

    private void assertLhs(Term term) {
        assert (!this.mLhsIsAsserted) : "must not assert lhs twice";
        this.mMgdScript.lock(this);
        this.mMgdScript.push(this, 1);
        this.mVar2ConstSubstitution = this.constructVar2ConstSubstitution(term);
        Term term2 = switch (this.mPlication) {
            case Plication.EXPLICATION -> SmtUtils.not(this.mMgdScript.getScript(), term);
            case Plication.IMPLICATION -> term;
            default -> throw new MatchException(null, null);
        };
        this.mMgdScript.assertTerm(this, Substitution.apply(this.mMgdScript, this.mVar2ConstSubstitution, term2));
        this.mLhsIsAsserted = true;
    }

    private Map<TermVariable, Term> constructVar2ConstSubstitution(Term term) {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(term.getFreeVars()));
        Map<TermVariable, Term> map = SmtUtils.termVariables2Constants(this.mMgdScript.getScript(), hashSet, true);
        return map;
    }

    public Validity checkPlication(Term term) {
        if (!this.mLhsIsAsserted) {
            this.assertLhs(this.mLhs);
        }
        this.mMgdScript.push(this, 1);
        Term term2 = switch (this.mPlication) {
            case Plication.EXPLICATION -> term;
            case Plication.IMPLICATION -> SmtUtils.not(this.mMgdScript.getScript(), term);
            default -> throw new MatchException(null, null);
        };
        this.mMgdScript.assertTerm(this, Substitution.apply(this.mMgdScript, this.mVar2ConstSubstitution, term2));
        Script.LBool lBool = this.mMgdScript.checkSat(this);
        this.mMgdScript.pop(this, 1);
        return IncrementalPlicationChecker.convertLBool2Validity(lBool);
    }

    public Script.LBool checkSat(Term term) {
        if (!this.mLhsIsAsserted) {
            this.assertLhs(this.mLhs);
        }
        this.mMgdScript.push(this, 1);
        Term term2 = switch (this.mPlication) {
            case Plication.EXPLICATION -> term;
            case Plication.IMPLICATION -> term;
            default -> throw new MatchException(null, null);
        };
        this.mMgdScript.assertTerm(this, Substitution.apply(this.mMgdScript, this.mVar2ConstSubstitution, term2));
        Script.LBool lBool = this.mMgdScript.checkSat(this);
        this.mMgdScript.pop(this, 1);
        return lBool;
    }

    public void unlockSolver() {
        if (this.mLhsIsAsserted) {
            this.mMgdScript.pop(this, 1);
            this.mMgdScript.unlock(this);
        }
    }

    public static enum Plication {
        IMPLICATION,
        EXPLICATION;

    }

    public static enum Validity {
        VALID,
        INVALID,
        UNKNOWN,
        NOT_CHECKED;


        public Validity and(Validity validity) {
            return switch (this) {
                case INVALID -> INVALID;
                case NOT_CHECKED -> {
                    if (validity == INVALID) {
                        yield validity;
                    }
                    yield this;
                }
                case UNKNOWN -> {
                    if (validity == NOT_CHECKED || validity == INVALID) {
                        yield validity;
                    }
                    yield this;
                }
                case VALID -> validity;
                default -> throw new MatchException(null, null);
            };
        }
    }
}

