/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.Payload;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.ModelCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ConcurrencyInformation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgPetrifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ThreadInstance;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IForkActionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IJoinActionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgForkThreadOtherTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgJoinThreadOtherTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.ProcedureErrorDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.ProcedureErrorWithCheckDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ThreadInstanceAdder {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final boolean mAddSelfLoops;

    public ThreadInstanceAdder(IUltimateServiceProvider iUltimateServiceProvider, boolean bl) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(ModelCheckerUtils.PLUGIN_ID);
        this.mAddSelfLoops = bl;
    }

    public IIcfg<IcfgLocation> connectThreadInstances(IIcfg<IcfgLocation> iIcfg, List<IIcfgForkTransitionThreadCurrent<IcfgLocation>> list, List<IIcfgJoinTransitionThreadCurrent<IcfgLocation>> list2, Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> map, Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, IcfgLocation> map2, BlockEncodingBacktranslator blockEncodingBacktranslator) {
        for (IIcfgForkTransitionThreadCurrent<IcfgLocation> iIcfgForkTransitionThreadCurrent : list) {
            Iterator<IIcfgJoinTransitionThreadCurrent<IcfgLocation>> iterator = iIcfgForkTransitionThreadCurrent.getSource();
            IcfgLocation icfgLocation = map2.get(iIcfgForkTransitionThreadCurrent);
            IcfgEdgeFactory icfgEdgeFactory = iIcfg.getCfgSmtToolkit().getIcfgEdgeFactory();
            UnmodifiableTransFormula unmodifiableTransFormula = TransFormulaBuilder.getTrivialTransFormula(iIcfg.getCfgSmtToolkit().getManagedScript());
            IcfgInternalTransition icfgInternalTransition = icfgEdgeFactory.createInternalTransition((IcfgLocation)((Object)iterator), icfgLocation, (IPayload)new Payload(), unmodifiableTransFormula);
            if (this.mAddSelfLoops) {
                IcfgInternalTransition icfgInternalTransition2 = icfgEdgeFactory.createInternalTransition(icfgLocation, icfgLocation, (IPayload)new Payload(), unmodifiableTransFormula);
                icfgLocation.addIncoming((IModifiableMultigraphEdge)icfgInternalTransition2);
                icfgLocation.addOutgoing((IModifiableMultigraphEdge)icfgInternalTransition2);
            }
            ThreadInstanceAdder.integrateForkEdge(iIcfgForkTransitionThreadCurrent, blockEncodingBacktranslator, iterator, icfgLocation, icfgInternalTransition);
            for (ThreadInstance threadInstance : map.get(iIcfgForkTransitionThreadCurrent)) {
                this.addForkOtherThreadTransition(iIcfgForkTransitionThreadCurrent, threadInstance.getIdVars(), iIcfg, threadInstance.getThreadInstanceName(), blockEncodingBacktranslator);
            }
        }
        int n = 0;
        for (IIcfgJoinTransitionThreadCurrent<IcfgLocation> iIcfgJoinTransitionThreadCurrent : list2) {
            for (ThreadInstance threadInstance : IcfgPetrifier.getAllInstances(map)) {
                boolean bl = ThreadInstanceAdder.isThreadIdCompatible(threadInstance.getIdVars(), iIcfgJoinTransitionThreadCurrent.getJoinSmtArguments().getThreadIdArguments().terms());
                boolean bl2 = ThreadInstanceAdder.isReturnValueCompatible(iIcfgJoinTransitionThreadCurrent.getJoinSmtArguments().getAssignmentLhs(), iIcfg.getCfgSmtToolkit().getOutParams().get(threadInstance.getThreadInstanceName()));
                if (!bl || !bl2) continue;
                this.addJoinOtherThreadTransition(iIcfgJoinTransitionThreadCurrent, threadInstance.getThreadInstanceName(), threadInstance.getIdVars(), iIcfg, blockEncodingBacktranslator);
                ++n;
            }
        }
        this.mLogger.info((Object)("Constructed " + n + " joinOtherThreadTransitions."));
        return iIcfg;
    }

    private static boolean isReturnValueCompatible(List<IProgramVar> list, List<ILocalProgramVar> list2) {
        if (list.isEmpty()) {
            return true;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            if (!list.get(n).getTerm().getSort().equals(list2.get(n).getTerm().getSort())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean isThreadIdCompatible(IProgramNonOldVar[] iProgramNonOldVarArray, Term[] termArray) {
        if (iProgramNonOldVarArray.length != termArray.length) {
            return false;
        }
        int n = 0;
        while (n < iProgramNonOldVarArray.length) {
            if (!iProgramNonOldVarArray[n].getTerm().getSort().equals(termArray[n].getSort())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void addForkOtherThreadTransition(IIcfgForkTransitionThreadCurrent<IcfgLocation> iIcfgForkTransitionThreadCurrent, IProgramNonOldVar[] iProgramNonOldVarArray, IIcfg<? extends IcfgLocation> iIcfg, String string, BlockEncodingBacktranslator blockEncodingBacktranslator) {
        assert (iIcfg.getProcedureEntryNodes().containsKey(string)) : "Thread instance " + string + " missing.";
        Object LOC = iIcfgForkTransitionThreadCurrent.getSource();
        IcfgLocation icfgLocation = iIcfg.getProcedureEntryNodes().get(string);
        CfgSmtToolkit cfgSmtToolkit = iIcfg.getCfgSmtToolkit();
        UnmodifiableTransFormula unmodifiableTransFormula = this.constructForkTransFormula(iIcfgForkTransitionThreadCurrent.getForkSmtArguments(), Arrays.asList(iProgramNonOldVarArray), string, cfgSmtToolkit);
        IcfgForkThreadOtherTransition icfgForkThreadOtherTransition = cfgSmtToolkit.getIcfgEdgeFactory().createForkThreadOtherTransition((IcfgLocation)LOC, icfgLocation, null, unmodifiableTransFormula, iIcfgForkTransitionThreadCurrent);
        ThreadInstanceAdder.integrateForkEdge(iIcfgForkTransitionThreadCurrent, blockEncodingBacktranslator, LOC, icfgLocation, icfgForkThreadOtherTransition);
        HashMap hashMap = new HashMap();
        if (!hashMap.isEmpty()) {
            new Overapprox(hashMap).annotate(iIcfgForkTransitionThreadCurrent);
        }
    }

    private UnmodifiableTransFormula constructForkTransFormula(IForkActionThreadCurrent.ForkSmtArguments forkSmtArguments, List<IProgramVar> list, String string, CfgSmtToolkit cfgSmtToolkit) {
        ManagedScript managedScript = cfgSmtToolkit.getManagedScript();
        UnmodifiableTransFormula unmodifiableTransFormula = forkSmtArguments.constructInVarsAssignment(cfgSmtToolkit.getSymbolTable(), managedScript, cfgSmtToolkit.getInParams().get(string));
        UnmodifiableTransFormula unmodifiableTransFormula2 = forkSmtArguments.constructThreadIdAssignment(cfgSmtToolkit.getSymbolTable(), managedScript, list);
        Set<IProgramVar> set = cfgSmtToolkit.getSymbolTable().getLocals(string).stream().filter(iLocalProgramVar -> !cfgSmtToolkit.getInParams().get(string).contains(iLocalProgramVar)).collect(Collectors.toSet());
        UnmodifiableTransFormula unmodifiableTransFormula3 = TransFormulaUtils.constructHavoc(set, managedScript);
        List<UnmodifiableTransFormula> list2 = List.of(unmodifiableTransFormula, unmodifiableTransFormula2, unmodifiableTransFormula3);
        return this.constructSequentialComposition(managedScript, list2);
    }

    private UnmodifiableTransFormula constructSequentialComposition(ManagedScript managedScript, List<UnmodifiableTransFormula> list) {
        return TransFormulaUtils.sequentialComposition(this.mLogger, this.mServices, managedScript, false, false, false, SmtUtils.SimplificationTechnique.NONE, list);
    }

    private static void integrateForkEdge(IIcfgForkTransitionThreadCurrent<IcfgLocation> iIcfgForkTransitionThreadCurrent, BlockEncodingBacktranslator blockEncodingBacktranslator, IcfgLocation icfgLocation, IcfgLocation icfgLocation2, IcfgEdge icfgEdge) {
        icfgLocation.addOutgoing((IModifiableMultigraphEdge)icfgEdge);
        icfgLocation2.addIncoming((IModifiableMultigraphEdge)icfgEdge);
        IIcfgTransition<IcfgLocation> iIcfgTransition = ThreadInstanceAdder.getOriginalEdge(iIcfgForkTransitionThreadCurrent, blockEncodingBacktranslator);
        blockEncodingBacktranslator.mapEdges((IIcfgTransition<IcfgLocation>)icfgEdge, iIcfgTransition);
        blockEncodingBacktranslator.addAteTransformer(icfgEdge, atomicTraceElementBuilder -> {
            atomicTraceElementBuilder.addStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.FORK});
            if (atomicTraceElementBuilder.getForkedThreadId() == null) {
                atomicTraceElementBuilder.setForkedThreadId(-1);
            }
        });
    }

    private static IIcfgTransition<IcfgLocation> getOriginalEdge(IIcfgTransition<IcfgLocation> iIcfgTransition, BlockEncodingBacktranslator blockEncodingBacktranslator) {
        List list = blockEncodingBacktranslator.translateTrace(Collections.singletonList(iIcfgTransition));
        if (list.size() != 1) {
            throw new IllegalStateException();
        }
        return (IIcfgTransition)list.get(0);
    }

    private void addJoinOtherThreadTransition(IIcfgJoinTransitionThreadCurrent<IcfgLocation> iIcfgJoinTransitionThreadCurrent, String string, IProgramNonOldVar[] iProgramNonOldVarArray, IIcfg<? extends IcfgLocation> iIcfg, BlockEncodingBacktranslator blockEncodingBacktranslator) {
        IcfgLocation icfgLocation = iIcfg.getProcedureExitNodes().get(string);
        Object LOC = iIcfgJoinTransitionThreadCurrent.getTarget();
        CfgSmtToolkit cfgSmtToolkit = iIcfg.getCfgSmtToolkit();
        UnmodifiableTransFormula unmodifiableTransFormula = this.constructJoinTransformula(iIcfgJoinTransitionThreadCurrent.getJoinSmtArguments(), Arrays.asList(iProgramNonOldVarArray), string, cfgSmtToolkit);
        IcfgJoinThreadOtherTransition icfgJoinThreadOtherTransition = cfgSmtToolkit.getIcfgEdgeFactory().createJoinThreadOtherTransition(icfgLocation, (IcfgLocation)LOC, null, unmodifiableTransFormula, iIcfgJoinTransitionThreadCurrent);
        icfgLocation.addOutgoing((IModifiableMultigraphEdge)icfgJoinThreadOtherTransition);
        LOC.addIncoming((IModifiableMultigraphEdge)icfgJoinThreadOtherTransition);
        IIcfgTransition<IcfgLocation> iIcfgTransition = ThreadInstanceAdder.getOriginalEdge(iIcfgJoinTransitionThreadCurrent, blockEncodingBacktranslator);
        blockEncodingBacktranslator.mapEdges((IIcfgTransition<IcfgLocation>)icfgJoinThreadOtherTransition, iIcfgTransition);
        HashMap hashMap = new HashMap();
        if (!hashMap.isEmpty()) {
            new Overapprox(hashMap).annotate(iIcfgJoinTransitionThreadCurrent);
        }
    }

    private UnmodifiableTransFormula constructJoinTransformula(IJoinActionThreadCurrent.JoinSmtArguments joinSmtArguments, List<IProgramVar> list, String string, CfgSmtToolkit cfgSmtToolkit) {
        ManagedScript managedScript = cfgSmtToolkit.getManagedScript();
        UnmodifiableTransFormula unmodifiableTransFormula = joinSmtArguments.constructThreadIdAssumption(cfgSmtToolkit.getSymbolTable(), managedScript, list);
        UnmodifiableTransFormula unmodifiableTransFormula2 = joinSmtArguments.getAssignmentLhs().isEmpty() ? TransFormulaBuilder.getTrivialTransFormula(managedScript) : joinSmtArguments.constructResultAssignment(managedScript, cfgSmtToolkit.getOutParams().get(string));
        List<UnmodifiableTransFormula> list2 = List.of(unmodifiableTransFormula2, unmodifiableTransFormula);
        return this.constructSequentialComposition(managedScript, list2);
    }

    public static Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> constructThreadInstances(IIcfg<? extends IcfgLocation> iIcfg, List<IIcfgForkTransitionThreadCurrent<IcfgLocation>> list, int n) {
        HashMap<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> hashMap = new HashMap<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>>();
        ManagedScript managedScript = iIcfg.getCfgSmtToolkit().getManagedScript();
        int n2 = 0;
        for (IIcfgForkTransitionThreadCurrent<IcfgLocation> iIcfgForkTransitionThreadCurrent : list) {
            ArrayList<ThreadInstance> arrayList = new ArrayList<ThreadInstance>();
            int n3 = 1;
            while (n3 <= n) {
                String string = iIcfgForkTransitionThreadCurrent.getNameOfForkedProcedure();
                String string2 = ThreadInstanceAdder.generateThreadInstanceId(n2, string, n3, n);
                ThreadInstance threadInstance = ThreadInstanceAdder.constructThreadInstance(managedScript, iIcfgForkTransitionThreadCurrent, string, string2);
                arrayList.add(threadInstance);
                ++n3;
            }
            hashMap.put(iIcfgForkTransitionThreadCurrent, arrayList);
            ++n2;
        }
        return hashMap;
    }

    static IcfgLocation constructErrorLocation(int n, IIcfgForkTransitionThreadCurrent<IcfgLocation> iIcfgForkTransitionThreadCurrent) {
        Check check = new Check(Spec.SUFFICIENT_THREAD_INSTANCES);
        ProcedureErrorWithCheckDebugIdentifier procedureErrorWithCheckDebugIdentifier = new ProcedureErrorWithCheckDebugIdentifier(iIcfgForkTransitionThreadCurrent.getPrecedingProcedure(), n, ProcedureErrorDebugIdentifier.ProcedureErrorType.INUSE_VIOLATION, check);
        IcfgLocation icfgLocation = new IcfgLocation(procedureErrorWithCheckDebugIdentifier, iIcfgForkTransitionThreadCurrent.getPrecedingProcedure());
        ModelUtils.copyAnnotations(iIcfgForkTransitionThreadCurrent, (IElement)icfgLocation);
        check.annotate((IElement)icfgLocation);
        return icfgLocation;
    }

    private static ThreadInstance constructThreadInstance(ManagedScript managedScript, IIcfgForkTransitionThreadCurrent<IcfgLocation> iIcfgForkTransitionThreadCurrent, String string, String string2) {
        IProgramNonOldVar[] iProgramNonOldVarArray = ThreadInstanceAdder.constructThreadIdVariable(string2, managedScript, iIcfgForkTransitionThreadCurrent.getForkSmtArguments().getThreadIdArguments().terms());
        return new ThreadInstance(string2, string, iProgramNonOldVarArray);
    }

    private static String generateThreadInstanceId(int n, String string, int n2, int n3) {
        return string + "Thread" + n2 + "of" + n3 + "ForFork" + n;
    }

    private static ProgramNonOldVar[] constructThreadIdVariable(String string, ManagedScript managedScript, Term[] termArray) {
        ProgramNonOldVar[] programNonOldVarArray = new ProgramNonOldVar[termArray.length];
        int n = 0;
        Term[] termArray2 = termArray;
        int n2 = termArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Term term = termArray2[n3];
            programNonOldVarArray[n] = ThreadInstanceAdder.constructThreadAuxiliaryVariable(string + "_thidvar" + n, term.getSort(), managedScript);
            ++n;
            ++n3;
        }
        return programNonOldVarArray;
    }

    private static ProgramNonOldVar constructThreadAuxiliaryVariable(String string, Sort sort, ManagedScript managedScript) {
        managedScript.lock((Object)string);
        ProgramNonOldVar programNonOldVar = ProgramVarUtils.constructGlobalProgramVarPair(string, sort, managedScript, string);
        managedScript.unlock((Object)string);
        return programNonOldVar;
    }

    CfgSmtToolkit constructNewToolkit(CfgSmtToolkit cfgSmtToolkit, Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> map, Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, IcfgLocation> map2, Collection<IIcfgJoinTransitionThreadCurrent<IcfgLocation>> collection) {
        DefaultIcfgSymbolTable defaultIcfgSymbolTable = new DefaultIcfgSymbolTable(cfgSmtToolkit.getSymbolTable(), cfgSmtToolkit.getProcedures());
        HashRelation hashRelation = new HashRelation(cfgSmtToolkit.getModifiableGlobalsTable().getProcToGlobals());
        for (ThreadInstance object2 : IcfgPetrifier.getAllInstances(map)) {
            IProgramNonOldVar[] iProgramNonOldVarArray = object2.getIdVars();
            int n = iProgramNonOldVarArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProgramNonOldVar iProgramNonOldVar = iProgramNonOldVarArray[n2];
                ThreadInstanceAdder.addVar(iProgramNonOldVar, defaultIcfgSymbolTable, (HashRelation<String, IProgramNonOldVar>)hashRelation, cfgSmtToolkit.getProcedures());
                ++n2;
            }
        }
        defaultIcfgSymbolTable.finishConstruction();
        ConcurrencyInformation concurrencyInformation = new ConcurrencyInformation(map, map2, collection);
        return new CfgSmtToolkit(new ModifiableGlobalsTable((HashRelation<String, IProgramNonOldVar>)hashRelation), cfgSmtToolkit.getManagedScript(), defaultIcfgSymbolTable, cfgSmtToolkit.getProcedures(), cfgSmtToolkit.getInParams(), cfgSmtToolkit.getOutParams(), cfgSmtToolkit.getIcfgEdgeFactory(), concurrencyInformation, cfgSmtToolkit.getSmtFunctionsAndAxioms());
    }

    private static void addVar(IProgramNonOldVar iProgramNonOldVar, DefaultIcfgSymbolTable defaultIcfgSymbolTable, HashRelation<String, IProgramNonOldVar> hashRelation, Set<String> set) {
        defaultIcfgSymbolTable.add(iProgramNonOldVar);
        for (String string : set) {
            hashRelation.addPair((Object)string, (Object)iProgramNonOldVar);
        }
    }
}

