/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.IRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Determinize;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Difference;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Intersect;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsFinite;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.PowersetDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveDeadEnds;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveUnreachable;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolantGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryForInterpolantAutomata;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryResultChecking;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.ErrorAutomatonStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.ErrorAutomatonStatisticsType;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.IErrorAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorlocalization.ErrorLocalizationStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders.StraightLineInterpolantAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.util.statistics.Benchmark;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class ErrorAutomatonStatisticsGenerator
implements IStatisticsDataProvider {
    private static final String ERROR_AUTOMATON_CONSTRUCTION_TIME = "ErrorAutomatonConstructionTime";
    private static final String ERROR_AUTOMATON_DIFFERENCE_TIME = "ErrorAutomatonDifferenceTime";
    private final Benchmark mBenchmark;
    private boolean mRunningConstruction = false;
    private boolean mRunningDifference = false;
    private int mTraceLength = -1;
    private final List<AutomatonStatisticsEntry> mAutomatonStatistics = new LinkedList<AutomatonStatisticsEntry>();
    private EnhancementType mEnhancement = EnhancementType.UNKNOWN;
    private final Set<Integer> mLetters = new HashSet<Integer>();
    private int mLettersFirstTrace = -1;
    private int mRelevantStatements;
    private long mFaultLocalizationTime = 0L;

    public ErrorAutomatonStatisticsGenerator() {
        this.mBenchmark = new Benchmark();
        this.mBenchmark.register(ERROR_AUTOMATON_CONSTRUCTION_TIME);
    }

    public void startErrorAutomatonConstructionTime() {
        assert (!this.mRunningConstruction) : "Timing already running";
        this.mRunningConstruction = true;
        this.mBenchmark.start(ERROR_AUTOMATON_CONSTRUCTION_TIME);
    }

    public void stopErrorAutomatonConstructionTime() {
        assert (this.mRunningConstruction) : "Timing not running";
        this.mRunningConstruction = false;
        this.mBenchmark.pause(ERROR_AUTOMATON_CONSTRUCTION_TIME);
    }

    public void startErrorAutomatonDifferenceTime() {
        assert (!this.mRunningDifference) : "Timing already running";
        this.mRunningDifference = true;
        this.mBenchmark.start(ERROR_AUTOMATON_DIFFERENCE_TIME);
    }

    public void stopErrorAutomatonDifferenceTime() {
        assert (this.mRunningDifference) : "Timing not running";
        this.mRunningDifference = false;
        this.mBenchmark.pause(ERROR_AUTOMATON_DIFFERENCE_TIME);
    }

    public void reportTrace(NestedWord<?> nestedWord) {
        assert (this.mTraceLength == -1) : "Length already reported";
        this.mTraceLength = nestedWord.length();
        int n = 0;
        while (n < nestedWord.length()) {
            this.mLetters.add(nestedWord.getSymbol(n).hashCode());
            ++n;
        }
        if (this.mLettersFirstTrace == -1) {
            this.mLettersFirstTrace = this.mTraceLength;
        }
    }

    public <L> void reportRelevantStatements(List<Collection<L>> list) {
        HashSet<L> hashSet = new HashSet<L>();
        boolean bl = true;
        for (Collection<L> collection : list) {
            if (bl) {
                hashSet.addAll(collection);
                bl = false;
                continue;
            }
            hashSet.retainAll(collection);
        }
        this.mRelevantStatements = hashSet.size();
    }

    public void reportFaultLocalizationStatistics(List<ErrorLocalizationStatisticsGenerator> list) {
        for (ErrorLocalizationStatisticsGenerator errorLocalizationStatisticsGenerator : list) {
            this.mFaultLocalizationTime += errorLocalizationStatisticsGenerator.getErrorLocalizationTime();
        }
    }

    public <L extends IIcfgTransition<?>> void evaluateFinalErrorAutomaton(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, IErrorAutomatonBuilder<L> iErrorAutomatonBuilder, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, PredicateFactoryForInterpolantAutomata predicateFactoryForInterpolantAutomata, PredicateFactoryResultChecking predicateFactoryResultChecking, IRun<L, ?> iRun) throws AutomataLibraryException {
        AutomataLibraryServices automataLibraryServices = new AutomataLibraryServices(iUltimateServiceProvider);
        NestedWordAutomaton<L, IPredicate> nestedWordAutomaton = switch (iErrorAutomatonBuilder.getType()) {
            case IErrorAutomatonBuilder.ErrorAutomatonType.SIMPLE_ERROR_AUTOMATON, IErrorAutomatonBuilder.ErrorAutomatonType.ERROR_AUTOMATON -> iErrorAutomatonBuilder.getResultBeforeEnhancement();
            case IErrorAutomatonBuilder.ErrorAutomatonType.DANGER_AUTOMATON -> ErrorAutomatonStatisticsGenerator.constructStraightLineAutomaton(iUltimateServiceProvider, iRun, NestedWordAutomataUtils.getVpAlphabet(iNwaOutgoingLetterAndTransitionProvider), predicateFactoryForInterpolantAutomata);
            default -> throw new IllegalArgumentException("Unknown error automaton type: " + String.valueOf((Object)iErrorAutomatonBuilder.getType()));
        };
        NestedWordAutomatonReachableStates nestedWordAutomatonReachableStates = new RemoveUnreachable(automataLibraryServices, iErrorAutomatonBuilder.getResultAfterEnhancement()).getResult();
        INestedWordAutomaton iNestedWordAutomaton = new Intersect(automataLibraryServices, (IIntersectionStateFactory)predicateFactoryResultChecking, iNwaOutgoingLetterAndTransitionProvider, (INwaOutgoingLetterAndTransitionProvider)nestedWordAutomatonReachableStates).getResult();
        IDoubleDeckerAutomaton iDoubleDeckerAutomaton = new RemoveDeadEnds(automataLibraryServices, (INwaOutgoingLetterAndTransitionProvider)iNestedWordAutomaton).getResult();
        INestedWordAutomaton iNestedWordAutomaton2 = new Determinize(automataLibraryServices, (IDeterminizeStateFactory)predicateFactoryResultChecking, (INwaOutgoingLetterAndTransitionProvider)iDoubleDeckerAutomaton).getResult();
        PowersetDeterminizer powersetDeterminizer = new PowersetDeterminizer(nestedWordAutomaton, true, (IDeterminizeStateFactory)predicateFactoryForInterpolantAutomata);
        IDoubleDeckerAutomaton iDoubleDeckerAutomaton2 = new Difference(automataLibraryServices, (ISinkStateFactory)predicateFactoryResultChecking, (INwaOutgoingLetterAndTransitionProvider)iNestedWordAutomaton2, nestedWordAutomaton, (IStateDeterminizer)powersetDeterminizer, false).getResult();
        if (new IsEmpty(automataLibraryServices, (INwaOutgoingLetterAndTransitionProvider)iDoubleDeckerAutomaton2).getResult().booleanValue()) {
            this.mEnhancement = EnhancementType.NONE;
            if (iLogger.isWarnEnabled()) {
                iLogger.warn((Object)"Automaton did not add additional traces.");
            }
        } else if (new IsFinite(automataLibraryServices, iNestedWordAutomaton2).getResult().booleanValue()) {
            this.mEnhancement = EnhancementType.FINITE;
            if (iLogger.isWarnEnabled()) {
                iLogger.warn((Object)"Automaton has a finite language.");
            }
        } else {
            this.mEnhancement = EnhancementType.INFINITE;
            if (iLogger.isInfoEnabled()) {
                iLogger.info((Object)"Automaton has an infinite language.");
            }
        }
        NestedWordAutomatonReachableStates nestedWordAutomatonReachableStates2 = new NestedWordAutomatonReachableStates(automataLibraryServices, (INwaOutgoingTransitionProvider)iNestedWordAutomaton2);
        nestedWordAutomatonReachableStates2.computeAcceptingComponents();
        if (iLogger.isInfoEnabled()) {
            iLogger.info((Object)("Effective automaton size information: " + nestedWordAutomatonReachableStates2.sizeInformation()));
        }
    }

    public void finishAutomatonInstance() {
        if (this.mRunningConstruction || this.mRunningDifference || this.mTraceLength == -1 || this.mEnhancement == null) {
            throw new IllegalAccessError("Not all statistics data were provided.");
        }
        long l = this.getLastConstructionTime();
        long l2 = this.getLastDifferenceTime();
        int n = this.mTraceLength;
        EnhancementType enhancementType = this.mEnhancement;
        this.mTraceLength = -1;
        this.mAutomatonStatistics.add(new AutomatonStatisticsEntry(l, l2, n, enhancementType));
    }

    public long getLastConstructionTime() {
        return (long)this.mBenchmark.getElapsedTime(ERROR_AUTOMATON_CONSTRUCTION_TIME, TimeUnit.NANOSECONDS);
    }

    public long getLastDifferenceTime() {
        return (long)this.mBenchmark.getElapsedTime(ERROR_AUTOMATON_DIFFERENCE_TIME, TimeUnit.NANOSECONDS);
    }

    public Object getTotalNumber() {
        return this.mAutomatonStatistics.size();
    }

    public EnhancementType getEnhancement() {
        return this.mEnhancement;
    }

    public Collection<String> getKeys() {
        return ErrorAutomatonStatisticsType.getInstance().getKeys();
    }

    public Object getValue(String string) {
        ErrorAutomatonStatisticsDefinitions errorAutomatonStatisticsDefinitions = ErrorAutomatonStatisticsDefinitions.valueOf(string);
        switch (errorAutomatonStatisticsDefinitions) {
            case NumberErrorTraces: {
                return this.getTotalNumber();
            }
            case NumberStatementsAllTraces: {
                return this.mLetters.size();
            }
            case NumberStatementsFirstTrace: {
                return this.mLettersFirstTrace;
            }
            case NumberRelevantStatements: {
                return this.mRelevantStatements;
            }
            case FaulLocalizationTime: {
                return this.mFaultLocalizationTime;
            }
            case TraceLengthAvg: {
                return this.getAverageTraceLength();
            }
            case ErrorAutomatonConstructionTimeAvg: {
                return this.getAverageErrorAutomatonConstructionTime(automatonStatisticsEntry -> automatonStatisticsEntry.mConstructionTime);
            }
            case ErrorAutomatonConstructionTimeTotal: {
                return this.getTotalErrorAutomatonConstructionTime(automatonStatisticsEntry -> automatonStatisticsEntry.mConstructionTime);
            }
            case ErrorAutomatonDifferenceTimeAvg: {
                return this.getAverageErrorAutomatonConstructionTime(automatonStatisticsEntry -> automatonStatisticsEntry.mDifferenceTime);
            }
            case ErrorAutomatonDifferenceTimeTotal: {
                return this.getTotalErrorAutomatonConstructionTime(automatonStatisticsEntry -> automatonStatisticsEntry.mDifferenceTime);
            }
            case NumberOfNoEnhancement: {
                return this.getNumberOfGivenEnhancementType(EnhancementType.NONE);
            }
            case NumberOfFiniteEnhancement: {
                return this.getNumberOfGivenEnhancementType(EnhancementType.FINITE);
            }
            case NumberOfInfiniteEnhancement: {
                return this.getNumberOfGivenEnhancementType(EnhancementType.INFINITE);
            }
        }
        throw new AssertionError((Object)("Unknown key: " + string));
    }

    public IStatisticsType getBenchmarkType() {
        return ErrorAutomatonStatisticsType.getInstance();
    }

    private int getAverageTraceLength() {
        int n = this.mAutomatonStatistics.size();
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        for (AutomatonStatisticsEntry automatonStatisticsEntry : this.mAutomatonStatistics) {
            n2 += automatonStatisticsEntry.mTraceLength;
        }
        return n2 / n;
    }

    private Object getNumberOfGivenEnhancementType(EnhancementType enhancementType) {
        int n = 0;
        for (AutomatonStatisticsEntry automatonStatisticsEntry : this.mAutomatonStatistics) {
            if (automatonStatisticsEntry.mEnhancement != enhancementType) continue;
            ++n;
        }
        return n;
    }

    private long getAverageErrorAutomatonConstructionTime(Function<AutomatonStatisticsEntry, Long> function) {
        int n = this.mAutomatonStatistics.size();
        if (n == 0) {
            return 0L;
        }
        long l = this.getTotalErrorAutomatonConstructionTime(function);
        return l / (long)n;
    }

    private long getTotalErrorAutomatonConstructionTime(Function<AutomatonStatisticsEntry, Long> function) {
        long l = 0L;
        for (AutomatonStatisticsEntry automatonStatisticsEntry : this.mAutomatonStatistics) {
            l += function.apply(automatonStatisticsEntry).longValue();
        }
        return l;
    }

    private static <L extends IIcfgTransition<?>> NestedWordAutomaton<L, IPredicate> constructStraightLineAutomaton(IUltimateServiceProvider iUltimateServiceProvider, IRun<L, ?> iRun, VpAlphabet<L> vpAlphabet, PredicateFactoryForInterpolantAutomata predicateFactoryForInterpolantAutomata) {
        StraightlineGenerator<L> straightlineGenerator = new StraightlineGenerator<L>(iRun);
        return new StraightLineInterpolantAutomatonBuilder<L>(iUltimateServiceProvider, iRun.getWord(), vpAlphabet, Collections.singletonList(new TracePredicates(straightlineGenerator)), (IEmptyStackStateFactory<IPredicate>)predicateFactoryForInterpolantAutomata, StraightLineInterpolantAutomatonBuilder.InitialAndAcceptingStateMode.ONLY_FIRST_INITIAL_ONLY_FALSE_ACCEPTING).getResult();
    }

    private static class AutomatonStatisticsEntry {
        private final long mConstructionTime;
        private final int mTraceLength;
        private final long mDifferenceTime;
        private final EnhancementType mEnhancement;

        public AutomatonStatisticsEntry(long l, long l2, int n, EnhancementType enhancementType) {
            this.mDifferenceTime = l2;
            this.mConstructionTime = l;
            this.mTraceLength = n;
            this.mEnhancement = enhancementType;
        }
    }

    public static enum EnhancementType {
        NONE,
        FINITE,
        INFINITE,
        UNKNOWN;

    }

    private static final class StraightlineGenerator<L extends IAction>
    implements IInterpolantGenerator<L> {
        private final IRun<L, ?> mErrorTrace;

        private StraightlineGenerator(IRun<L, ?> iRun) {
            this.mErrorTrace = iRun;
        }

        public boolean isPerfectSequence() {
            throw new UnsupportedOperationException();
        }

        public List<L> getTrace() {
            return this.mErrorTrace.getWord().asList();
        }

        public IPredicateUnifier getPredicateUnifier() {
            throw new UnsupportedOperationException();
        }

        public IPredicate getPrecondition() {
            return StraightlineGenerator.createPredicate();
        }

        public IPredicate getPostcondition() {
            return StraightlineGenerator.createPredicate();
        }

        public Map<Integer, IPredicate> getPendingContexts() {
            throw new UnsupportedOperationException();
        }

        public IPredicate[] getInterpolants() {
            IPredicate[] iPredicateArray = new IPredicate[this.mErrorTrace.getWord().length() - 1];
            int n = 0;
            while (n < iPredicateArray.length) {
                iPredicateArray[n] = StraightlineGenerator.createPredicate();
                ++n;
            }
            return iPredicateArray;
        }

        public InterpolantComputationStatus getInterpolantComputationStatus() {
            throw new UnsupportedOperationException();
        }

        private static IPredicate createPredicate() {
            return new IPredicate(){

                public Set<IProgramVar> getVars() {
                    throw new UnsupportedOperationException();
                }

                public Term getFormula() {
                    throw new UnsupportedOperationException();
                }

                public Term getClosedFormula() {
                    throw new UnsupportedOperationException();
                }

                public Set<IProgramFunction> getFuns() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public IStatisticsDataProvider getStatistics() {
            return null;
        }
    }
}

