/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayDeque;

public class NonRecursive {
    private final ArrayDeque<Walker> mTodo = new ArrayDeque();

    protected void reset() {
        this.mTodo.clear();
    }

    public void enqueueWalker(Walker walker) {
        this.mTodo.addLast(walker);
    }

    public void run(Walker walker) {
        this.mTodo.addLast(walker);
        this.run();
    }

    public void run() {
        while (!this.mTodo.isEmpty()) {
            this.mTodo.removeLast().walk(this);
        }
    }

    public String toString() {
        return this.mTodo.toString();
    }

    public static abstract class TermWalker
    implements Walker {
        protected Term mTerm;

        public TermWalker(Term term) {
            this.mTerm = term;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            if (this.mTerm instanceof ApplicationTerm) {
                this.walk(nonRecursive, (ApplicationTerm)this.mTerm);
            } else if (this.mTerm instanceof LetTerm) {
                this.walk(nonRecursive, (LetTerm)this.mTerm);
            } else if (this.mTerm instanceof AnnotatedTerm) {
                this.walk(nonRecursive, (AnnotatedTerm)this.mTerm);
            } else if (this.mTerm instanceof LambdaTerm) {
                this.walk(nonRecursive, (LambdaTerm)this.mTerm);
            } else if (this.mTerm instanceof QuantifiedFormula) {
                this.walk(nonRecursive, (QuantifiedFormula)this.mTerm);
            } else if (this.mTerm instanceof ConstantTerm) {
                this.walk(nonRecursive, (ConstantTerm)this.mTerm);
            } else if (this.mTerm instanceof TermVariable) {
                this.walk(nonRecursive, (TermVariable)this.mTerm);
            } else if (this.mTerm instanceof MatchTerm) {
                this.walk(nonRecursive, (MatchTerm)this.mTerm);
            }
        }

        public abstract void walk(NonRecursive var1, ConstantTerm var2);

        public abstract void walk(NonRecursive var1, AnnotatedTerm var2);

        public abstract void walk(NonRecursive var1, ApplicationTerm var2);

        public abstract void walk(NonRecursive var1, LetTerm var2);

        public abstract void walk(NonRecursive var1, LambdaTerm var2);

        public abstract void walk(NonRecursive var1, QuantifiedFormula var2);

        public abstract void walk(NonRecursive var1, TermVariable var2);

        public abstract void walk(NonRecursive var1, MatchTerm var2);

        public Term getTerm() {
            return this.mTerm;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ":" + String.valueOf(this.mTerm);
        }
    }

    protected static interface Walker {
        public void walk(NonRecursive var1);
    }
}

