/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.LassoPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.ArrayCellRepVarConstructor;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.ArrayCellReplacementVarInformation;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.EqualitySupportingInvariantAnalysis;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.TransFormulaLRWithArrayCells;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.TransFormulaLRWithArrayInformation;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.LassoUnderConstruction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class RewriteArrays2
extends LassoPreprocessor {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    public static final boolean ADDITIONAL_CHECKS_IF_ASSERTIONS_ENABLED = true;
    public static final String DESCRIPTION = "Removes arrays by introducing new variables for each relevant array cell";
    static final String AUX_ARRAY = "auxArray";
    private final ManagedScript mScript;
    private final UnmodifiableTransFormula mOriginalStem;
    private final UnmodifiableTransFormula mOriginalLoop;
    private final Set<Term> mArrayIndexSupportingInvariants;
    private final Set<IProgramNonOldVar> mModifiableGlobalsAtHonda;
    private final ReplacementVarFactory mReplacementVarFactory;
    private final ManagedScript mFreshTermVariableConstructor;
    private final IIcfgSymbolTable mBoogie2Smt;
    private final boolean mOverapproximateByOmmitingDisjointIndices;

    public RewriteArrays2(boolean bl, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, Set<IProgramNonOldVar> set, IUltimateServiceProvider iUltimateServiceProvider, Set<Term> set2, IIcfgSymbolTable iIcfgSymbolTable, ManagedScript managedScript, ReplacementVarFactory replacementVarFactory, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger("Library-LassoRanker");
        this.mSimplificationTechnique = simplificationTechnique;
        this.mOriginalStem = unmodifiableTransFormula;
        this.mOriginalLoop = unmodifiableTransFormula2;
        this.mModifiableGlobalsAtHonda = set;
        this.mArrayIndexSupportingInvariants = set2;
        this.mOverapproximateByOmmitingDisjointIndices = bl;
        this.mBoogie2Smt = iIcfgSymbolTable;
        this.mScript = managedScript;
        this.mReplacementVarFactory = replacementVarFactory;
        this.mFreshTermVariableConstructor = this.mScript;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public Collection<LassoUnderConstruction> process(LassoUnderConstruction lassoUnderConstruction) throws TermException {
        TransFormulaLRWithArrayInformation transFormulaLRWithArrayInformation = new TransFormulaLRWithArrayInformation(this.mServices, lassoUnderConstruction.getStem(), this.mReplacementVarFactory, this.mScript, this.mBoogie2Smt, null, this.mSimplificationTechnique);
        TransFormulaLRWithArrayInformation transFormulaLRWithArrayInformation2 = new TransFormulaLRWithArrayInformation(this.mServices, lassoUnderConstruction.getLoop(), this.mReplacementVarFactory, this.mScript, this.mBoogie2Smt, transFormulaLRWithArrayInformation, this.mSimplificationTechnique);
        ArrayCellRepVarConstructor arrayCellRepVarConstructor = new ArrayCellRepVarConstructor(this.mReplacementVarFactory, this.mScript.getScript(), transFormulaLRWithArrayInformation, transFormulaLRWithArrayInformation2);
        Object object = new EqualitySupportingInvariantAnalysis(this.computeDoubletons(arrayCellRepVarConstructor), this.mBoogie2Smt, this.mScript, this.mOriginalStem, this.mOriginalLoop, this.mModifiableGlobalsAtHonda);
        EqualityAnalysisResult equalityAnalysisResult = ((EqualitySupportingInvariantAnalysis)object).getEqualityAnalysisResult();
        this.mArrayIndexSupportingInvariants.addAll(equalityAnalysisResult.constructListOfEqualities(this.mScript.getScript()));
        this.mArrayIndexSupportingInvariants.addAll(equalityAnalysisResult.constructListOfNotEquals(this.mScript.getScript()));
        object = new TransFormulaLRWithArrayCells(this.mServices, this.mReplacementVarFactory, this.mScript, transFormulaLRWithArrayInformation, equalityAnalysisResult, this.mBoogie2Smt, null, true, true, this.mSimplificationTechnique);
        TransFormulaLRWithArrayCells transFormulaLRWithArrayCells = new TransFormulaLRWithArrayCells(this.mServices, this.mReplacementVarFactory, this.mScript, transFormulaLRWithArrayInformation2, equalityAnalysisResult, this.mBoogie2Smt, arrayCellRepVarConstructor, true, false, this.mSimplificationTechnique);
        LassoUnderConstruction lassoUnderConstruction2 = new LassoUnderConstruction(((TransFormulaLRWithArrayCells)object).getResult(), transFormulaLRWithArrayCells.getResult());
        assert (RewriteArrays2.checkStemImplication(this.mServices, this.mLogger, lassoUnderConstruction, lassoUnderConstruction2, this.mBoogie2Smt, this.mScript)) : "result of RewriteArrays too strong";
        return Collections.singleton(lassoUnderConstruction2);
    }

    private Set<Doubleton<Term>> computeDoubletons(ArrayCellRepVarConstructor arrayCellRepVarConstructor) {
        NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> nestedMap2 = arrayCellRepVarConstructor.getArrayRepresentative2IndexRepresentative2ReplacementVar();
        LinkedHashSet<Doubleton<Term>> linkedHashSet = new LinkedHashSet<Doubleton<Term>>();
        for (TermVariable termVariable : nestedMap2.keySet()) {
            Set set = nestedMap2.get((Object)termVariable).keySet();
            ArrayIndex[] arrayIndexArray = set.toArray(new ArrayIndex[set.size()]);
            int n = 0;
            while (n < arrayIndexArray.length) {
                int n2 = n + 1;
                while (n2 < arrayIndexArray.length) {
                    ArrayIndex arrayIndex = arrayIndexArray[n];
                    ArrayIndex arrayIndex2 = arrayIndexArray[n2];
                    assert (arrayIndex.size() == arrayIndex2.size());
                    int n3 = 0;
                    while (n3 < arrayIndex.size()) {
                        Doubleton doubleton = new Doubleton((Object)((Term)arrayIndex.get(n3)), (Object)((Term)arrayIndex2.get(n3)));
                        linkedHashSet.add((Doubleton<Term>)doubleton);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return linkedHashSet;
    }

    public static boolean checkStemImplication(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, LassoUnderConstruction lassoUnderConstruction, LassoUnderConstruction lassoUnderConstruction2, IIcfgSymbolTable iIcfgSymbolTable, ManagedScript managedScript) {
        Script.LBool lBool = ModifiableTransFormulaUtils.implies((IUltimateServiceProvider)iUltimateServiceProvider, (ILogger)iLogger, (ModifiableTransFormula)lassoUnderConstruction.getStem(), (ModifiableTransFormula)lassoUnderConstruction2.getStem(), (ManagedScript)managedScript, (IIcfgSymbolTable)iIcfgSymbolTable);
        if (lBool != Script.LBool.SAT && lBool != Script.LBool.UNSAT) {
            iLogger.warn((Object)("result of RewriteArrays check is " + String.valueOf(lBool)));
        }
        assert (lBool != Script.LBool.SAT) : "result of RewriteArrays too strong";
        return lBool != Script.LBool.SAT;
    }
}

