/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer;

import de.uni_freiburg.informatik.ultimate.lassoranker.LassoAnalysis;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.NonterminationAnalysisBenchmark;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationAnalysisBenchmark;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.CoverageAnalysis;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiCegarLoopBenchmark;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.LassoAnalysisResults;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.LassoCheck;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsGeneratorWithStopwatches;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BuchiCegarLoopBenchmarkGenerator
extends CegarLoopStatisticsGenerator {
    private final int[] mNontrivialModuleStages = new int[5];
    private final LassoAnalysisResults mLassoAnalysisResults = new LassoAnalysisResults();
    private CoverageAnalysis.BackwardCoveringInformation mBciFinite = new CoverageAnalysis.BackwardCoveringInformation(0, 0);
    private CoverageAnalysis.BackwardCoveringInformation mBciBuchi = new CoverageAnalysis.BackwardCoveringInformation(0, 0);
    private int mHighestRank;
    private final List<LassoAnalysis.PreprocessingBenchmark> mPreprocessingBenchmarks = new ArrayList<LassoAnalysis.PreprocessingBenchmark>();
    private final List<TerminationAnalysisBenchmark> mTerminationAnalysisBenchmarks = new ArrayList<TerminationAnalysisBenchmark>();
    private final List<NonterminationAnalysisBenchmark> mNonterminationAnalysisBenchmarks = new ArrayList<NonterminationAnalysisBenchmark>();
    private int mLassoNonterminationAnalysisSATFixpoint;
    private int mLassoNonterminationAnalysisSATUnbounded;
    private int mLassoNonterminationAnalysisUNSAT;
    private int mLassoNonterminationAnalysisUNKOWN;
    private long mLassoNonterminationAnalysisTime;
    private int mMinimizationOfDetAutom;
    private int mMinimizationOfNondetAutom;

    public IStatisticsType getBenchmarkType() {
        return BuchiCegarLoopBenchmark.getInstance();
    }

    public String[] getStopwatches() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(super.getStopwatches()));
        arrayList.add("NonLiveStateRemoval");
        arrayList.add("BuchiClosure");
        arrayList.add("NontrivialModuleStages");
        arrayList.add("LassoAnalysisTime");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void announceSuccessfullRefinementStage(int n) {
        int n2 = n;
        this.mNontrivialModuleStages[n2] = this.mNontrivialModuleStages[n2] + 1;
    }

    public void addBackwardCoveringInformationFinite(CoverageAnalysis.BackwardCoveringInformation backwardCoveringInformation) {
        this.mBciFinite = new CoverageAnalysis.BackwardCoveringInformation(this.mBciFinite, backwardCoveringInformation);
    }

    public void addBackwardCoveringInformationBuchi(CoverageAnalysis.BackwardCoveringInformation backwardCoveringInformation) {
        this.mBciBuchi = new CoverageAnalysis.BackwardCoveringInformation(this.mBciBuchi, backwardCoveringInformation);
    }

    public Object getValue(String string) {
        switch (string) {
            case "NonLiveStateRemoval": 
            case "BuchiClosure": 
            case "LassoAnalysisTime": {
                try {
                    return this.getElapsedTime(string);
                }
                catch (StatisticsGeneratorWithStopwatches.StopwatchStillRunningException stopwatchStillRunningException) {
                    throw new AssertionError((Object)("clock still running: " + string));
                }
            }
            case "HighestRank": {
                return this.mHighestRank;
            }
            case "NontrivialModuleStages": {
                return this.mNontrivialModuleStages;
            }
            case "LassoAnalysisResults": {
                return this.mLassoAnalysisResults;
            }
            case "InterpolantCoveringCapabilityFinite": {
                return this.mBciFinite;
            }
            case "InterpolantCoveringCapabilityBuchi": {
                return this.mBciBuchi;
            }
            case "LassoPreprocessingBenchmarks": {
                return this.mPreprocessingBenchmarks;
            }
            case "LassoTerminationAnalysisBenchmarks": {
                return this.mTerminationAnalysisBenchmarks;
            }
            case "LassoNonterminationAnalysisSatFixpoint": {
                return this.mLassoNonterminationAnalysisSATFixpoint;
            }
            case "LassoNonterminationAnalysisSatUnbounded": {
                return this.mLassoNonterminationAnalysisSATUnbounded;
            }
            case "LassoNonterminationAnalysisUnsat": {
                return this.mLassoNonterminationAnalysisUNSAT;
            }
            case "LassoNonterminationAnalysisUnknown": {
                return this.mLassoNonterminationAnalysisUNKOWN;
            }
            case "LassoNonterminationAnalysisTime": {
                return this.mLassoNonterminationAnalysisTime;
            }
            case "MinimizationsOfDetermnisticAutomata": {
                return this.mMinimizationOfDetAutom;
            }
            case "MinimizationsOfNondetermnisticAutomata": {
                return this.mMinimizationOfNondetAutom;
            }
        }
        return super.getValue(string);
    }

    public void reportLassoAnalysis(LassoCheck<? extends IIcfgTransition<?>> lassoCheck) {
        LassoCheck.LassoCheckResult lassoCheckResult = lassoCheck.getLassoCheckResult();
        this.mPreprocessingBenchmarks.addAll(lassoCheck.getPreprocessingBenchmarks());
        this.mTerminationAnalysisBenchmarks.addAll(lassoCheck.getTerminationAnalysisBenchmarks());
        this.mNonterminationAnalysisBenchmarks.addAll(lassoCheck.getNonterminationAnalysisBenchmarks());
        for (NonterminationAnalysisBenchmark continueDirective2 : lassoCheck.getNonterminationAnalysisBenchmarks()) {
            switch (continueDirective2.getConstraintsSatisfiability()) {
                case SAT: {
                    if (continueDirective2.isFixpoint()) {
                        ++this.mLassoNonterminationAnalysisSATFixpoint;
                        break;
                    }
                    ++this.mLassoNonterminationAnalysisSATUnbounded;
                    break;
                }
                case UNKNOWN: {
                    ++this.mLassoNonterminationAnalysisUNKOWN;
                    break;
                }
                case UNSAT: {
                    ++this.mLassoNonterminationAnalysisUNSAT;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.mLassoNonterminationAnalysisTime += continueDirective2.getTime();
        }
        LassoCheck.ContinueDirective continueDirective = lassoCheckResult.getContinueDirective();
        switch (continueDirective) {
            case REFINE_BOTH: {
                if (lassoCheckResult.getStemFeasibility() == LassoCheck.TraceCheckResult.INFEASIBLE) {
                    this.mLassoAnalysisResults.increment("SILT");
                    break;
                }
                assert (lassoCheckResult.getConcatFeasibility() == LassoCheck.TraceCheckResult.INFEASIBLE);
                assert (lassoCheckResult.getLoopTermination() == LassoCheck.SynthesisResult.TERMINATING);
                this.mLassoAnalysisResults.increment("concLT");
                break;
            }
            case REFINE_BUCHI: {
                assert (lassoCheckResult.getStemFeasibility() != LassoCheck.TraceCheckResult.INFEASIBLE);
                if (lassoCheckResult.getLoopTermination() == LassoCheck.SynthesisResult.TERMINATING) {
                    this.mLassoAnalysisResults.increment("SFLT");
                    break;
                }
                assert (lassoCheckResult.getLassoTermination() == LassoCheck.SynthesisResult.TERMINATING);
                this.mLassoAnalysisResults.increment("lasso");
                break;
            }
            case REFINE_FINITE: {
                if (lassoCheckResult.getStemFeasibility() == LassoCheck.TraceCheckResult.INFEASIBLE) {
                    if (lassoCheckResult.getLoopFeasibility() == LassoCheck.TraceCheckResult.INFEASIBLE) {
                        this.mLassoAnalysisResults.increment("SILI");
                        break;
                    }
                    if (lassoCheckResult.getLoopTermination() == LassoCheck.SynthesisResult.NONTERMINATING) {
                        this.mLassoAnalysisResults.increment("SILN");
                        break;
                    }
                    assert (lassoCheckResult.getLoopFeasibility() == LassoCheck.TraceCheckResult.UNCHECKED || lassoCheckResult.getLoopFeasibility() == LassoCheck.TraceCheckResult.UNKNOWN || lassoCheckResult.getLoopTermination() == LassoCheck.SynthesisResult.UNCHECKED || lassoCheckResult.getLoopTermination() == LassoCheck.SynthesisResult.UNKNOWN) : "lasso checking: illegal case";
                    this.mLassoAnalysisResults.increment("SILU");
                    break;
                }
                if (lassoCheckResult.getLoopFeasibility() == LassoCheck.TraceCheckResult.INFEASIBLE) {
                    this.mLassoAnalysisResults.increment("SFLI");
                    break;
                }
                assert (lassoCheckResult.getConcatFeasibility() == LassoCheck.TraceCheckResult.INFEASIBLE);
                this.mLassoAnalysisResults.increment("conc");
                break;
            }
            case REPORT_NONTERMINATION: {
                assert (lassoCheckResult.getStemFeasibility() != LassoCheck.TraceCheckResult.INFEASIBLE);
                assert (lassoCheckResult.getLoopFeasibility() != LassoCheck.TraceCheckResult.INFEASIBLE);
                assert (lassoCheckResult.getConcatFeasibility() != LassoCheck.TraceCheckResult.INFEASIBLE);
                assert (lassoCheck.getNonTerminationArgument() != null);
                this.mLassoAnalysisResults.increment("nont");
                break;
            }
            case REPORT_UNKNOWN: {
                assert (lassoCheckResult.getStemFeasibility() != LassoCheck.TraceCheckResult.INFEASIBLE);
                assert (lassoCheckResult.getLoopFeasibility() != LassoCheck.TraceCheckResult.INFEASIBLE);
                assert (lassoCheckResult.getConcatFeasibility() != LassoCheck.TraceCheckResult.INFEASIBLE);
                assert (lassoCheck.getNonTerminationArgument() == null);
                this.mLassoAnalysisResults.increment("unkn");
                break;
            }
            default: {
                throw new AssertionError((Object)"unknown case");
            }
        }
    }

    public void reportHighestRank(int n) {
        this.mHighestRank = Math.max(this.mHighestRank, n);
    }

    public void reportMinimizationOfDetAutom() {
        ++this.mMinimizationOfDetAutom;
    }

    public void reportMinimizationOfNondetAutom() {
        ++this.mMinimizationOfNondetAutom;
    }
}

