/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.preferences;

import de.uni_freiburg.informatik.ultimate.core.model.preferences.BaseUltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.PreferenceType;
import java.util.ArrayList;
import java.util.List;

public final class UltimatePreferenceItem<T>
extends BaseUltimatePreferenceItem {
    private final String mLabel;
    private final T mDefaultValue;
    private final PreferenceType mType;
    private final T[] mChoices;
    private final IUltimatePreferenceItemValidator<T> mPreferenceValidator;
    private final String mDescription;
    private final Level mLevel;

    public UltimatePreferenceItem(String string, T t, PreferenceType preferenceType) {
        this(string, t, preferenceType, null, null);
    }

    public UltimatePreferenceItem(String string, T t, PreferenceType preferenceType, T[] TArray, IUltimatePreferenceItemValidator<T> iUltimatePreferenceItemValidator) {
        this(string, t, preferenceType, null, TArray, iUltimatePreferenceItemValidator);
    }

    public UltimatePreferenceItem(String string, T t, PreferenceType preferenceType, T[] TArray) {
        this(string, t, preferenceType, null, TArray, null);
    }

    public UltimatePreferenceItem(String string, T t, String string2, PreferenceType preferenceType, T[] TArray) {
        this(string, t, preferenceType, string2, TArray, null);
    }

    public UltimatePreferenceItem(String string, T t, String string2, Level level, PreferenceType preferenceType, T[] TArray) {
        this(string, t, preferenceType, string2, level, TArray, null);
    }

    public UltimatePreferenceItem(String string, T t, PreferenceType preferenceType, IUltimatePreferenceItemValidator<T> iUltimatePreferenceItemValidator) {
        this(string, t, preferenceType, null, null, iUltimatePreferenceItemValidator);
    }

    public UltimatePreferenceItem(String string, T t, String string2, PreferenceType preferenceType) {
        this(string, t, preferenceType, string2, null, null);
    }

    public UltimatePreferenceItem(String string, T t, String string2, Level level, PreferenceType preferenceType) {
        this(string, t, preferenceType, string2, level, null, null);
    }

    public UltimatePreferenceItem(String string, T t, String string2, PreferenceType preferenceType, IUltimatePreferenceItemValidator<T> iUltimatePreferenceItemValidator) {
        this(string, t, preferenceType, string2, null, iUltimatePreferenceItemValidator);
    }

    public UltimatePreferenceItem(String string, T t, PreferenceType preferenceType, String string2, T[] TArray, IUltimatePreferenceItemValidator<T> iUltimatePreferenceItemValidator) {
        this(string, t, preferenceType, string2, UltimatePreferenceItem.getLevelFromDescription(string2), TArray, iUltimatePreferenceItemValidator);
    }

    private static Level getLevelFromDescription(String string) {
        if (string == null || string.isEmpty()) {
            return Level.EXPERIMENTAL;
        }
        return Level.EXPERT;
    }

    public UltimatePreferenceItem(String string, T t, PreferenceType preferenceType, String string2, Level level, T[] TArray, IUltimatePreferenceItemValidator<T> iUltimatePreferenceItemValidator) {
        this.mLabel = string;
        this.mDefaultValue = t;
        this.mType = preferenceType;
        this.mChoices = TArray;
        this.mPreferenceValidator = iUltimatePreferenceItemValidator;
        this.mDescription = string2;
        this.mLevel = level;
        if ((this.mType == PreferenceType.Radio || this.mType == PreferenceType.Combo) && this.mChoices == null) {
            throw new IllegalArgumentException("You have to supply choices if you use PreferenceType Radio or Combo ");
        }
    }

    public String getLabel() {
        return this.mLabel;
    }

    public T getDefaultValue() {
        return this.mDefaultValue;
    }

    @Override
    public PreferenceType getType() {
        return this.mType;
    }

    public T[] getChoices() {
        return this.mChoices;
    }

    public String[][] getComboFieldEntries() {
        String[][] stringArray = new String[this.mChoices.length][2];
        int n = 0;
        while (n < this.mChoices.length) {
            stringArray[n][0] = this.mChoices[n].toString();
            stringArray[n][1] = stringArray[n][0];
            ++n;
        }
        return stringArray;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String toString() {
        return "Pref: " + this.mLabel + " Type=" + String.valueOf((Object)this.mType) + ", Default=" + String.valueOf(this.mDefaultValue);
    }

    public IUltimatePreferenceItemValidator<T> getPreferenceValidator() {
        return this.mPreferenceValidator;
    }

    @Override
    public List<UltimatePreferenceItem<?>> getFlattenedList() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(this);
        return arrayList;
    }

    public Level getLevel() {
        return this.mLevel;
    }

    public static interface IUltimatePreferenceItemValidator<T> {
        public static final IntegerValidator ONLY_POSITIVE = new IntegerValidator(0, Integer.MAX_VALUE);
        public static final IntegerValidator ONLY_POSITIVE_NON_ZERO = new IntegerValidator(1, Integer.MAX_VALUE);
        public static final IntegerValidator GEQ_TWO = new IntegerValidator(2, Integer.MAX_VALUE);

        public boolean isValid(T var1);

        public String getInvalidValueErrorMessage(T var1);

        public static class DoubleValidator
        implements IUltimatePreferenceItemValidator<Double> {
            private final double mMin;
            private final double mMax;

            public DoubleValidator(double d, double d2) {
                this.mMin = d;
                this.mMax = d2;
            }

            @Override
            public boolean isValid(Double d) {
                return this.mMin <= d && d <= this.mMax;
            }

            @Override
            public String getInvalidValueErrorMessage(Double d) {
                return "Valid range is " + this.mMin + " <= value <= " + this.mMax;
            }
        }

        public static class IntegerValidator
        implements IUltimatePreferenceItemValidator<Integer> {
            private final int mMin;
            private final int mMax;

            public IntegerValidator(int n, int n2) {
                this.mMin = n;
                this.mMax = n2;
            }

            @Override
            public boolean isValid(Integer n) {
                return this.mMin <= n && n <= this.mMax;
            }

            @Override
            public String getInvalidValueErrorMessage(Integer n) {
                return "Valid range is " + this.mMin + " <= value <= " + this.mMax;
            }
        }
    }

    public static enum Level {
        BASIC,
        EXPERT,
        EXPERIMENTAL;

    }
}

