/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PredicateTree<T extends IPredicate> {
    private final Term mTrue;
    private final Term mFalse;
    private final ManagedScript mScript;
    private INode<T> mRoot;

    public PredicateTree(ManagedScript managedScript) {
        this(managedScript, managedScript.getScript().term("true", new Term[0]), managedScript.getScript().term("false", new Term[0]));
    }

    public PredicateTree(ManagedScript managedScript, Term term, Term term2) {
        assert (managedScript != null);
        this.mScript = managedScript;
        this.mTrue = term;
        this.mFalse = term2;
        this.mRoot = null;
    }

    public T unifyPredicate(T t) {
        INode<T> iNode;
        if (t == null) {
            return null;
        }
        if (this.mRoot == null) {
            this.mRoot = new Leaf(this, t);
            return t;
        }
        if (this.mRoot instanceof Leaf) {
            return this.unifyAndUpdate((Leaf)this.mRoot, null, t);
        }
        INode<T> iNode2 = iNode = this.mRoot;
        while (iNode != null) {
            INode<T> iNode3 = iNode.next(t);
            if (iNode3 != null) {
                iNode2 = iNode;
                iNode = iNode3;
                continue;
            }
            return this.unifyAndUpdate((Leaf)iNode, (InnerNode)iNode2, t);
        }
        throw new AssertionError((Object)"Should be unreachable");
    }

    public String toLogString() {
        if (this.mRoot == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayDeque<Pair> arrayDeque = new ArrayDeque<Pair>();
        arrayDeque.addFirst(new Pair((Object)"", this.mRoot));
        while (!arrayDeque.isEmpty()) {
            Pair pair = (Pair)arrayDeque.removeFirst();
            INode iNode = (INode)pair.getSecond();
            if (iNode instanceof Leaf) {
                stringBuilder.append((String)pair.getFirst());
                stringBuilder.append(iNode.toString());
                stringBuilder.append("\n");
                continue;
            }
            InnerNode innerNode = (InnerNode)iNode;
            stringBuilder.append((String)pair.getFirst());
            stringBuilder.append(innerNode.toString());
            stringBuilder.append("\n");
            String string = (String)pair.getFirst() + " ";
            arrayDeque.addFirst(new Pair((Object)string, innerNode.mLeftChild));
            arrayDeque.addFirst(new Pair((Object)string, innerNode.mRightChild));
        }
        return stringBuilder.toString();
    }

    private T unifyAndUpdate(Leaf leaf, InnerNode innerNode, T t) {
        Pair pair = this.unify(leaf.mPredicate, t);
        if (pair.getFirst() == leaf.mPredicate) {
            return leaf.mPredicate;
        }
        InnerNode innerNode2 = this.newSubTree(leaf, t, (Map)pair.getSecond());
        if (innerNode == null) {
            this.mRoot = innerNode2;
        } else {
            boolean bl;
            boolean bl2 = bl = innerNode.mLeftChild == leaf;
            if (bl) {
                innerNode.mLeftChild = innerNode2;
            } else {
                innerNode.mRightChild = innerNode2;
            }
        }
        return t;
    }

    private Pair<T, Map<Term, Term>> unify(T t, T t2) {
        T t3 = t;
        Term term = t3.getClosedFormula();
        Term term2 = t2.getClosedFormula();
        this.mScript.lock((Object)this);
        Term term3 = this.mScript.term((Object)this, "distinct", new Term[]{term, term2});
        this.mScript.push((Object)this, 1);
        try {
            this.mScript.assertTerm((Object)this, term3);
            Script.LBool lBool = this.mScript.checkSat((Object)this);
            if (lBool == Script.LBool.UNSAT) {
                Pair pair = new Pair(t3, null);
                return pair;
            }
            if (lBool == Script.LBool.SAT) {
                HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>(t2.getVars());
                hashSet.addAll(t3.getVars());
                Set<Term> set = hashSet.stream().map(IProgramVar::getDefaultConstant).collect(Collectors.toSet());
                Map map = this.mScript.getScript().getValue(set.toArray(new Term[set.size()]));
                Pair pair = new Pair(t2, (Object)map);
                return pair;
            }
            throw new UnsupportedOperationException("Cannot handle case were solver cannot decide equality of predicates");
        }
        finally {
            this.mScript.pop((Object)this, 1);
            this.mScript.unlock((Object)this);
        }
    }

    private InnerNode newSubTree(Leaf leaf, T t, Map<Term, Term> map) {
        Leaf leaf2 = new Leaf(this, t);
        if (this.goLeft(map, t)) {
            return new InnerNode(leaf2, leaf, map);
        }
        return new InnerNode(leaf, leaf2, map);
    }

    private boolean goLeft(Map<Term, Term> map, T t) {
        Term term = Substitution.apply((ManagedScript)this.mScript, map, (Term)t.getClosedFormula());
        return this.mTrue.equals(term);
    }

    @FunctionalInterface
    private static interface INode<T> {
        public INode<T> next(T var1);
    }

    private final class InnerNode
    implements INode<T> {
        private final Map<Term, Term> mWitness;
        private INode<T> mLeftChild;
        private INode<T> mRightChild;

        private InnerNode(INode<T> iNode, INode<T> iNode2, Map<Term, Term> map) {
            assert (map != null && !map.isEmpty());
            assert (iNode != null);
            assert (iNode2 != null);
            this.mWitness = map;
            this.mLeftChild = iNode;
            this.mRightChild = iNode2;
        }

        @Override
        public INode<T> next(T t) {
            if (PredicateTree.this.goLeft(this.mWitness, t)) {
                return this.mLeftChild;
            }
            return this.mRightChild;
        }

        public String toString() {
            return this.mWitness.toString();
        }
    }

    private static final class Leaf
    implements INode<T> {
        private final T mPredicate;
        final /* synthetic */ PredicateTree this$0;

        private Leaf(T t) {
            this.this$0 = var1_1;
            assert (t != null);
            this.mPredicate = t;
        }

        @Override
        public INode<T> next(T t) {
            return null;
        }

        public String toString() {
            return this.mPredicate.toString();
        }
    }
}

