/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.BinaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiAccepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiIntersectNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiIsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LassoExtractor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiIntersectStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractBuchiDifference<LETTER, STATE>
extends BinaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    protected final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mFstOperand;
    protected final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mSndOperand;
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mSndComplemented;
    protected BuchiIntersectNwa<LETTER, STATE> mIntersect;
    protected NestedWordAutomatonReachableStates<LETTER, STATE> mResult;

    public AbstractBuchiDifference(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2) {
        super(automataLibraryServices);
        this.mFstOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mSndOperand = iNwaOutgoingLetterAndTransitionProvider2;
    }

    protected <SF extends IBuchiIntersectStateFactory<STATE> & IEmptyStackStateFactory<STATE>> void constructDifferenceFromComplement(SF SF) throws AutomataLibraryException {
        this.mIntersect = new BuchiIntersectNwa<LETTER, STATE>(this.mFstOperand, this.getSndComplemented(), SF);
        this.mResult = new NestedWordAutomatonReachableStates<LETTER, STATE>(this.mServices, this.mIntersect);
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". First operand " + this.mFstOperand.sizeInformation() + ". Second operand " + this.mSndOperand.sizeInformation() + " Result " + this.mResult.sizeInformation() + " Complement of second has " + this.getSndComplemented().size() + " states.";
    }

    @Override
    public final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getFirstOperand() {
        return this.mFstOperand;
    }

    @Override
    public final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getSecondOperand() {
        return this.mSndOperand;
    }

    public final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getSndComplemented() {
        return this.mSndComplemented;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        BuchiIsEmpty<LETTER, STATE> buchiIsEmpty;
        boolean bl;
        BuchiIsEmpty<LETTER, STATE> buchiIsEmpty2;
        boolean bl2;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
        }
        ArrayList<NestedLassoWord<LETTER>> arrayList = new ArrayList<NestedLassoWord<LETTER>>();
        BuchiIsEmpty<LETTER, STATE> buchiIsEmpty3 = new BuchiIsEmpty<LETTER, STATE>(this.mServices, this.mFstOperand);
        boolean bl3 = buchiIsEmpty3.getResult();
        if (!bl3) {
            arrayList.add(buchiIsEmpty3.getAcceptingNestedLassoRun().getNestedLassoWord());
        }
        if (!(bl2 = (buchiIsEmpty2 = new BuchiIsEmpty<LETTER, STATE>(this.mServices, this.mSndOperand)).getResult().booleanValue())) {
            arrayList.add(buchiIsEmpty2.getAcceptingNestedLassoRun().getNestedLassoWord());
        }
        if (!(bl = (buchiIsEmpty = new BuchiIsEmpty<LETTER, STATE>(this.mServices, this.mResult)).getResult().booleanValue())) {
            arrayList.add(buchiIsEmpty.getAcceptingNestedLassoRun().getNestedLassoWord());
        }
        boolean bl4 = true;
        assert (bl4 &= !bl3 || bl);
        arrayList.add(NestedWordAutomataUtils.getRandomNestedLassoWord(this.mResult, this.mResult.size(), 0L));
        arrayList.add(NestedWordAutomataUtils.getRandomNestedLassoWord(this.mResult, this.mFstOperand.size(), 1L));
        arrayList.add(NestedWordAutomataUtils.getRandomNestedLassoWord(this.mResult, this.mSndOperand.size(), 2L));
        arrayList.addAll((Collection<NestedLassoWord<LETTER>>)new LassoExtractor<LETTER, STATE>(this.mServices, this.mFstOperand).getResult());
        arrayList.addAll((Collection<NestedLassoWord<LETTER>>)new LassoExtractor<LETTER, STATE>(this.mServices, this.mSndOperand).getResult());
        arrayList.addAll((Collection<NestedLassoWord<LETTER>>)new LassoExtractor<LETTER, STATE>(this.mServices, this.mResult).getResult());
        for (NestedLassoWord nestedLassoWord : arrayList) {
            assert (bl4 &= this.checkAcceptance(nestedLassoWord, this.mFstOperand, this.mSndOperand, false));
        }
        if (!bl4) {
            AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", "language is different", this.mFstOperand, this.mSndOperand);
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
        return bl4;
    }

    private boolean checkAcceptance(NestedLassoWord<LETTER> nestedLassoWord, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2, boolean bl) throws AutomataLibraryException {
        boolean bl2;
        boolean bl3 = new BuchiAccepts<LETTER, STATE>(this.mServices, iNwaOutgoingLetterAndTransitionProvider, nestedLassoWord).getResult();
        boolean bl4 = new BuchiAccepts<LETTER, STATE>(this.mServices, iNwaOutgoingLetterAndTransitionProvider2, nestedLassoWord).getResult();
        boolean bl5 = new BuchiAccepts<LETTER, STATE>(this.mServices, this.mResult, nestedLassoWord).getResult();
        if (bl5) {
            bl2 = bl3 && !bl4;
        } else {
            boolean bl6 = bl2 = bl || !bl3 || bl4;
        }
        assert (bl2) : this.getOperationName() + " wrong result!";
        return bl2;
    }
}

