/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.LoopStatement;
import java.util.List;
import java.util.function.Predicate;

public final class LoopVariant
extends LoopStatement {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(LoopVariant.class);
    Expression formula;
    String identifier;

    public LoopVariant(Expression expression) {
        this.formula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid LoopVariant: " + String.valueOf(this);
    }

    public LoopVariant(Expression expression, String string) {
        this.formula = expression;
        this.identifier = string;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid LoopVariant: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LoopVariant").append('[');
        stringBuffer.append(this.formula);
        stringBuffer.append(',').append(this.identifier);
        return stringBuffer.append(']').toString();
    }

    public Expression getFormula() {
        return this.formula;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.formula);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((LoopStatement)this)) {
            return;
        }
        if (aCSLVisitor.visit(this) && this.formula != null) {
            this.formula.accept(aCSLVisitor);
        }
    }

    @Override
    public LoopStatement accept(ACSLTransformer aCSLTransformer) {
        LoopStatement loopStatement = aCSLTransformer.transform(this);
        if (loopStatement != this) {
            return loopStatement;
        }
        Expression expression = null;
        if (this.formula != null) {
            expression = this.formula.accept(aCSLTransformer);
        }
        if (this.formula != expression) {
            return new LoopVariant(expression, this.identifier);
        }
        return this;
    }
}

