/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.List;
import java.util.function.Predicate;

public final class RequiresSpecification
extends Specification {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(RequiresSpecification.class);
    Expression formula;

    public RequiresSpecification(ILocation iLocation, boolean bl, Expression expression) {
        super(iLocation, bl);
        this.formula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid RequiresSpecification: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RequiresSpecification").append('[');
        stringBuffer.append((Object)this.formula);
        return stringBuffer.append(']').toString();
    }

    public Expression getFormula() {
        return this.formula;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        list.add(this.formula);
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Specification)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this) && this.formula != null) {
            this.formula.accept(generatedBoogieAstVisitor);
        }
    }

    @Override
    public Specification accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Specification specification = generatedBoogieAstTransformer.transform(this);
        if (specification != this) {
            return specification;
        }
        Expression expression = null;
        if (this.formula != null) {
            expression = this.formula.accept(generatedBoogieAstTransformer);
        }
        if (this.formula != expression) {
            return new RequiresSpecification(this.loc, this.isFree, expression);
        }
        return this;
    }
}

