/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.icfgtochc.concurrent;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgPetrifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ThreadInstance;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.IInitialAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.PetriInitialAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.PetriLbeInitialAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.IndependenceSettings;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.petrinetlbe.IcfgCompositionFactory;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.petrinetlbe.PetriNetLargeBlockEncoding;
import de.uni_freiburg.informatik.ultimate.plugins.icfgtochc.IcfgToChcObserver;
import de.uni_freiburg.informatik.ultimate.plugins.icfgtochc.concurrent.IcfgToChcConcurrent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ChcProviderConcurrentWithLbe
implements IcfgToChcObserver.IChcProvider {
    private final ManagedScript mMgdScript;
    private final HcSymbolTable mHcSymbolTable;
    private final IUltimateServiceProvider mServices;
    private static final int MAXIMUM_NUMBER_OF_THREADS = 2;

    public ChcProviderConcurrentWithLbe(ManagedScript managedScript, HcSymbolTable hcSymbolTable, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mMgdScript = managedScript;
        this.mHcSymbolTable = hcSymbolTable;
        this.mServices = iUltimateServiceProvider;
    }

    @Override
    public Collection<HornClause> getHornClauses(IIcfg<IcfgLocation> iIcfg) {
        Object object;
        Map.Entry entry2;
        IIcfg iIcfg2 = new IcfgPetrifier(this.mServices, iIcfg, 2, false).getPetrifiedIcfg();
        Map<String, Integer> map = iIcfg2.getInitialNodes().stream().collect(Collectors.toMap(IcfgLocation::getProcedure, icfgLocation -> 1));
        HashSet<Object> hashSet = new HashSet<Object>();
        Set set = IcfgUtils.getForksInLoop((IIcfg)iIcfg2);
        Map map2 = iIcfg2.getCfgSmtToolkit().getConcurrencyInformation().getThreadInstanceMap();
        for (Map.Entry entry2 : map2.entrySet()) {
            object = ((ThreadInstance)((List)entry2.getValue()).get(0)).getThreadInstanceName();
            if (set.contains(entry2.getKey())) {
                map.put((String)object, 2);
                hashSet.add(object);
                continue;
            }
            map.put((String)object, 1);
        }
        entry2 = ChcProviderConcurrentWithLbe.getPetriNetWithLbe((IIcfg<IcfgLocation>)iIcfg2, this.mServices);
        ArrayList arrayList = new ArrayList();
        object = ChcProviderConcurrentWithLbe.getLocations(entry2.getAcceptingPlaces()).stream().filter(icfgLocation -> map.containsKey(icfgLocation.getProcedure())).collect(Collectors.toList());
        IcfgToChcConcurrent icfgToChcConcurrent = new IcfgToChcConcurrent(map, this.mMgdScript, iIcfg2.getCfgSmtToolkit(), this.mHcSymbolTable, iProgramVar -> true);
        arrayList.add(icfgToChcConcurrent.getInitialClause(ChcProviderConcurrentWithLbe.getLocations(entry2.getInitialPlaces())));
        arrayList.addAll(icfgToChcConcurrent.getSafetyClauses((Collection<IcfgLocation>)object));
        for (Transition transition : entry2.getTransitions()) {
            IcfgEdge icfgEdge = (IcfgEdge)transition.getSymbol();
            String string = icfgEdge.getPrecedingProcedure();
            if (!map.containsKey(string) || !map.containsKey(icfgEdge.getSucceedingProcedure())) continue;
            List<IcfgLocation> list = ChcProviderConcurrentWithLbe.getLocations((Collection<IPredicate>)transition.getPredecessors());
            List<IcfgLocation> list2 = ChcProviderConcurrentWithLbe.getLocations((Collection<IPredicate>)transition.getSuccessors());
            arrayList.addAll(icfgToChcConcurrent.getInductivityClauses(list, (IIcfgTransition<?>)icfgEdge, list2));
            if (!hashSet.contains(string)) continue;
            arrayList.add(icfgToChcConcurrent.getNonInterferenceClause((IIcfgTransition<?>)icfgEdge));
        }
        return arrayList;
    }

    private static List<IcfgLocation> getLocations(Collection<IPredicate> collection) {
        ArrayList<IcfgLocation> arrayList = new ArrayList<IcfgLocation>();
        for (IPredicate iPredicate : collection) {
            if (!(iPredicate instanceof ISLPredicate)) continue;
            arrayList.add(((ISLPredicate)iPredicate).getProgramPoint());
        }
        return arrayList;
    }

    private static BoundedPetriNet<IcfgEdge, IPredicate> getPetriNetWithLbe(IIcfg<IcfgLocation> iIcfg, IUltimateServiceProvider iUltimateServiceProvider) {
        CfgSmtToolkit cfgSmtToolkit = iIcfg.getCfgSmtToolkit();
        PredicateFactory predicateFactory = new PredicateFactory(iUltimateServiceProvider, cfgSmtToolkit.getManagedScript(), cfgSmtToolkit.getSymbolTable());
        PetriInitialAbstractionProvider petriInitialAbstractionProvider = new PetriInitialAbstractionProvider(iUltimateServiceProvider, predicateFactory, true);
        PetriLbeInitialAbstractionProvider petriLbeInitialAbstractionProvider = new PetriLbeInitialAbstractionProvider(iUltimateServiceProvider, (IInitialAbstractionProvider)petriInitialAbstractionProvider, IcfgEdge.class, new IndependenceSettings(), (PetriNetLargeBlockEncoding.IPLBECompositionFactory)new IcfgCompositionFactory(iUltimateServiceProvider, cfgSmtToolkit));
        HashSet hashSet = new HashSet(iIcfg.getCfgSmtToolkit().getConcurrencyInformation().getInUseErrorNodeMap().values());
        Set set = iIcfg.getProcedureErrorNodes().values().stream().flatMap(Collection::stream).filter(icfgLocation -> !hashSet.contains(icfgLocation)).collect(Collectors.toSet());
        try {
            return petriLbeInitialAbstractionProvider.getInitialAbstraction(iIcfg, set);
        }
        catch (AutomataLibraryException automataLibraryException) {
            throw new AssertionError((Object)automataLibraryException);
        }
    }
}

