/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.util;

import de.uni_freiburg.informatik.ultimate.automata.util.ISetOfPairs;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionAndMapBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class PartitionBackedSetOfPairs<E>
implements ISetOfPairs<E, Collection<Set<E>>> {
    protected final Collection<Set<E>> mPartition;
    private PartitionSizeInformation mPartitionSizeInformation;

    public PartitionBackedSetOfPairs(Collection<Set<E>> collection) {
        this.mPartition = collection;
    }

    @Override
    public Iterator<Pair<E, E>> iterator() {
        Iterator<Set<E>> iterator = this.mPartition.iterator();
        if (iterator.hasNext()) {
            return new IteratorFromPartition<E>(iterator);
        }
        return Collections.emptyIterator();
    }

    @Override
    public void addPair(E e, E e2) {
        throw new UnsupportedOperationException("The partition must be specified at construction time.");
    }

    @Override
    public boolean containsPair(E e, E e2) {
        throw new UnsupportedOperationException("This class does not support a contains() method. Use the " + PartitionAndMapBackedSetOfPairs.class.getSimpleName() + " class instead.");
    }

    @Override
    public Collection<Set<E>> getRelation() {
        return this.mPartition;
    }

    public PartitionSizeInformation getOrConstructPartitionSizeInformation() {
        if (this.mPartitionSizeInformation == null) {
            this.mPartitionSizeInformation = new PartitionSizeInformation(this.mPartition);
        }
        return this.mPartitionSizeInformation;
    }

    public String toString() {
        return this.mPartition.toString();
    }

    static final class IteratorFromPartition<E>
    implements Iterator<Pair<E, E>> {
        private final Iterator<Set<E>> mBlockIt;
        private Iterator<E> mElemLhsIt;
        private Iterator<E> mElemRhsIt;
        private Iterable<E> mBlock;
        private E mElemLhs;

        public IteratorFromPartition(Iterator<Set<E>> iterator) {
            this.mBlockIt = iterator;
            this.advanceToNextBlock();
        }

        @Override
        public boolean hasNext() {
            if (this.mElemRhsIt.hasNext()) {
                return true;
            }
            if (this.mElemLhsIt.hasNext()) {
                this.mElemLhs = this.mElemLhsIt.next();
                this.mElemRhsIt = this.mBlock.iterator();
                return true;
            }
            if (this.mBlockIt.hasNext()) {
                this.advanceToNextBlock();
                return true;
            }
            return false;
        }

        @Override
        public Pair<E, E> next() {
            E e = this.mElemRhsIt.next();
            return new Pair(this.mElemLhs, e);
        }

        private void advanceToNextBlock() {
            this.mBlock = this.mBlockIt.next();
            this.mElemLhsIt = this.mBlock.iterator();
            if (this.mElemLhsIt.hasNext()) {
                this.mElemLhs = this.mElemLhsIt.next();
            }
            this.mElemRhsIt = this.mBlock.iterator();
        }
    }

    public static class PartitionSizeInformation {
        private long mNumberOfPairs;
        private int mSizeOfLargestBlock;
        private final int mNumberOfBlocks;

        public PartitionSizeInformation(Collection<? extends Set<?>> collection) {
            this.mNumberOfBlocks = collection.size();
            for (Set<?> set : collection) {
                this.mSizeOfLargestBlock = Math.max(this.mSizeOfLargestBlock, set.size());
                this.mNumberOfPairs += (long)set.size() * (long)set.size() - (long)set.size();
            }
        }

        public long getNumberOfPairs() {
            return this.mNumberOfPairs;
        }

        public int getSizeOfLargestBlock() {
            return this.mSizeOfLargestBlock;
        }

        public int getNumberOfBlocks() {
            return this.mNumberOfBlocks;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getNumberOfPairs()).append(" pairs, ").append(this.getNumberOfBlocks()).append(" blocks, ").append("largest block has ").append(this.getSizeOfLargestBlock()).append(" elements");
            return stringBuilder.toString();
        }
    }
}

