/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Parameter;
import java.util.List;
import java.util.function.Predicate;

public final class ModelVariable
extends ACSLNode {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(ModelVariable.class);
    ACSLType type;
    Parameter parameter;

    public ModelVariable(ACSLType aCSLType) {
        this.type = aCSLType;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid ModelVariable: " + String.valueOf(this);
    }

    public ModelVariable(ACSLType aCSLType, Parameter parameter) {
        this.type = aCSLType;
        this.parameter = parameter;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid ModelVariable: " + String.valueOf(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ModelVariable").append('[');
        stringBuffer.append(this.type);
        stringBuffer.append(',').append(this.parameter);
        return stringBuffer.append(']').toString();
    }

    public ACSLType getType() {
        return this.type;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.type);
        list.add(this.parameter);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (aCSLVisitor.visit(this)) {
            if (this.type != null) {
                this.type.accept(aCSLVisitor);
            }
            if (this.parameter != null) {
                this.parameter.accept(aCSLVisitor);
            }
        }
    }

    @Override
    public ModelVariable accept(ACSLTransformer aCSLTransformer) {
        ModelVariable modelVariable = aCSLTransformer.transform(this);
        if (modelVariable != this) {
            return modelVariable;
        }
        ACSLType aCSLType = null;
        if (this.type != null) {
            aCSLType = this.type.accept(aCSLTransformer);
        }
        Parameter parameter = null;
        if (this.parameter != null) {
            parameter = this.parameter.accept(aCSLTransformer);
        }
        if (this.type != aCSLType || this.parameter != parameter) {
            return new ModelVariable(aCSLType, parameter);
        }
        return this;
    }
}

