/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.observers;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IWalkable;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.RootEdge;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class DebugFileWriterNutz {
    private final ILogger mLogger;
    private final List<List<IcfgEdge>> mPaths;
    private final int mUnrollingDepth;
    private static final String sFolderPath = "F:\\repos\\ultimate fresher co\\trunk\\examples\\unrolling-tests\\";

    public DebugFileWriterNutz(List<List<IcfgEdge>> list, ILogger iLogger, int n) {
        this.mLogger = iLogger;
        if (list == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        this.mUnrollingDepth = n;
        this.mPaths = list;
    }

    public void run() {
        HashMap<RootEdge, ArrayList<ArrayList<CodeBlock>>> hashMap = new HashMap<RootEdge, ArrayList<ArrayList<CodeBlock>>>();
        for (List<IcfgEdge> list : this.mPaths) {
            IWalkable iWalkable;
            if (list.isEmpty() || !((iWalkable = (IWalkable)list.get(0)) instanceof RootEdge)) continue;
            RootEdge rootEdge = (RootEdge)iWalkable;
            if (!hashMap.containsKey(rootEdge)) {
                hashMap.put(rootEdge, new ArrayList());
            }
            ArrayList<CodeBlock> arrayList = new ArrayList<CodeBlock>();
            int n = 1;
            while (n < list.size()) {
                arrayList.add((CodeBlock)list.get(n));
                ++n;
            }
            hashMap.get(rootEdge).add(arrayList);
        }
        this.prepareTraces(this.mUnrollingDepth, hashMap);
    }

    private void prepareTraces(int n, HashMap<RootEdge, ArrayList<ArrayList<CodeBlock>>> hashMap) {
        Object object;
        this.mLogger.debug((Object)"Sorting all traces of each procedure...");
        HashMap hashMap2 = new HashMap();
        for (Map.Entry<RootEdge, ArrayList<ArrayList<CodeBlock>>> entry : hashMap.entrySet()) {
            object = new TreeSet<CallSite>();
            for (ArrayList<CodeBlock> arrayList : entry.getValue()) {
                String string = this.traceToString(arrayList);
                ((TreeSet)object).add("--------\n" + string);
            }
            hashMap2.put(entry.getKey(), object);
        }
        this.mLogger.debug((Object)"Writing all traces of Main to file...");
        try {
            for (Map.Entry<Object, ArrayList<ArrayList<Object>>> entry : hashMap2.entrySet()) {
                object = Paths.get(ILocation.getAnnotation((IElement)((RootEdge)entry.getKey()).getTarget()).getFileName(), new String[0]).getFileName().toString();
                String string = ((IcfgLocation)((RootEdge)entry.getKey()).getTarget()).getProcedure();
                String string2 = "dd_rcfgTraces_" + (String)object + "_" + string + "__dfs__n_is_" + n + "_.txt";
                this.writeLargerTextFile(sFolderPath + (String)string2, (TreeSet)((Object)entry.getValue()));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String traceToString(ArrayList<CodeBlock> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (CodeBlock codeBlock : arrayList) {
            stringBuilder.append(codeBlock.getPrettyPrintedStatements());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private void writeLargerTextFile(String string, TreeSet<String> treeSet) throws IOException {
        Path path = Paths.get(string, new String[0]);
        this.mLogger.debug((Object)("Writing " + path.toString()));
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (String string2 : treeSet) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

