/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import java.math.BigInteger;

public final class SmtSortUtils {
    public static final String ARRAY_SORT = "Array";
    public static final String BOOL_SORT = "Bool";
    public static final String INT_SORT = "Int";
    public static final String REAL_SORT = "Real";
    public static final String BITVECTOR_SORT = "BitVec";
    public static final String FLOATINGPOINT_SORT = "FloatingPoint";
    public static final String ROUNDINGMODE_SORT = "RoundingMode";

    private SmtSortUtils() {
    }

    public static boolean isBoolSort(Sort sort) {
        return BOOL_SORT.equals(sort.getRealSort().getName());
    }

    public static Sort getBoolSort(Script script) {
        return script.sort(BOOL_SORT, new Sort[0]);
    }

    public static Sort getBoolSort(ManagedScript managedScript) {
        return SmtSortUtils.getBoolSort(managedScript.getScript());
    }

    public static boolean isIntSort(Sort sort) {
        return INT_SORT.equals(sort.getRealSort().getName());
    }

    public static Sort getIntSort(Script script) {
        return script.sort(INT_SORT, new Sort[0]);
    }

    public static Sort getIntSort(ManagedScript managedScript) {
        return SmtSortUtils.getIntSort(managedScript.getScript());
    }

    public static boolean isRealSort(Sort sort) {
        return REAL_SORT.equals(sort.getRealSort().getName());
    }

    public static boolean isNumericSort(Sort sort) {
        return sort.getRealSort().isNumericSort();
    }

    public static boolean isArraySort(Sort sort) {
        return sort.getRealSort().isArraySort();
    }

    public static boolean isBitvecSort(Sort sort) {
        return BITVECTOR_SORT.equals(sort.getRealSort().getName());
    }

    public static boolean isFloatingpointSort(Sort sort) {
        return FLOATINGPOINT_SORT.equals(sort.getRealSort().getName());
    }

    public static boolean isRoundingmodeSort(Sort sort) {
        return ROUNDINGMODE_SORT.equals(sort.getRealSort().getName());
    }

    public static Sort getRoundingmodeSort(Script script) {
        return script.sort(ROUNDINGMODE_SORT, new Sort[0]);
    }

    public static Sort getRoundingmodeSort(ManagedScript managedScript) {
        return SmtSortUtils.getIntSort(managedScript.getScript());
    }

    public static Sort getRealSort(Script script) {
        return script.sort(REAL_SORT, new Sort[0]);
    }

    public static Sort getFloatSort(Script script, BigInteger bigInteger, BigInteger bigInteger2) {
        return script.sort(FLOATINGPOINT_SORT, new String[]{bigInteger.toString(), bigInteger2.toString()}, new Sort[0]);
    }

    public static Sort getBitvectorSort(Script script, int n) {
        return SmtSortUtils.getBitvectorSort(script, BigInteger.valueOf(n));
    }

    public static int getBitvectorLength(Sort sort) {
        if (!SmtSortUtils.isBitvecSort(sort)) {
            return -1;
        }
        return Integer.parseInt(sort.getIndices()[0]);
    }

    public static Sort getBitvectorSort(Script script, BigInteger bigInteger) {
        return script.sort(BITVECTOR_SORT, new String[]{bigInteger.toString()}, new Sort[0]);
    }

    public static Sort getArraySort(Script script, Sort sort, Sort sort2) {
        return script.sort(ARRAY_SORT, new Sort[]{sort, sort2});
    }

    public static Sort getNamedSort(Script script, String string) {
        return script.sort(string, new Sort[0]);
    }

    public static Sort getBuiltinSort(Script script, String string, String[] stringArray) {
        return script.sort(string, stringArray, new Sort[0]);
    }

    public static Sort getRealSort(ManagedScript managedScript) {
        return SmtSortUtils.getRealSort(managedScript.getScript());
    }
}

