/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StatementSequence
extends CodeBlock
implements IIcfgInternalTransition<IcfgLocation> {
    private static final long serialVersionUID = -1780068525981157749L;
    private static final boolean ADD_SERIAL_NUMBER_IN_TO_STRING_REPRESENTATION = false;
    private final List<Statement> mStatements = new ArrayList<Statement>();
    private String mPrettyPrintedStatements;

    StatementSequence(int n, BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, Statement statement, ILogger iLogger) {
        this(n, boogieIcfgLocation, boogieIcfgLocation2, Collections.singletonList(statement), iLogger);
    }

    public StatementSequence(int n, BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, List<Statement> list, ILogger iLogger) {
        super(n, boogieIcfgLocation, boogieIcfgLocation2, iLogger);
        if (list != null && !list.isEmpty()) {
            list.forEach(this::addStatement);
        }
        this.mPrettyPrintedStatements = null;
    }

    public void addStatement(Statement statement) {
        this.addStatement(statement, -1);
    }

    public void addStatement(Statement statement, int n) {
        if (!(statement instanceof AssumeStatement || statement instanceof AssignmentStatement || statement instanceof HavocStatement || statement instanceof CallStatement)) {
            throw new IllegalArgumentException("Only Assignment, Assume and HavocStatement allowed in InternalEdge. Additionally CallStatements are allowed if the callee is a procedure without implementation and has an emtpy requires clause.");
        }
        if (n == -1) {
            this.mStatements.add(statement);
        } else {
            this.mStatements.add(n, statement);
        }
        this.mPrettyPrintedStatements = null;
    }

    @Visualizable
    public List<Statement> getStatements() {
        return this.mStatements;
    }

    @Override
    public String getPrettyPrintedStatements() {
        if (this.mPrettyPrintedStatements == null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Statement statement : this.mStatements) {
                stringBuilder.append(BoogiePrettyPrinter.print((Statement)statement));
            }
            this.mPrettyPrintedStatements = stringBuilder.toString();
        }
        return this.mPrettyPrintedStatements;
    }

    @Override
    public String toString() {
        return this.getPrettyPrintedStatements();
    }

    public boolean isTrivial() {
        if (this.mStatements.isEmpty()) {
            return true;
        }
        for (Statement statement : this.mStatements) {
            if (StatementSequence.isAssumeTrueStatement(statement)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssumeTrueStatement(Statement statement) {
        BooleanLiteral booleanLiteral;
        AssumeStatement assumeStatement;
        return statement instanceof AssumeStatement && (assumeStatement = (AssumeStatement)statement).getFormula() instanceof BooleanLiteral && (booleanLiteral = (BooleanLiteral)assumeStatement.getFormula()).getValue();
    }

    public void setPayload(IPayload iPayload) {
        this.mPayload = iPayload;
    }
}

