/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.Acc;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.AccBuchi;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.IBuchiWa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.IStateWa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.StateWa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.UtilIntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BuchiWa
implements IBuchiWa {
    private final IntSet mInitStates;
    private final IntSet mFinalStates;
    private final List<IStateWa> mStates;
    private final int mAlphabetSize;
    protected Acc acc;

    public BuchiWa(int n) {
        this.mAlphabetSize = n;
        this.mInitStates = UtilIntSet.newIntSet();
        this.mFinalStates = UtilIntSet.newIntSet();
        this.mStates = new ArrayList<IStateWa>();
    }

    @Override
    public int getAlphabetSize() {
        return this.mAlphabetSize;
    }

    @Override
    public IStateWa addState() {
        int n = this.mStates.size();
        this.mStates.add(this.makeState(n));
        return this.mStates.get(n);
    }

    @Override
    public IStateWa makeState(int n) {
        return new StateWa(n);
    }

    @Override
    public int addState(IStateWa iStateWa) {
        int n = this.mStates.size();
        this.mStates.add(iStateWa);
        return n;
    }

    @Override
    public IStateWa getState(int n) {
        assert (n < this.mStates.size());
        if (n < this.mStates.size()) {
            return this.mStates.get(n);
        }
        return null;
    }

    @Override
    public IntSet getInitialStates() {
        return this.mInitStates;
    }

    @Override
    public boolean isInitial(int n) {
        return this.mInitStates.get(n);
    }

    @Override
    public boolean isFinal(int n) {
        return this.mFinalStates.get(n);
    }

    @Override
    public void setInitial(int n) {
        this.mInitStates.set(n);
    }

    @Override
    public void setFinal(int n) {
        this.mFinalStates.set(n);
    }

    @Override
    public Collection<IStateWa> getStates() {
        return Collections.unmodifiableList(this.mStates);
    }

    @Override
    public IntSet getFinalStates() {
        return this.mFinalStates;
    }

    @Override
    public int getStateSize() {
        return this.mStates.size();
    }

    public String toString() {
        return this.toDot();
    }

    @Override
    public IntSet getSuccessors(int n, int n2) {
        return this.mStates.get(n).getSuccessors(n2);
    }

    @Override
    public Acc getAcceptance() {
        if (this.acc == null) {
            this.acc = new AccBuchi(this.mFinalStates);
        }
        return this.acc;
    }

    @Override
    public void makeComplete() {
        IStateWa iStateWa = this.addState();
        for (IStateWa iStateWa2 : this.mStates) {
            int n = 0;
            while (n < this.getAlphabetSize()) {
                IntSet intSet = iStateWa2.getSuccessors(n);
                if (intSet.cardinality() == 0) {
                    iStateWa2.addSuccessor(n, iStateWa.getId());
                }
                ++n;
            }
        }
    }
}

