/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders.DawgBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgStateFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReorderDawgBuilder<LETTER, VALUE, COLNAMES>
extends DawgBuilder<LETTER> {
    private final DawgStateFactory<LETTER> mDawgStateFactory;
    private final DawgFactory<LETTER, COLNAMES> mDawgFactory;
    private final Map<Pair<List<DawgLetter<LETTER>>, DawgState<LETTER, VALUE>>, DawgState<LETTER, VALUE>> mCache;
    private final Map<Set<DawgState<LETTER, VALUE>>, DawgState<LETTER, VALUE>> mUnionCache;

    public ReorderDawgBuilder(DawgFactory<LETTER, COLNAMES> dawgFactory) {
        this.mDawgFactory = dawgFactory;
        this.mDawgStateFactory = this.mDawgFactory.getDawgStateFactory();
        this.mCache = new HashMap<Pair<List<DawgLetter<LETTER>>, DawgState<LETTER, VALUE>>, DawgState<LETTER, VALUE>>();
        this.mUnionCache = new HashMap<Set<DawgState<LETTER, VALUE>>, DawgState<LETTER, VALUE>>();
    }

    private DawgState<LETTER, VALUE> addLettersInFront(List<DawgLetter<LETTER>> list, DawgState<LETTER, VALUE> dawgState) {
        int n = list.size() - 1;
        while (n >= 0) {
            DawgLetter<LETTER> dawgLetter = list.get(n);
            assert (!dawgLetter.isEmpty());
            dawgState = this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(dawgState, dawgLetter));
            --n;
        }
        return dawgState;
    }

    private DawgState<LETTER, VALUE> union(Set<DawgState<LETTER, VALUE>> set) {
        if (set.size() == 1) {
            return set.iterator().next();
        }
        DawgState<LETTER, VALUE> dawgState = this.mUnionCache.get(set);
        if (dawgState != null) {
            return dawgState;
        }
        Map map = new HashMap();
        Object object2 = set.iterator().next().getTransitions().values().iterator().next().getSortId();
        map.put(new HashSet(), this.mDawgFactory.getDawgLetterFactory().getUniversalDawgLetter(object2));
        for (DawgState<LETTER, VALUE> object3 : set) {
            for (Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> entry : object3.getTransitions().entrySet()) {
                map = this.merge(map, entry.getKey(), entry.getValue());
            }
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            if (((Set)entry.getKey()).isEmpty()) continue;
            DawgState<LETTER, VALUE> dawgState2 = this.union((Set)entry.getKey());
            ReorderDawgBuilder.addLetterToMap(hashMap, dawgState2, (DawgLetter)entry.getValue());
        }
        dawgState = this.mDawgStateFactory.createIntermediateState(hashMap);
        this.mUnionCache.put(set, dawgState);
        return dawgState;
    }

    private DawgState<LETTER, VALUE> internalReorder(List<DawgLetter<LETTER>> list, int n, int[] nArray, DawgState<LETTER, VALUE> dawgState, int n2) {
        Pair<List<DawgLetter<LETTER>>, DawgState<LETTER, VALUE>> pair = new Pair<List<DawgLetter<LETTER>>, DawgState<LETTER, VALUE>>(list.subList(n, list.size()), dawgState);
        DawgState<LETTER, VALUE> dawgState2 = this.mCache.get(pair);
        if (dawgState2 != null) {
            return dawgState2;
        }
        if (n2 == nArray.length) {
            dawgState2 = this.addLettersInFront(list.subList(n, list.size()), dawgState);
        } else {
            int n3 = nArray[n2];
            assert (n3 >= n);
            assert (list.get(n3) == null);
            int n4 = n;
            while (list.get(n4) != null) {
                ++n4;
            }
            if (n3 == n4) {
                HashMap hashMap = new HashMap();
                for (Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> entry : dawgState.getTransitions().entrySet()) {
                    DawgState<LETTER, VALUE> dawgState3 = this.internalReorder(list, n3 + 1, nArray, entry.getKey(), n2 + 1);
                    ReorderDawgBuilder.addLetterToMap(hashMap, dawgState3, entry.getValue());
                }
                dawgState2 = this.mDawgStateFactory.createIntermediateState(hashMap);
                dawgState2 = this.addLettersInFront(list.subList(n, n3), dawgState2);
            } else {
                HashSet<DawgState<LETTER, VALUE>> hashSet = new HashSet<DawgState<LETTER, VALUE>>();
                for (Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> entry : dawgState.getTransitions().entrySet()) {
                    list.set(n3, entry.getValue());
                    hashSet.add(this.internalReorder(list, n, nArray, entry.getKey(), n2 + 1));
                }
                list.set(n3, null);
                dawgState2 = this.union(hashSet);
            }
        }
        pair = new Pair<ArrayList<DawgLetter<LETTER>>, DawgState<LETTER, VALUE>>(new ArrayList<DawgLetter<LETTER>>(list.subList(n, list.size())), dawgState);
        this.mCache.put(pair, dawgState2);
        return dawgState2;
    }

    public final DawgState<LETTER, VALUE> reorder(DawgState<LETTER, VALUE> dawgState, List<DawgLetter<LETTER>> list, int[] nArray) {
        return this.internalReorder(new ArrayList<DawgLetter<LETTER>>(list), 0, nArray, dawgState, 0);
    }
}

