/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.xnf.Dnf;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.AbstractLinearInvariantPattern;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.AbstractTemplateIncreasingDimensionsStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.LinearPatternBase;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.LocationDependentLinearInequalityInvariantPatternStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DynamicPatternSettingsStrategy
extends LocationDependentLinearInequalityInvariantPatternStrategy {
    protected Map<IcfgLocation, Set<IProgramVar>> mLocations2LiveVariables;
    protected Map<IcfgLocation, PatternSetting> mLoc2PatternSetting;

    public DynamicPatternSettingsStrategy(AbstractTemplateIncreasingDimensionsStrategy abstractTemplateIncreasingDimensionsStrategy, int n, Set<IProgramVar> set, boolean bl, boolean bl2) {
        super(abstractTemplateIncreasingDimensionsStrategy, n, set, bl, bl2);
        this.mLocations2LiveVariables = new HashMap<IcfgLocation, Set<IProgramVar>>();
        this.mLoc2PatternSetting = new HashMap<IcfgLocation, PatternSetting>();
    }

    public DynamicPatternSettingsStrategy(AbstractTemplateIncreasingDimensionsStrategy abstractTemplateIncreasingDimensionsStrategy, int n, Set<IProgramVar> set, Map<IcfgLocation, Set<IProgramVar>> map, boolean bl, boolean bl2) {
        super(abstractTemplateIncreasingDimensionsStrategy, n, set, bl, bl2);
        this.mLocations2LiveVariables = map;
        if (map == null) {
            this.mLocations2LiveVariables = new HashMap<IcfgLocation, Set<IProgramVar>>();
        }
        this.mLoc2PatternSetting = new HashMap<IcfgLocation, PatternSetting>();
    }

    protected Set<IProgramVar> getPatternVariablesInitially(IcfgLocation icfgLocation) {
        if (this.mLocations2LiveVariables.containsKey(icfgLocation)) {
            return new HashSet<IProgramVar>((Collection)this.mLocations2LiveVariables.get(icfgLocation));
        }
        return new HashSet<IProgramVar>(this.mAllProgramVariables);
    }

    protected Dnf<AbstractLinearInvariantPattern> constructInvariantPatternForSetting(IcfgLocation icfgLocation, PatternSetting patternSetting, Script script, String string) {
        assert (this.mLoc2PatternCoefficents != null) : "Map mLoc2PatternCoefficents must not be null!";
        HashSet<Term> hashSet = new HashSet<Term>();
        Dnf dnf = new Dnf(patternSetting.mNumOfDisjuncts);
        int n = 0;
        while (n < patternSetting.mNumOfDisjuncts) {
            ArrayList<LinearPatternBase> arrayList = new ArrayList<LinearPatternBase>(patternSetting.mNumOfConjuncts);
            int n2 = 0;
            while (n2 < patternSetting.mNumOfConjuncts) {
                boolean[] blArray = new boolean[1];
                if (this.mUseStrictInequalitiesAlternatingly && n2 % 2 == 1) {
                    blArray = new boolean[]{true};
                }
                if (this.mAlwaysStrictAndNonStrictCopies) {
                    boolean[] blArray2 = new boolean[2];
                    blArray2[1] = true;
                    blArray = blArray2;
                }
                boolean[] blArray3 = blArray;
                int n3 = blArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    boolean bl = blArray3[n4];
                    LinearPatternBase linearPatternBase = new LinearPatternBase(script, patternSetting.getPatternVariables(), string + "_" + this.newPrefix(), bl);
                    arrayList.add(linearPatternBase);
                    hashSet.addAll(linearPatternBase.getCoefficients());
                    ++n4;
                }
                ++n2;
            }
            dnf.add(arrayList);
            ++n;
        }
        this.mLoc2PatternCoefficents.put(icfgLocation, hashSet);
        return dnf;
    }

    @Override
    public Dnf<AbstractLinearInvariantPattern> getInvariantPatternForLocation(IcfgLocation icfgLocation, int n, Script script, String string) {
        PatternSetting patternSetting;
        if (!this.mLoc2PatternSetting.containsKey(icfgLocation)) {
            Set<IProgramVar> set = this.getPatternVariablesInitially(icfgLocation);
            patternSetting = new PatternSetting(this.mDimensionsStrategy.getInitialDisjuncts(), this.mDimensionsStrategy.getInitialConjuncts(), set);
            this.mLoc2PatternSetting.put(icfgLocation, patternSetting);
        } else {
            patternSetting = this.mLoc2PatternSetting.get(icfgLocation);
        }
        return this.constructInvariantPatternForSetting(icfgLocation, patternSetting, script, string);
    }

    @Override
    public Dnf<AbstractLinearInvariantPattern> getInvariantPatternForLocation(IcfgLocation icfgLocation, int n, Script script, String string, Set<IProgramVar> set) {
        PatternSetting patternSetting;
        if (!this.mLoc2PatternSetting.containsKey(icfgLocation)) {
            Set<IProgramVar> set2 = this.getPatternVariablesInitially(icfgLocation);
            if (!set.isEmpty() && set2.containsAll(set)) {
                set2.retainAll(set);
            }
            int[] nArray = this.mDimensionsStrategy.getDimensions(icfgLocation, n);
            patternSetting = new PatternSetting(nArray[0], nArray[1], set2);
            this.mLoc2PatternSetting.put(icfgLocation, patternSetting);
        } else {
            patternSetting = this.mLoc2PatternSetting.get(icfgLocation);
            if (patternSetting.getPatternVariables().containsAll(set)) {
                patternSetting.getPatternVariables().retainAll(set);
            }
            if (this.mLocations2LiveVariables.containsKey(icfgLocation)) {
                Set<IProgramVar> set3 = this.mLocations2LiveVariables.get(icfgLocation);
                for (IProgramVar iProgramVar : set) {
                    if (!set3.contains(iProgramVar)) continue;
                    patternSetting.getPatternVariables().add(iProgramVar);
                }
            } else {
                patternSetting.getPatternVariables().addAll(set);
            }
        }
        return this.constructInvariantPatternForSetting(icfgLocation, patternSetting, script, string);
    }

    @Override
    public Set<IProgramVar> getPatternVariablesForLocation(IcfgLocation icfgLocation, int n) {
        if (this.mLoc2PatternSetting.containsKey(icfgLocation)) {
            return this.mLoc2PatternSetting.get(icfgLocation).getPatternVariables();
        }
        throw new UnsupportedOperationException("There is no pattern setting for the given location: " + String.valueOf(icfgLocation));
    }

    @Override
    public void changePatternSettingForLocation(IcfgLocation icfgLocation, int n) {
        if (this.mLoc2PatternSetting.containsKey(icfgLocation)) {
            this.mLoc2PatternSetting.get(icfgLocation).changeSetting(icfgLocation, n);
        }
    }

    @Override
    public void changePatternSettingForLocation(IcfgLocation icfgLocation, int n, Set<IcfgLocation> set) {
        this.changePatternSettingForLocation(icfgLocation, n);
    }

    class PatternSetting {
        private int mNumOfConjuncts;
        private int mNumOfDisjuncts;
        private final Set<IProgramVar> mPatternVariables;

        public PatternSetting(int n, int n2, Set<IProgramVar> set) {
            this.mNumOfConjuncts = n2;
            this.mNumOfDisjuncts = n;
            this.mPatternVariables = new HashSet<IProgramVar>(set);
        }

        public Set<IProgramVar> getPatternVariables() {
            return this.mPatternVariables;
        }

        public void changeSetting(IcfgLocation icfgLocation, int n) {
            int[] nArray = DynamicPatternSettingsStrategy.this.mDimensionsStrategy.getDimensions(icfgLocation, n + 1);
            this.mNumOfDisjuncts = nArray[0];
            this.mNumOfConjuncts = nArray[1];
        }

        public int getNumOfDisjuncts() {
            return this.mNumOfDisjuncts;
        }

        public int getNumOfConjuncts() {
            return this.mNumOfConjuncts;
        }
    }
}

