/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.ModelCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.SifaStats;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;

public class SymbolicTools {
    private final IIcfg<IcfgLocation> mIcfg;
    private final ManagedScript mMngdScript;
    private final BasicPredicateFactory mFactory;
    private final PredicateTransformer<Term, IPredicate, TransFormula> mTransformer;
    private final IPredicate mTop;
    private final IPredicate mBottom;
    private final SmtUtils.SimplificationTechnique mSimplification;
    private final IUltimateServiceProvider mServices;
    private final ILogger mPQELogger;
    private final SifaStats mStats;

    public SymbolicTools(IUltimateServiceProvider iUltimateServiceProvider, SifaStats sifaStats, IIcfg<IcfgLocation> iIcfg, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mServices = iUltimateServiceProvider;
        this.mStats = sifaStats;
        this.mIcfg = iIcfg;
        this.mPQELogger = iUltimateServiceProvider.getLoggingService().getLogger(this.getClass().getName() + ".PQE");
        this.mPQELogger.setLevel(ILogger.LogLevel.WARN);
        this.mServices.getLoggingService().setLogLevel(ModelCheckerUtils.PLUGIN_ID, ILogger.LogLevel.WARN);
        this.mSimplification = simplificationTechnique;
        this.mMngdScript = iIcfg.getCfgSmtToolkit().getManagedScript();
        Script script = this.mMngdScript.getScript();
        this.mFactory = new BasicPredicateFactory(iUltimateServiceProvider, this.mMngdScript, iIcfg.getCfgSmtToolkit().getSymbolTable());
        this.mTransformer = new PredicateTransformer(this.mMngdScript, (IDomainSpecificOperationProvider)new TermDomainOperationProviderWithLightElimination(iUltimateServiceProvider, this.mMngdScript));
        this.mTop = this.mFactory.newPredicate(script.term("true", new Term[0]));
        this.mBottom = this.mFactory.newPredicate(script.term("false", new Term[0]));
    }

    public ManagedScript getManagedScript() {
        return this.mMngdScript;
    }

    public Script getScript() {
        return this.mMngdScript.getScript();
    }

    public BasicPredicateFactory getFactory() {
        return this.mFactory;
    }

    public IPredicate post(IPredicate iPredicate, IIcfgTransition<IcfgLocation> iIcfgTransition) {
        this.mStats.start(SifaStats.Key.TOOLS_POST_TIME);
        this.mStats.increment(SifaStats.Key.TOOLS_POST_APPLICATIONS);
        IPredicate iPredicate2 = this.predicate((Term)this.mTransformer.strongestPostcondition((IAbstractPredicate)iPredicate, (ITransitionRelation)iIcfgTransition.getTransformula()));
        this.mStats.stop(SifaStats.Key.TOOLS_POST_TIME);
        return iPredicate2;
    }

    public IPredicate postCall(IPredicate iPredicate, IIcfgCallTransition<IcfgLocation> iIcfgCallTransition) {
        this.mStats.start(SifaStats.Key.TOOLS_POST_CALL_TIME);
        this.mStats.increment(SifaStats.Key.TOOLS_POST_CALL_APPLICATIONS);
        CfgSmtToolkit cfgSmtToolkit = this.mIcfg.getCfgSmtToolkit();
        String string = iIcfgCallTransition.getSucceedingProcedure();
        Term term = (Term)this.mTransformer.strongestPostconditionCall((IAbstractPredicate)iPredicate, (ITransitionRelation)iIcfgCallTransition.getLocalVarsAssignment(), (ITransitionRelation)cfgSmtToolkit.getOldVarsAssignmentCache().getGlobalVarsAssignment(string), (ITransitionRelation)cfgSmtToolkit.getOldVarsAssignmentCache().getOldVarsAssignment(string), cfgSmtToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(string));
        this.mStats.stop(SifaStats.Key.TOOLS_POST_CALL_TIME);
        return this.predicate(term);
    }

    public IPredicate postReturn(IPredicate iPredicate, IPredicate iPredicate2, IIcfgReturnTransition<IcfgLocation, IIcfgCallTransition<IcfgLocation>> iIcfgReturnTransition) {
        this.mStats.start(SifaStats.Key.TOOLS_POST_RETURN_TIME);
        this.mStats.increment(SifaStats.Key.TOOLS_POST_RETURN_APPLICATIONS);
        CfgSmtToolkit cfgSmtToolkit = this.mIcfg.getCfgSmtToolkit();
        String string = iIcfgReturnTransition.getPrecedingProcedure();
        IPredicate iPredicate3 = this.predicate((Term)this.mTransformer.strongestPostconditionReturn((IAbstractPredicate)iPredicate2, (IAbstractPredicate)iPredicate, (ITransitionRelation)iIcfgReturnTransition.getTransformula(), (ITransitionRelation)iIcfgReturnTransition.getCorrespondingCall().getTransformula(), (ITransitionRelation)cfgSmtToolkit.getOldVarsAssignmentCache().getOldVarsAssignment(string), cfgSmtToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(string)));
        this.mStats.stop(SifaStats.Key.TOOLS_POST_RETURN_TIME);
        return iPredicate3;
    }

    public Term[] dnfDisjuncts(IPredicate iPredicate, UnaryOperator<Term> unaryOperator) {
        Term term = SmtUtils.toDnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMngdScript, (Term)((Term)unaryOperator.apply(iPredicate.getFormula())));
        return SmtUtils.getDisjuncts((Term)term);
    }

    public Term[] dnfDisjuncts(IPredicate iPredicate) {
        return this.dnfDisjuncts(iPredicate, term -> term);
    }

    public IPredicate top() {
        return this.mTop;
    }

    public IPredicate bottom() {
        return this.mBottom;
    }

    public IPredicate predicate(Term term) {
        return this.mFactory.newPredicate(term);
    }

    public IPredicate or(IPredicate ... iPredicateArray) {
        return this.mFactory.or(this.mSimplification, iPredicateArray);
    }

    public IPredicate or(Collection<IPredicate> collection) {
        return this.mFactory.or(this.mSimplification, collection);
    }

    public IPredicate orT(Term ... termArray) {
        return this.mFactory.orT(this.mSimplification, termArray);
    }

    public IPredicate orT(Collection<Term> collection) {
        return this.mFactory.orT(this.mSimplification, collection);
    }

    public IPredicate and(IPredicate ... iPredicateArray) {
        return this.mFactory.and(this.mSimplification, iPredicateArray);
    }

    public IPredicate and(Collection<IPredicate> collection) {
        return this.mFactory.and(this.mSimplification, collection);
    }

    public IPredicate andT(Term ... termArray) {
        return this.mFactory.andT(this.mSimplification, termArray);
    }

    public IPredicate andT(Collection<Term> collection) {
        return this.mFactory.andT(this.mSimplification, collection);
    }

    public boolean isBottomLiteral(IPredicate iPredicate) {
        return this.mBottom == iPredicate;
    }

    public Optional<Boolean> isFalse(IPredicate iPredicate) {
        if (this.mBottom.equals(iPredicate)) {
            return Optional.of(Boolean.TRUE);
        }
        Script.LBool lBool = SmtUtils.checkSatTerm((Script)this.mMngdScript.getScript(), (Term)iPredicate.getClosedFormula());
        return SymbolicTools.satAsBool(lBool).map(bl -> bl == false);
    }

    public Optional<Boolean> implies(IPredicate iPredicate, IPredicate iPredicate2) {
        if (iPredicate.equals(iPredicate2)) {
            return Optional.of(Boolean.TRUE);
        }
        Script script = this.mMngdScript.getScript();
        Term term = SmtUtils.not((Script)script, (Term)SmtUtils.implies((Script)script, (Term)iPredicate.getClosedFormula(), (Term)iPredicate2.getClosedFormula()));
        Script.LBool lBool = SmtUtils.checkSatTerm((Script)script, (Term)term);
        return SymbolicTools.satAsBool(lBool).map(bl -> bl == false);
    }

    private static Optional<Boolean> satAsBool(Script.LBool lBool) {
        switch (lBool) {
            case SAT: {
                return Optional.of(Boolean.TRUE);
            }
            case UNSAT: {
                return Optional.of(Boolean.FALSE);
            }
            case UNKNOWN: {
                return Optional.empty();
            }
        }
        throw new AssertionError((Object)("Missing case: " + String.valueOf(lBool)));
    }

    private final class TermDomainOperationProviderWithLightElimination
    extends TermDomainOperationProvider {
        public TermDomainOperationProviderWithLightElimination(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
            super(iUltimateServiceProvider, managedScript);
        }

        public Term projectExistentially(Set<TermVariable> set, Term term) {
            return this.newQuantifier(0, set, term);
        }

        public Term projectUniversally(Set<TermVariable> set, Term term) {
            return this.newQuantifier(1, set, term);
        }

        private Term newQuantifier(int n, Set<TermVariable> set, Term term) {
            SymbolicTools.this.mStats.increment(SifaStats.Key.TOOLS_QUANTIFIERELIM_APPLICATIONS);
            SymbolicTools.this.mStats.startMax(SifaStats.Key.TOOLS_QUANTIFIERELIM_MAX_TIME);
            SymbolicTools.this.mStats.start(SifaStats.Key.TOOLS_QUANTIFIERELIM_TIME);
            Term term2 = SmtUtils.quantifier((Script)SymbolicTools.this.mMngdScript.getScript(), (int)n, set, (Term)term);
            Term term3 = PartialQuantifierElimination.eliminateLight((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (Term)term2);
            SymbolicTools.this.mStats.stop(SifaStats.Key.TOOLS_QUANTIFIERELIM_TIME);
            SymbolicTools.this.mStats.stopMax(SifaStats.Key.TOOLS_QUANTIFIERELIM_MAX_TIME);
            return term3;
        }
    }
}

