/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.util.typeutils;

import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieConstructedType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import java.util.function.Consumer;
import java.util.function.Function;

public final class TypeUtils {
    private static final Integer ITYPE_INT = -2;
    private static final Integer ITYPE_REAL = -3;
    private static final Integer ITYPE_BOOL = -1;

    private TypeUtils() {
    }

    public static <VARDECL> void consumeVariable(Consumer<VARDECL> consumer, Consumer<VARDECL> consumer2, Consumer<VARDECL> consumer3, VARDECL VARDECL) {
        assert (consumer3 == null);
        assert (VARDECL != null);
        TypeUtils.consumeVariablePerType(consumer, consumer2, consumer3, VARDECL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <VARDECL> void consumeVariablePerType(Consumer consumer, Consumer consumer2, Consumer consumer3, VARDECL VARDECL) {
        if (VARDECL instanceof IProgramVar) {
            IProgramVar iProgramVar = (IProgramVar)VARDECL;
            if (SmtSortUtils.isBoolSort((Sort)iProgramVar.getSort())) {
                consumer2.accept(VARDECL);
                return;
            } else if (SmtSortUtils.isNumericSort((Sort)iProgramVar.getSort())) {
                consumer.accept(VARDECL);
                return;
            } else {
                if (!SmtSortUtils.isArraySort((Sort)iProgramVar.getSort())) throw new UnsupportedOperationException("Not implemented: " + String.valueOf(iProgramVar.getSort()));
                consumer.accept(VARDECL);
            }
            return;
        } else {
            if (!(VARDECL instanceof IProgramVarOrConst)) throw new UnsupportedOperationException("Unknown variable type: " + VARDECL.getClass().getSimpleName());
            IProgramVarOrConst iProgramVarOrConst = (IProgramVarOrConst)VARDECL;
            Sort sort = iProgramVarOrConst.getTerm().getSort();
            if (SmtSortUtils.isBoolSort((Sort)sort)) {
                consumer2.accept(VARDECL);
                return;
            } else if (SmtSortUtils.isNumericSort((Sort)sort)) {
                consumer.accept(VARDECL);
                return;
            } else {
                if (!SmtSortUtils.isArraySort((Sort)sort)) throw new UnsupportedOperationException("Not implemented: " + String.valueOf(sort));
                consumer.accept(VARDECL);
            }
        }
    }

    public static <R, VARDECL> R applyVariableFunction(Function<VARDECL, R> function, Function<VARDECL, R> function2, Function<VARDECL, R> function3, VARDECL VARDECL) {
        assert (function3 == null);
        assert (VARDECL != null);
        return TypeUtils.applyVariableFunctionPerType(function, function2, function3, VARDECL);
    }

    private static <R, VARDECL> R applyVariableFunctionPerType(Function function, Function function2, Function function3, VARDECL VARDECL) {
        if (VARDECL instanceof IProgramVar) {
            IProgramVar iProgramVar = (IProgramVar)VARDECL;
            if (SmtSortUtils.isBoolSort((Sort)iProgramVar.getSort())) {
                return function2.apply(VARDECL);
            }
            if (SmtSortUtils.isNumericSort((Sort)iProgramVar.getSort())) {
                return function.apply(VARDECL);
            }
            if (SmtSortUtils.isArraySort((Sort)iProgramVar.getSort())) {
                return function.apply(VARDECL);
            }
            throw new UnsupportedOperationException("Not implemented: " + String.valueOf(iProgramVar.getSort()));
        }
        if (VARDECL instanceof IProgramVarOrConst) {
            IProgramVarOrConst iProgramVarOrConst = (IProgramVarOrConst)VARDECL;
            Sort sort = iProgramVarOrConst.getTerm().getSort();
            if (SmtSortUtils.isBoolSort((Sort)sort)) {
                return function2.apply(VARDECL);
            }
            if (SmtSortUtils.isNumericSort((Sort)sort)) {
                return function.apply(VARDECL);
            }
            if (SmtSortUtils.isArraySort((Sort)sort)) {
                return function.apply(VARDECL);
            }
            throw new UnsupportedOperationException("Not implemented: " + String.valueOf(sort));
        }
        throw new UnsupportedOperationException("Unknown variable type: " + VARDECL.getClass().getSimpleName());
    }

    public static <R> R applyTypeFunction(Function<Sort, R> function, Function<Sort, R> function2, Function<Sort, R> function3, Function<Sort, R> function4, Sort sort) {
        assert (sort != null);
        if (SmtSortUtils.isBoolSort((Sort)sort)) {
            assert (function3 != null);
            return function3.apply(sort);
        }
        if (SmtSortUtils.isRealSort((Sort)sort)) {
            assert (function2 != null);
            return function2.apply(sort);
        }
        if (SmtSortUtils.isNumericSort((Sort)sort)) {
            return function.apply(sort);
        }
        if (SmtSortUtils.isArraySort((Sort)sort)) {
            assert (function4 != null);
            return function4.apply(sort);
        }
        throw new UnsupportedOperationException("Not implemented: " + String.valueOf(sort));
    }

    public static <R> R applyTypeFunction(Function<IBoogieType, R> function, Function<IBoogieType, R> function2, Function<IBoogieType, R> function3, Function<IBoogieType, R> function4, IBoogieType iBoogieType) {
        assert (iBoogieType != null);
        if (iBoogieType instanceof BoogiePrimitiveType) {
            BoogiePrimitiveType boogiePrimitiveType = (BoogiePrimitiveType)iBoogieType;
            if (boogiePrimitiveType == BoogieType.TYPE_BOOL) {
                assert (function3 != null);
                return function3.apply(iBoogieType);
            }
            if (boogiePrimitiveType == BoogieType.TYPE_INT) {
                assert (function != null);
                return function.apply(iBoogieType);
            }
            if (boogiePrimitiveType == BoogieType.TYPE_REAL) {
                assert (function2 != null);
                return function2.apply(iBoogieType);
            }
            throw new IllegalArgumentException("Type error: " + boogiePrimitiveType.getClass().getSimpleName());
        }
        if (iBoogieType instanceof BoogieConstructedType) {
            BoogieConstructedType boogieConstructedType = (BoogieConstructedType)iBoogieType;
            if (boogieConstructedType.getUnderlyingType() instanceof BoogieConstructedType) {
                throw new UnsupportedOperationException("Nested constructed type found. No idea how to solve this.");
            }
            return TypeUtils.applyTypeFunction(function, function2, function3, function4, (IBoogieType)boogieConstructedType.getUnderlyingType());
        }
        if (iBoogieType instanceof BoogieArrayType) {
            assert (function4 != null);
            return function4.apply(iBoogieType);
        }
        throw new UnsupportedOperationException("Type not implemented: " + String.valueOf(iBoogieType.getClass()));
    }

    public static boolean isBoolean(IBoogieType iBoogieType) {
        return ITYPE_BOOL.equals(TypeUtils.primitiveType(iBoogieType));
    }

    public static boolean isNumeric(IBoogieType iBoogieType) {
        Integer n = TypeUtils.primitiveType(iBoogieType);
        return ITYPE_INT.equals(n) || ITYPE_REAL.equals(n);
    }

    public static boolean isNumericNonInt(IBoogieType iBoogieType) {
        return ITYPE_REAL.equals(TypeUtils.primitiveType(iBoogieType));
    }

    public static boolean isNumericInt(IBoogieType iBoogieType) {
        return ITYPE_INT.equals(TypeUtils.primitiveType(iBoogieType));
    }

    private static Integer primitiveType(IBoogieType iBoogieType) {
        if (iBoogieType instanceof BoogiePrimitiveType) {
            return ((BoogiePrimitiveType)iBoogieType).getTypeCode();
        }
        if (iBoogieType instanceof BoogieConstructedType) {
            BoogieConstructedType boogieConstructedType = (BoogieConstructedType)iBoogieType;
            if (boogieConstructedType.getUnderlyingType() instanceof BoogieConstructedType) {
                return null;
            }
            return TypeUtils.primitiveType((IBoogieType)boogieConstructedType.getUnderlyingType());
        }
        return null;
    }

    public static boolean categoryEquals(IBoogieType iBoogieType, IBoogieType iBoogieType2) {
        return TypeUtils.isBoolean(iBoogieType) == TypeUtils.isBoolean(iBoogieType2) && TypeUtils.isNumeric(iBoogieType) == TypeUtils.isNumeric(iBoogieType2);
    }

    public static Sort getInnermostArrayValueSort(Sort sort) {
        Sort sort2 = sort;
        while (sort2.isArraySort()) {
            sort2 = TypeUtils.getValueSort(sort2);
        }
        return sort2;
    }

    public static Sort getValueSort(Sort sort) {
        if (!sort.isArraySort()) {
            throw new IllegalArgumentException("sort is no array sort: " + String.valueOf(sort));
        }
        return sort.getArguments()[1];
    }

    public static Sort getIndexSort(Sort sort) {
        if (!sort.isArraySort()) {
            throw new IllegalArgumentException("sort is no array sort: " + String.valueOf(sort));
        }
        return sort.getArguments()[0];
    }
}

