/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.source.smtparser.chc;

import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.source.smtparser.chc.HornClauseParserScript;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class HornClauseBody {
    private Set<Term> mTransitions;
    private List<ApplicationTerm> mPredicates = new ArrayList<ApplicationTerm>();
    private boolean mFinalized = false;
    private final List<HcPredicateSymbol> mPredicateSymbols = new ArrayList<HcPredicateSymbol>();
    private List<List<Term>> mPredicateSymbolToArgs = new ArrayList<List<Term>>();
    private final HornClauseParserScript mParserScript;

    public HornClauseBody(HornClauseParserScript hornClauseParserScript) {
        this.mTransitions = new HashSet<Term>();
        this.mParserScript = hornClauseParserScript;
    }

    public void addPredicate(ApplicationTerm applicationTerm) {
        assert (!this.mFinalized);
        this.mPredicates.add(applicationTerm);
    }

    public void addTransitionFormula(Term term) {
        assert (!this.mFinalized);
        this.mTransitions.add(term);
    }

    public Term getTransitionFormula(Script script) {
        Term[] termArray = this.mTransitions.toArray(new Term[this.mTransitions.size()]);
        return SmtUtils.and((Script)script, (Term[])termArray);
    }

    List<HcPredicateSymbol> getPredicates(HcSymbolTable hcSymbolTable) {
        this.computePredicates(hcSymbolTable);
        return this.mPredicateSymbols;
    }

    public List<List<Term>> getPredicateToVars(HcSymbolTable hcSymbolTable) {
        this.computePredicates(hcSymbolTable);
        return this.mPredicateSymbolToArgs;
    }

    private void computePredicates(HcSymbolTable hcSymbolTable) {
        if (this.mFinalized) {
            return;
        }
        for (ApplicationTerm applicationTerm : this.mPredicates) {
            List<Term> list;
            HcPredicateSymbol hcPredicateSymbol = hcSymbolTable.getOrConstructHornClausePredicateSymbol(applicationTerm);
            this.mPredicateSymbols.add(hcPredicateSymbol);
            List<Term> list2 = list = Arrays.asList(applicationTerm.getParameters());
            this.mPredicateSymbolToArgs.add(list2);
        }
        this.mFinalized = true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("");
        boolean bl = true;
        for (ApplicationTerm applicationTerm : this.mPredicates) {
            if (!bl) {
                stringBuilder.append(" && ");
            }
            stringBuilder.append(applicationTerm.toString());
            bl = false;
        }
        for (Term term : this.mTransitions) {
            if (!bl) {
                stringBuilder.append(" && ");
            }
            stringBuilder.append(term.toStringDirect());
            bl = false;
        }
        return "(" + stringBuilder.toString() + ")";
    }

    public void applySubstitution(Map<Term, Term> map) {
        this.transformTerms(term -> PureSubstitution.apply((Script)this.mParserScript, (Map)map, (Term)term));
    }

    public void transformTerms(Function<Term, Term> function) {
        this.mTransitions = this.mTransitions.stream().map(term -> (Term)function.apply((Term)term)).collect(Collectors.toSet());
        this.mPredicates = this.mPredicates.stream().map(applicationTerm -> (ApplicationTerm)function.apply((Term)applicationTerm)).collect(Collectors.toList());
        this.mPredicateSymbolToArgs = this.mPredicateSymbolToArgs.stream().map(list -> list.stream().map(term -> (Term)function.apply((Term)term)).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public Set<TermVariable> getVariables() {
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
        for (Term object : this.mTransitions) {
            Collections.addAll(linkedHashSet, object.getFreeVars());
        }
        for (List list : this.mPredicateSymbolToArgs) {
            for (Term term : list) {
                Collections.addAll(linkedHashSet, term.getFreeVars());
            }
        }
        return linkedHashSet;
    }
}

