/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraintFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqDisjunctiveConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BidirectionalMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FormulaToEqDisjunctiveConstraintConverter
extends NonRecursive {
    public static final boolean INPLACE_CONJUNCTIONS = true;
    private final Term mFormula;
    private EqDisjunctiveConstraint<EqNode> mResultConstraint;
    private final EqConstraintFactory<EqNode> mEqConstraintFactory;
    private final EqNodeAndFunctionFactory mEqNodeAndFunctionFactory;
    private final ManagedScript mMgdScript;
    private final IUltimateServiceProvider mServices;
    private final Term mTrueTerm;
    private final Term mFalseTerm;
    private final Deque<EqDisjunctiveConstraint<EqNode>> mResultStack = new ArrayDeque<EqDisjunctiveConstraint<EqNode>>();

    public FormulaToEqDisjunctiveConstraintConverter(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, EqConstraintFactory<EqNode> eqConstraintFactory, EqNodeAndFunctionFactory eqNodeAndFunctionFactory, Term term) {
        this.mFormula = term;
        this.mEqConstraintFactory = eqConstraintFactory;
        this.mEqNodeAndFunctionFactory = eqNodeAndFunctionFactory;
        this.mMgdScript = managedScript;
        this.mServices = iUltimateServiceProvider;
        this.mMgdScript.lock((Object)this);
        this.mTrueTerm = this.mMgdScript.term((Object)this, "true", new Term[0]);
        this.mFalseTerm = this.mMgdScript.term((Object)this, "false", new Term[0]);
        this.mMgdScript.unlock((Object)this);
        this.computeResult();
    }

    private void computeResult() {
        Term term = new NnfTransformer(this.mMgdScript, this.mServices, NnfTransformer.QuantifierHandling.KEEP).transform(this.mFormula);
        StoreChainSquisher storeChainSquisher = new StoreChainSquisher(this.mMgdScript);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(storeChainSquisher.transform(term));
        arrayList.addAll(storeChainSquisher.getReplacementEquations());
        Term term2 = SmtUtils.and((Script)this.mMgdScript.getScript(), arrayList);
        this.run((NonRecursive.Walker)new ConvertTfToEqDisjConsWalker(term2));
        assert (this.mResultStack.size() == 1);
        EqDisjunctiveConstraint<EqNode> eqDisjunctiveConstraint = this.mResultStack.pop();
        eqDisjunctiveConstraint.closeDisjunctsIfNecessary();
        eqDisjunctiveConstraint.freezeDisjunctsIfNecessary();
        this.mResultConstraint = eqDisjunctiveConstraint.projectExistentially(storeChainSquisher.getReplacementTermVariables());
    }

    public EqDisjunctiveConstraint<EqNode> getResult() {
        return this.mResultConstraint;
    }

    class ConvertTfToEqDisjConsWalker
    extends NonRecursive.TermWalker {
        public ConvertTfToEqDisjConsWalker(Term term) {
            super(term);
        }

        public void walk(NonRecursive nonRecursive, ConstantTerm constantTerm) {
            if ("Bool".equals(constantTerm.getSort().getName())) {
                assert (false) : "TODO: implement";
            } else assert (false) : "we should have caught this before, right?";
        }

        public void walk(NonRecursive nonRecursive, AnnotatedTerm annotatedTerm) {
            nonRecursive.enqueueWalker((NonRecursive.Walker)new ConvertTfToEqDisjConsWalker(annotatedTerm.getSubterm()));
        }

        public void walk(NonRecursive nonRecursive, ApplicationTerm applicationTerm) {
            if ("=".equals(applicationTerm.getFunction().getName())) {
                this.handleXquality(applicationTerm.getParameters()[0], applicationTerm.getParameters()[1], true);
            } else if (List.of("distinct", ">", "<").contains(applicationTerm.getFunction().getName())) {
                this.handleXquality(applicationTerm.getParameters()[0], applicationTerm.getParameters()[1], false);
            } else if ("not".equals(applicationTerm.getFunction().getName()) && SmtUtils.isFunctionApplication((Term)applicationTerm.getParameters()[0], (String)"=")) {
                ApplicationTerm applicationTerm2 = (ApplicationTerm)applicationTerm.getParameters()[0];
                this.handleXquality(applicationTerm2.getParameters()[0], applicationTerm2.getParameters()[1], false);
            } else if ("not".equals(applicationTerm.getFunction().getName())) {
                this.handleBooleanTerm(applicationTerm.getParameters()[0], false);
            } else if ("or".equals(applicationTerm.getFunction().getName())) {
                nonRecursive.enqueueWalker((NonRecursive.Walker)new MakeDisjunctionWalker(applicationTerm.getParameters().length));
                Term[] termArray = applicationTerm.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term = termArray[n2];
                    nonRecursive.enqueueWalker((NonRecursive.Walker)new ConvertTfToEqDisjConsWalker(term));
                    ++n2;
                }
            } else if ("and".equals(applicationTerm.getFunction().getName())) {
                nonRecursive.enqueueWalker((NonRecursive.Walker)new MakeConjunctionWalker(applicationTerm.getParameters().length));
                Term[] termArray = applicationTerm.getParameters();
                int n = termArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Term term = termArray[n3];
                    nonRecursive.enqueueWalker((NonRecursive.Walker)new ConvertTfToEqDisjConsWalker(term));
                    ++n3;
                }
            } else if ("false".equals(applicationTerm.getFunction().getName())) {
                FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getDisjunctiveConstraint(Collections.emptySet()));
            } else {
                "true".equals(applicationTerm.getFunction().getName());
                FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyDisjunctiveConstraint(true));
            }
        }

        private void handleBooleanTerm(Term term, boolean bl) {
            assert ("Bool".equals(term.getSort().getName()));
            EqNode eqNode = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(term);
            if (bl) {
                EqNode eqNode2 = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(FormulaToEqDisjunctiveConstraintConverter.this.mTrueTerm);
                EqConstraint<EqNode> eqConstraint = FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.addEquality(eqNode, eqNode2, FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyConstraint(true), true);
                FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getDisjunctiveConstraint(Collections.singleton(eqConstraint)));
            } else {
                EqNode eqNode3 = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(FormulaToEqDisjunctiveConstraintConverter.this.mFalseTerm);
                EqConstraint<EqNode> eqConstraint = FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.addEquality(eqNode, eqNode3, FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyConstraint(true), true);
                FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getDisjunctiveConstraint(Collections.singleton(eqConstraint)));
            }
        }

        private void handleXquality(Term term, Term term2, boolean bl) {
            if (term.getSort().isArraySort()) {
                EqConstraint<EqNode> eqConstraint;
                EqNode eqNode;
                EqNode eqNode2;
                ApplicationTerm applicationTerm;
                if (!this.isFunctionTracked(term) || !this.isFunctionTracked(term2)) {
                    FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyDisjunctiveConstraint(true));
                    return;
                }
                if (SmtUtils.isFunctionApplication((Term)term, (String)"store")) {
                    assert (!SmtUtils.isFunctionApplication((Term)term2, (String)"store"));
                    applicationTerm = (ApplicationTerm)term;
                    eqNode2 = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(term2);
                    eqNode = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(applicationTerm.getParameters()[0]);
                } else if (SmtUtils.isFunctionApplication((Term)term2, (String)"store")) {
                    assert (!SmtUtils.isFunctionApplication((Term)term, (String)"store"));
                    applicationTerm = (ApplicationTerm)term2;
                    eqNode2 = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(term);
                    eqNode = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(applicationTerm.getParameters()[0]);
                } else {
                    applicationTerm = null;
                    eqNode2 = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(term);
                    eqNode = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(term2);
                }
                if (bl) {
                    if (applicationTerm == null) {
                        eqConstraint = FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.addEquality(eqNode2, eqNode, FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyConstraint(true), true);
                    } else {
                        EqNode eqNode3 = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(applicationTerm.getParameters()[1]);
                        EqNode eqNode4 = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(applicationTerm.getParameters()[2]);
                        EqConstraint<EqNode> eqConstraint2 = FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.addWeakEquivalence(eqNode2, eqNode, eqNode3, FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyConstraint(true), true);
                        FormulaToEqDisjunctiveConstraintConverter.this.mMgdScript.lock((Object)this);
                        Term term3 = FormulaToEqDisjunctiveConstraintConverter.this.mMgdScript.term((Object)this, "select", new Term[]{eqNode2.getTerm(), applicationTerm.getParameters()[1]});
                        FormulaToEqDisjunctiveConstraintConverter.this.mMgdScript.unlock((Object)this);
                        EqNode eqNode5 = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(term3);
                        eqConstraint = FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.addEquality(eqNode5, eqNode4, eqConstraint2, true);
                    }
                } else {
                    eqConstraint = applicationTerm == null ? FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.addDisequality(eqNode2, eqNode, FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyConstraint(true), true) : FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyConstraint(true);
                }
                FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getDisjunctiveConstraint(Collections.singleton(eqConstraint)));
                return;
            }
            if (!this.isElementTracked(term) || !this.isElementTracked(term2)) {
                FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyDisjunctiveConstraint(true));
                return;
            }
            EqNode eqNode = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(term);
            EqNode eqNode6 = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(term2);
            EqConstraint<EqNode> eqConstraint = bl ? FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.addEquality(eqNode, eqNode6, FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyConstraint(true), true) : FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.addDisequality(eqNode, eqNode6, FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyConstraint(true), true);
            FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getDisjunctiveConstraint(Collections.singleton(eqConstraint)));
        }

        private boolean isElementTracked(Term term) {
            return true;
        }

        private boolean isFunctionTracked(Term term) {
            return true;
        }

        public void walk(NonRecursive nonRecursive, LetTerm letTerm) {
            assert (false) : "TODO unlet first (or implement let handling..)";
        }

        public void walk(NonRecursive nonRecursive, QuantifiedFormula quantifiedFormula) {
            FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyDisjunctiveConstraint(true));
        }

        public void walk(NonRecursive nonRecursive, TermVariable termVariable) {
            if ("Bool".equals(termVariable.getSort().getName())) {
                this.handleBooleanTerm((Term)termVariable, true);
                return;
            }
            throw new AssertionError((Object)"we should have caught this before, right?");
        }

        public void walk(NonRecursive nonRecursive, MatchTerm matchTerm) {
            throw new UnsupportedOperationException("not yet implemented: MatchTerm");
        }

        public void walk(NonRecursive nonRecursive, LambdaTerm lambdaTerm) {
            throw new UnsupportedOperationException();
        }
    }

    class MakeConjunctionWalker
    implements NonRecursive.Walker {
        private final int mArity;

        public MakeConjunctionWalker(int n) {
            this.mArity = n;
        }

        public void walk(NonRecursive nonRecursive) {
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < this.mArity) {
                arrayList.add(FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.pop());
                ++n;
            }
            FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.conjoinDisjunctiveConstraints(arrayList));
        }
    }

    class MakeDisjunctionWalker
    implements NonRecursive.Walker {
        private final int mArity;

        public MakeDisjunctionWalker(int n) {
            this.mArity = n;
        }

        public void walk(NonRecursive nonRecursive) {
            HashSet hashSet = new HashSet();
            int n = 0;
            while (n < this.mArity) {
                hashSet.addAll(FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.pop().getConstraints());
                ++n;
            }
            FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getDisjunctiveConstraint(hashSet));
        }
    }

    public static final class StoreChainSquisher
    extends TermTransformer {
        private static final String SQUISHERREPARRAYNAME = "rep";
        private final List<Term> mReplacementEquations;
        private final Map<Term, TermVariable> mReplacedTermToReplacementTv;
        private final Script mScript;
        private final ManagedScript mMgdScript;

        public StoreChainSquisher(ManagedScript managedScript) {
            this.mScript = managedScript.getScript();
            this.mMgdScript = managedScript;
            this.mReplacementEquations = new ArrayList<Term>();
            this.mReplacedTermToReplacementTv = new BidirectionalMap();
        }

        public Collection<Term> getReplacementEquations() {
            ArrayList<Term> arrayList = new ArrayList<Term>();
            for (Map.Entry<Term, TermVariable> entry : this.mReplacedTermToReplacementTv.entrySet()) {
                Term term = SmtUtils.binaryEquality((Script)this.mScript, (Term)((Term)entry.getValue()), (Term)entry.getKey());
                arrayList.add(term);
            }
            return arrayList;
        }

        public Collection<Term> getReplacementTermVariables() {
            return new ArrayList<TermVariable>(this.mReplacedTermToReplacementTv.values());
        }

        protected void convert(Term term) {
            if (SmtUtils.isFunctionApplication((Term)term, (String)"store")) {
                this.enqueueWalker(new SquishStoreWalker((ApplicationTerm)term));
                this.pushTerms(((ApplicationTerm)term).getParameters());
            } else if (SmtUtils.isFunctionApplication((Term)term, (String)"select")) {
                this.enqueueWalker(new SquishStoreInsideSelectWalker());
                this.pushTerms(((ApplicationTerm)term).getParameters());
            } else if (SmtUtils.isFunctionApplication((Term)term, (String)"=") && SmtUtils.isFunctionApplication((Term)((ApplicationTerm)term).getParameters()[0], (String)"store") && SmtUtils.isFunctionApplication((Term)((ApplicationTerm)term).getParameters()[1], (String)"store")) {
                this.enqueueWalker(new SquishFirstOfTwoArgumentStoresWalker((ApplicationTerm)term));
                assert (((ApplicationTerm)term).getParameters().length == 2);
                this.pushTerms(((ApplicationTerm)term).getParameters());
            } else if (term instanceof QuantifiedFormula) {
                this.setResult(term);
            } else {
                super.convert(term);
            }
        }

        private TermVariable getReplacementTv(Term term) {
            TermVariable termVariable = this.mReplacedTermToReplacementTv.get(term);
            if (termVariable == null) {
                String string = SmtUtils.sanitizeStringAsSmtIdentifier((String)("rep_" + term.toString()));
                termVariable = this.mMgdScript.constructFreshTermVariable(string, term.getSort());
                this.mReplacedTermToReplacementTv.put(term, termVariable);
            }
            return termVariable;
        }

        Term[] getConvertedArray(Term[] termArray) {
            return this.getConverted(termArray);
        }

        class SquishFirstOfTwoArgumentStoresWalker
        implements NonRecursive.Walker {
            private final ApplicationTerm mAppTerm;

            public SquishFirstOfTwoArgumentStoresWalker(ApplicationTerm applicationTerm) {
                this.mAppTerm = applicationTerm;
                assert (applicationTerm.getParameters().length == 2);
            }

            public void walk(NonRecursive nonRecursive) {
                Term term = StoreChainSquisher.this.getConverted();
                Term term2 = StoreChainSquisher.this.getConverted();
                assert (SmtUtils.isFunctionApplication((Term)term2, (String)"store"));
                assert (SmtUtils.isFunctionApplication((Term)term, (String)"store"));
                Term term3 = term2;
                TermVariable termVariable = StoreChainSquisher.this.getReplacementTv(term3);
                StoreChainSquisher.this.setResult(StoreChainSquisher.this.mScript.term(this.mAppTerm.getFunction().getName(), new Term[]{termVariable, term}));
            }
        }

        class SquishStoreInsideSelectWalker
        implements NonRecursive.Walker {
            SquishStoreInsideSelectWalker() {
            }

            public void walk(NonRecursive nonRecursive) {
                Term term = StoreChainSquisher.this.getConverted();
                Term term2 = StoreChainSquisher.this.getConverted();
                if (SmtUtils.isFunctionApplication((Term)term2, (String)"store")) {
                    Term term3 = term2;
                    TermVariable termVariable = StoreChainSquisher.this.getReplacementTv(term3);
                    StoreChainSquisher.this.setResult(StoreChainSquisher.this.mScript.term("select", new Term[]{termVariable, term}));
                } else {
                    StoreChainSquisher.this.setResult(StoreChainSquisher.this.mScript.term("select", new Term[]{term2, term}));
                }
            }
        }

        class SquishStoreWalker
        implements NonRecursive.Walker {
            private static final int NO_STORE_ARGS = 3;
            private final ApplicationTerm mAppTerm;

            public SquishStoreWalker(ApplicationTerm applicationTerm) {
                this.mAppTerm = applicationTerm;
            }

            public void walk(NonRecursive nonRecursive) {
                StoreChainSquisher storeChainSquisher = (StoreChainSquisher)nonRecursive;
                Term[] termArray = this.mAppTerm.getParameters();
                Term[] termArray2 = storeChainSquisher.getConvertedArray(termArray);
                assert (termArray2.length == 3);
                Object object = SmtUtils.isFunctionApplication((Term)termArray2[0], (String)"store") ? StoreChainSquisher.this.getReplacementTv(termArray2[0]) : termArray2[0];
                Object object2 = SmtUtils.isFunctionApplication((Term)termArray2[2], (String)"store") ? StoreChainSquisher.this.getReplacementTv(termArray2[2]) : termArray2[2];
                StoreChainSquisher.this.setResult(StoreChainSquisher.this.mScript.term("store", new Term[]{object, termArray2[1], object2}));
            }

            public String toString() {
                return "StoreTermSquisher: " + String.valueOf(StoreChainSquisher.this.mReplacementEquations);
            }
        }
    }
}

