/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;

public class SMTPrettyPrinter {
    private static final String INDENT = "    ";
    private static final String[] INFIX_FUNCTIONS = new String[]{"+", "-", "*", "/", "=", ">=", "<=", ">", "<"};
    private final Term mTerm;

    public SMTPrettyPrinter(Term term) {
        this.mTerm = term;
    }

    private static void indent(StringBuilder stringBuilder, int n) {
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append(INDENT);
            ++n2;
        }
    }

    private static String print(Term term, int n) {
        assert (n >= 0);
        StringBuilder stringBuilder = new StringBuilder();
        if (term instanceof ConstantTerm) {
            return term.toString();
        }
        if (term instanceof TermVariable) {
            return term.toString();
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            String string = applicationTerm.getFunction().getName();
            if (applicationTerm.getParameters().length == 0) {
                return string;
            }
            if (string.equals("ite")) {
                stringBuilder.append("(");
                stringBuilder.append(SMTPrettyPrinter.print(applicationTerm.getParameters()[0], n + 1));
                stringBuilder.append(" ? ");
                stringBuilder.append(SMTPrettyPrinter.print(applicationTerm.getParameters()[1], n + 1));
                stringBuilder.append(" : ");
                stringBuilder.append(SMTPrettyPrinter.print(applicationTerm.getParameters()[2], n + 1));
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            stringBuilder.append("(");
            boolean bl = false;
            String[] stringArray = INFIX_FUNCTIONS;
            int n2 = INFIX_FUNCTIONS.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray[n3];
                if (string.equals(string2)) {
                    bl = true;
                }
                ++n3;
            }
            if (applicationTerm.getParameters().length == 1) {
                stringBuilder.append(string);
                stringBuilder.append(" ");
                stringBuilder.append(SMTPrettyPrinter.print(applicationTerm.getParameters()[0], 0));
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            if (!bl) {
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
            int n4 = 0;
            while (n4 < applicationTerm.getParameters().length) {
                if (bl) {
                    if (n4 > 0) {
                        stringBuilder.append(" ");
                        stringBuilder.append(string);
                        stringBuilder.append(" ");
                    }
                } else {
                    SMTPrettyPrinter.indent(stringBuilder, n + 1);
                }
                stringBuilder.append(SMTPrettyPrinter.print(applicationTerm.getParameters()[n4], n + 1));
                if (!bl) {
                    stringBuilder.append("\n");
                }
                ++n4;
            }
            if (!bl) {
                SMTPrettyPrinter.indent(stringBuilder, n);
            }
            stringBuilder.append(")");
        } else if (term instanceof AnnotatedTerm) {
            AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
            Annotation[] annotationArray = annotatedTerm.getAnnotations();
            int n5 = annotationArray.length;
            int n6 = 0;
            while (n6 < n5) {
                Annotation annotation = annotationArray[n6];
                SMTPrettyPrinter.indent(stringBuilder, n);
                stringBuilder.append("{");
                stringBuilder.append(annotation.getKey());
                stringBuilder.append(" ");
                stringBuilder.append(annotation.getValue());
                stringBuilder.append("}\n");
                ++n6;
            }
            stringBuilder.append(SMTPrettyPrinter.print(annotatedTerm.getSubterm(), n));
        } else assert (false);
        return stringBuilder.toString();
    }

    public String toString() {
        return SMTPrettyPrinter.print(this.mTerm, 0);
    }
}

