/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer;

import de.uni_freiburg.informatik.ultimate.core.lib.translation.DefaultTranslator;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class IcfgTransformationBacktranslator
extends DefaultTranslator<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>, Term, Term, String, String, ILocation> {
    private final Map<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>> mEdgeMapping = new HashMap<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>>();
    private final ILogger mLogger;
    private final ArrayList<Function<Term, Term>> mExpressionBacktranslations;

    public IcfgTransformationBacktranslator(Class<? extends IIcfgTransition<IcfgLocation>> clazz, Class<Term> clazz2, ILogger iLogger) {
        super(clazz, clazz, clazz2, clazz2);
        this.mLogger = iLogger;
        this.mExpressionBacktranslations = new ArrayList();
    }

    public IProgramExecution<IIcfgTransition<IcfgLocation>, Term> translateProgramExecution(IProgramExecution<IIcfgTransition<IcfgLocation>, Term> iProgramExecution) {
        Map[] mapArray = null;
        if (iProgramExecution instanceof IcfgProgramExecution) {
            mapArray = ((IcfgProgramExecution)iProgramExecution).getBranchEncoders();
        }
        ArrayList<IIcfgTransition<IcfgLocation>> arrayList = new ArrayList<IIcfgTransition<IcfgLocation>>();
        HashMap<Integer, IProgramExecution.ProgramState<Term>> hashMap = new HashMap<Integer, IProgramExecution.ProgramState<Term>>();
        ArrayList<Map> arrayList2 = new ArrayList<Map>();
        this.addProgramState(-1, hashMap, (IProgramExecution.ProgramState<Term>)iProgramExecution.getInitialProgramState());
        int n = 0;
        while (n < iProgramExecution.getLength()) {
            AtomicTraceElement atomicTraceElement = iProgramExecution.getTraceElement(n);
            IIcfgTransition<IcfgLocation> iIcfgTransition = this.mEdgeMapping.get(atomicTraceElement.getTraceElement());
            if (iIcfgTransition == null) {
                this.mLogger.warn((Object)("Skipped ATE because there is no mapping: [" + ((IIcfgTransition)atomicTraceElement.getTraceElement()).hashCode() + "] " + String.valueOf(atomicTraceElement.getTraceElement())));
            } else {
                arrayList.add(iIcfgTransition);
                this.addProgramState(n, hashMap, (IProgramExecution.ProgramState<Term>)iProgramExecution.getProgramState(n));
                if (mapArray != null && mapArray.length > n) {
                    arrayList2.add(mapArray[n]);
                }
            }
            ++n;
        }
        return IcfgProgramExecution.create(arrayList, hashMap, (Map[])arrayList2.toArray(new Map[arrayList2.size()]));
    }

    private void addProgramState(Integer n, Map<Integer, IProgramExecution.ProgramState<Term>> map, IProgramExecution.ProgramState<Term> programState) {
        map.put(n, (IProgramExecution.ProgramState<Term>)this.translateProgramState(programState));
    }

    public Term translateExpression(Term term) {
        Term term2 = term;
        int n = this.mExpressionBacktranslations.size() - 1;
        while (n >= 0) {
            term2 = this.mExpressionBacktranslations.get(n).apply(term2);
            --n;
        }
        return term2;
    }

    public void mapEdges(IIcfgTransition<IcfgLocation> iIcfgTransition, IIcfgTransition<IcfgLocation> iIcfgTransition2) {
        IIcfgTransition<IcfgLocation> iIcfgTransition3 = this.mEdgeMapping.get(iIcfgTransition2);
        if (iIcfgTransition3 != null) {
            this.mEdgeMapping.put(iIcfgTransition, iIcfgTransition3);
        } else {
            this.mEdgeMapping.put(iIcfgTransition, iIcfgTransition2);
        }
    }

    public void addExpressionBacktranslation(Function<Term, Term> function) {
        this.mExpressionBacktranslations.add(function);
    }

    @Deprecated
    public Map<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>> getEdgeMapping() {
        return Collections.unmodifiableMap(this.mEdgeMapping);
    }
}

