/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XjunctPartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;

public class XnfIrd
extends XjunctPartialQuantifierElimination {
    public XnfIrd(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        super(managedScript, iUltimateServiceProvider);
    }

    @Override
    public String getName() {
        return "infinity restrictor drop";
    }

    @Override
    public String getAcronym() {
        return "IRD";
    }

    @Override
    public boolean resultIsXjunction() {
        return true;
    }

    @Override
    public Term[] tryToEliminate(int n, Term[] termArray, Set<TermVariable> set) {
        Iterator<TermVariable> iterator = set.iterator();
        Term[] termArray2 = termArray;
        while (iterator.hasNext()) {
            TermVariable termVariable = iterator.next();
            if (!SmtUtils.getFreeVars(Arrays.asList(termArray2)).contains(termVariable)) {
                iterator.remove();
                continue;
            }
            Term[] termArray3 = XnfIrd.irdSimple(this.mMgdScript, n, termArray2, termVariable);
            if (termArray3 == null) continue;
            termArray2 = termArray3;
            iterator.remove();
        }
        return termArray2;
    }

    public static Term[] irdSimple(ManagedScript managedScript, int n, Term[] termArray, TermVariable termVariable) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Term[] termArray2 = termArray;
        int n5 = termArray.length;
        int n6 = 0;
        while (n6 < n5) {
            Term term = termArray2[n6];
            if (!Arrays.asList(term.getFreeVars()).contains(termVariable)) {
                arrayList.add(term);
            } else {
                if (!SmtSortUtils.isNumericSort(termVariable.getSort()) && !SmtSortUtils.isBitvecSort(termVariable.getSort())) {
                    return null;
                }
                SolvedBinaryRelation solvedBinaryRelation = XnfIrd.solve(managedScript, termVariable, n, term);
                if (solvedBinaryRelation == null) {
                    return null;
                }
                switch (solvedBinaryRelation.getRelationSymbol()) {
                    case EQ: {
                        if (n == 0) {
                            return null;
                        }
                        if (n == 1) {
                            ++n2;
                            break;
                        }
                        throw new AssertionError((Object)"unknown quantifier");
                    }
                    case DISTINCT: {
                        if (n == 0) {
                            ++n2;
                            break;
                        }
                        if (n == 1) {
                            return null;
                        }
                        throw new AssertionError((Object)"unknown quantifier");
                    }
                    case GEQ: 
                    case GREATER: {
                        if (n3 > 0) {
                            return null;
                        }
                        ++n4;
                        break;
                    }
                    case LEQ: 
                    case LESS: {
                        if (n4 > 0) {
                            return null;
                        }
                        ++n3;
                        break;
                    }
                    case BVULE: 
                    case BVULT: 
                    case BVUGE: 
                    case BVUGT: 
                    case BVSLE: 
                    case BVSLT: 
                    case BVSGE: 
                    case BVSGT: {
                        throw new AssertionError((Object)"cannot have been transformed to PolynomialRelation");
                    }
                    default: {
                        throw new AssertionError((Object)"unknown functionSymbol");
                    }
                }
            }
            ++n6;
        }
        float f = XnfIrd.underapproximateNumberOfDomainElements(termVariable.getSort());
        if ((float)n2 >= f) {
            return null;
        }
        return arrayList.toArray(new Term[arrayList.size()]);
    }

    private static SolvedBinaryRelation solve(ManagedScript managedScript, TermVariable termVariable, int n, Term term) {
        PolynomialRelation polynomialRelation = PolynomialRelation.of(managedScript.getScript(), term);
        if (polynomialRelation == null) {
            return null;
        }
        SolvedBinaryRelation solvedBinaryRelation = polynomialRelation.solveForSubject(managedScript.getScript(), (Term)termVariable);
        return solvedBinaryRelation;
    }

    private static float underapproximateNumberOfDomainElements(Sort sort) {
        if (SmtSortUtils.isBoolSort(sort)) {
            return 2.0f;
        }
        if (SmtSortUtils.isNumericSort(sort)) {
            return Float.POSITIVE_INFINITY;
        }
        if (SmtSortUtils.isBitvecSort(sort)) {
            BigInteger bigInteger = new BigInteger(sort.getRealSort().getIndices()[0]);
            return (float)Math.pow(2.0, bigInteger.doubleValue());
        }
        if (SmtSortUtils.isFloatingpointSort(sort)) {
            BigInteger[] bigIntegerArray = SmtUtils.toBigIntegerArray(sort.getRealSort().getIndices());
            BigInteger bigInteger = bigIntegerArray[0].add(bigIntegerArray[1]);
            return (float)Math.pow(2.0, bigInteger.doubleValue());
        }
        if (SmtSortUtils.isArraySort(sort)) {
            Sort[] sortArray = sort.getRealSort().getArguments();
            assert (sortArray.length == 2);
            Sort sort2 = sortArray[0];
            Sort sort3 = sortArray[1];
            return (float)Math.pow(XnfIrd.underapproximateNumberOfDomainElements(sort2), XnfIrd.underapproximateNumberOfDomainElements(sort3));
        }
        return 1.0f;
    }
}

