/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.CounterTrace;
import de.uni_freiburg.informatik.ultimate.lib.pea.EventDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.FormulaXML2JConverter;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.MCTrace;
import java.io.IOException;
import java.util.TreeSet;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MCTraceXML2JConverter {
    private static final String DEFAULT_LOGGER = "MCTraceXML2JConverter";
    private ILogger logger = null;
    private DOMParser parser = null;
    private FormulaXML2JConverter formulaConverter = null;

    public MCTraceXML2JConverter(String string, boolean bl) throws Exception {
        this.logger = string.equals("") ? ILogger.getLogger((String)DEFAULT_LOGGER) : ILogger.getLogger((String)string);
        this.formulaConverter = new FormulaXML2JConverter(bl);
        this.initialiseParser();
    }

    public MCTraceXML2JConverter(boolean bl) throws Exception {
        this("", bl);
    }

    private void initialiseParser() throws Exception {
        this.parser = new DOMParser();
        this.logger.debug((Object)"Trying to set parser feature \"http://xml.org/sax/features/validation\"");
        this.parser.setFeature("http://xml.org/sax/features/validation", true);
        this.logger.debug((Object)"Setting parser feature \"http://xml.org/sax/features/validation\" successful");
        this.logger.debug((Object)"Trying to set parser feature \"http://apache.org/xml/features/validation/schema\"");
        this.parser.setFeature("http://apache.org/xml/features/validation/schema", false);
        this.logger.debug((Object)"Setting parser feature \"http://apache.org/xml/features/validation/schema\" successful");
    }

    public MCTrace[] convert(Element element) {
        return this.buildTraceModel(element);
    }

    public MCTrace[] convert(String string) throws SAXException, IOException {
        Document document = this.parse(string);
        return this.buildTraceModel(document.getDocumentElement());
    }

    private Document parse(String string) throws SAXException, IOException {
        this.logger.debug((Object)("Trying to parse file=\"" + string + "\""));
        this.parser.parse(string);
        this.logger.debug((Object)("Parsing file=\"" + string + "\" successful"));
        return this.parser.getDocument();
    }

    private MCTrace[] buildTraceModel(Element element) {
        NodeList nodeList = element.getElementsByTagName("mcTrace");
        int n = nodeList.getLength();
        this.logger.info((Object)("MCTraceCount    = " + n));
        MCTrace[] mCTraceArray = new MCTrace[n];
        int n2 = 0;
        while (n2 < n) {
            this.logger.info((Object)("Trying to build mcTrace " + n2));
            mCTraceArray[n2] = this.buildMCTrace((Element)nodeList.item(n2));
            this.logger.info((Object)("Building mcTrace " + n2 + " successful"));
            ++n2;
        }
        return mCTraceArray;
    }

    private MCTrace buildMCTrace(Element element) {
        Object object;
        MCTrace mCTrace = new MCTrace();
        if (element.hasAttribute("entrySync")) {
            object = element.getAttribute("entrySync");
            if (((String)object).equals("")) {
                throw new RuntimeException("Existing entry sync events are not allowed to have empty names");
            }
            mCTrace.setEntrySync(EventDecision.create((String)object));
            this.logger.info((Object)("EntrySync       = " + (String)object));
        }
        if ((object = element.getElementsByTagName("trace")).getLength() != 1) {
            throw new RuntimeException("Trace count != 1 is not allowed");
        }
        this.logger.info((Object)"Trying to build trace");
        this.buildTrace((Element)object.item(0), mCTrace);
        this.logger.info((Object)"Building trace successful");
        String string = element.getAttribute("exitSync");
        if (string.equals("")) {
            throw new RuntimeException("Exit sync events are not allowed to be empty");
        }
        mCTrace.setExitSync(EventDecision.create(string));
        this.logger.info((Object)("ExitSync        = " + string));
        return mCTrace;
    }

    private void buildTrace(Element element, MCTrace mCTrace) {
        Object object;
        NodeList nodeList = element.getChildNodes();
        NodeList nodeList2 = element.getElementsByTagName("phase");
        int n = nodeList2.getLength();
        if (n == 0) {
            throw new RuntimeException("A trace with 0 phases is not allowed");
        }
        this.logger.info((Object)("PhaseCount      = " + n));
        CounterTrace.DCPhase[] dCPhaseArray = new CounterTrace.DCPhase[n];
        int n2 = 0;
        this.logger.info((Object)("Trying to build phase " + n2));
        dCPhaseArray[n2] = this.buildPhase(CDD.TRUE, (Element)nodeList2.item(n2));
        this.logger.info((Object)("Building phase " + n2 + " successful"));
        ++n2;
        CDD cDD = CDD.TRUE;
        Element element2 = (Element)nodeList2.item(0);
        int n3 = 0;
        while (n3 < nodeList.getLength() && n2 < n) {
            if ((nodeList.item(n3).getNodeName().equals("phase") || nodeList.item(n3).getNodeName().equals("event")) && nodeList.item(n3) != nodeList2.item(0)) {
                element2 = (Element)nodeList.item(n3);
                object = element2.getNodeName();
                if (((String)object).equals("phase")) {
                    this.logger.info((Object)("Trying to build phase " + n2));
                    dCPhaseArray[n2] = this.buildPhase(cDD, element2);
                    this.logger.info((Object)("EntryEvents     = " + String.valueOf(cDD)));
                    this.logger.info((Object)("Building phase " + n2 + " successful"));
                    cDD = CDD.TRUE;
                    ++n2;
                }
                if (((String)object).equals("event")) {
                    CDD cDD2 = EventDecision.create(MCTraceXML2JConverter.getNameAttribute(element2));
                    cDD = MCTraceXML2JConverter.getSpecAttribute(element2) ? cDD.and(cDD2) : cDD.and(cDD2.negate());
                }
            }
            n3 += 1;
        }
        mCTrace.setTrace(new CounterTrace(dCPhaseArray));
        object = CDD.TRUE;
        int n4 = n3;
        while (n4 < nodeList.getLength()) {
            if (nodeList.item(n4).getNodeName().equals("event")) {
                element2 = (Element)nodeList.item(n4);
                object = MCTraceXML2JConverter.getSpecAttribute(element2) ? ((CDD)object).and(EventDecision.create(MCTraceXML2JConverter.getNameAttribute(element2))) : ((CDD)object).and(EventDecision.createNeg(MCTraceXML2JConverter.getNameAttribute(element2)));
            }
            n4 += 1;
        }
        this.logger.info((Object)("MissingEvents   = " + String.valueOf(object)));
        mCTrace.setMissingEvents((CDD)object);
        n4 = MCTraceXML2JConverter.getSpecAttribute(element) ? 1 : 0;
        mCTrace.setSpec(n4 != 0);
        this.logger.info((Object)("TraceSpec       = " + (n4 != 0)));
    }

    private static String getNameAttribute(Element element) {
        String string = element.getAttribute("name");
        if (string.equals("")) {
            throw new RuntimeException("Name is not allowed to be empty");
        }
        return string;
    }

    private CounterTrace.DCPhase buildPhase(CDD cDD, Element element) {
        boolean bl;
        Object object;
        int n = 0;
        double d = 0.0;
        NodeList nodeList = element.getElementsByTagName("timeBound");
        if (nodeList.getLength() > 1) {
            throw new RuntimeException("Time bound count > 1 is not allowed");
        }
        if (nodeList.getLength() == 1) {
            object = (Element)nodeList.item(0);
            n = MCTraceXML2JConverter.getOperator((Element)object);
            d = MCTraceXML2JConverter.getTimeBound((Element)object);
        }
        if ((object = element.getElementsByTagName("stateInvariant")).getLength() != 1) {
            throw new RuntimeException("Stateinvariant count != 1 is not allowed");
        }
        Element element2 = (Element)object.item(0);
        CDD cDD2 = this.formulaConverter.convert(element2);
        TreeSet<String> treeSet = new TreeSet<String>();
        NodeList nodeList2 = element.getElementsByTagName("forbiddenEvent");
        if (nodeList2.getLength() > 0) {
            int bl2 = nodeList2.getLength();
            int dCPhase = 0;
            while (dCPhase < bl2) {
                Element element3 = (Element)nodeList2.item(dCPhase);
                treeSet.add(MCTraceXML2JConverter.getNameAttribute(element3));
                ++dCPhase;
            }
        }
        boolean bl3 = false;
        if (element.hasAttribute("allowEmpty")) {
            String string = element.getAttribute("allowEmpty");
            if (!string.equals("true") && !string.equals("false")) {
                throw new RuntimeException("AllowEmpty attribute needs to be set to \"true\" or \"false\"");
            }
            bl = Boolean.parseBoolean(string);
        }
        CounterTrace.DCPhase dCPhase = new CounterTrace.DCPhase(cDD, cDD2, n, (int)d, treeSet, bl);
        this.logger.info((Object)("PhaseBoundType  = " + n));
        this.logger.info((Object)("PhaseBound      = " + (int)d));
        this.logger.info((Object)("PhaseInvariant  = " + String.valueOf(cDD2)));
        this.logger.info((Object)("ForbiddenEvents = " + String.valueOf(treeSet)));
        this.logger.info((Object)("AllowEmpty      = " + bl));
        return dCPhase;
    }

    private static double getTimeBound(Element element) {
        String string = element.getAttribute("bound");
        return Double.parseDouble(string);
    }

    private static int getOperator(Element element) {
        String string = element.getAttribute("operator");
        if (string.equals("greaterequal")) {
            return 1;
        }
        if (string.equals("greater")) {
            return 2;
        }
        if (string.equals("less")) {
            return -2;
        }
        if (string.equals("lessequal")) {
            return -1;
        }
        throw new RuntimeException("Operator needs to be \"greaterequal\", \"greater\", \"less\", or \"lessequal\"");
    }

    private static boolean getSpecAttribute(Element element) {
        String string = element.getAttribute("spec");
        if (!string.equals("true") && !string.equals("false")) {
            throw new RuntimeException("Spec value != \"true\" and != \"false\" not allowed");
        }
        return Boolean.parseBoolean(string);
    }

    public static void main(String[] stringArray) {
        try {
            MCTraceXML2JConverter mCTraceXML2JConverter = new MCTraceXML2JConverter(false);
            mCTraceXML2JConverter.convert("file:/home/roland/Desktop/Arbeit/PUMLaut/ModelCheckForm/ModelCheckForm.xml");
        }
        catch (Exception exception) {
            System.out.println("Exception raised");
            exception.printStackTrace();
        }
    }
}

