/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.weakener;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarAbsIntRunner;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class InterpolantSequenceWeakener<HTC extends IHoareTripleChecker, P extends IPredicate, LETTER extends IAction> {
    private final List<P> mResult;
    protected final ILogger mLogger;
    protected final HTC mHtc;
    private final P mPrecondition;
    private final P mPostcondition;
    protected final Script mScript;
    protected final BasicPredicateFactory mPredicateFactory;
    private final TripleList<P, LETTER> mTripleList;
    protected final Map<Integer, P> mHierarchicalPreStates;
    private int mSuccessfulWeakenings = 0;
    private final List<Rational> mSizeDifferential = new ArrayList<Rational>();
    private final CegarAbsIntRunner.AbsIntStatisticsGenerator mStats;

    public InterpolantSequenceWeakener(ILogger iLogger, HTC HTC, List<P> list, List<LETTER> list2, P p, P p2, Script script, BasicPredicateFactory basicPredicateFactory, CegarAbsIntRunner.AbsIntStatisticsGenerator absIntStatisticsGenerator) {
        this.mLogger = iLogger;
        this.mHtc = (IHoareTripleChecker)Objects.requireNonNull(HTC);
        this.mPrecondition = p;
        this.mPostcondition = p2;
        this.mScript = script;
        this.mPredicateFactory = basicPredicateFactory;
        this.mStats = absIntStatisticsGenerator;
        this.mTripleList = new TripleList<P, LETTER>(list, list2, this.mPrecondition, this.mPostcondition);
        List<LETTER> list3 = Objects.requireNonNull(list2, "trace is null");
        List<P> list4 = Objects.requireNonNull(list, "predicates are null");
        if (list3.size() != list4.size() + 1) {
            throw new IllegalStateException("Trace and predicates do not match - their size is incorrect");
        }
        this.mHierarchicalPreStates = this.generateCallHierarchicalPreStates(list, list2);
        this.mResult = this.generateResult(list4, list3);
        if (this.mResult.size() != list.size()) {
            throw new IllegalStateException("The size of the produced result list is invalid.");
        }
        this.reportStatistics();
    }

    private Map<Integer, P> generateCallHierarchicalPreStates(List<P> list, List<LETTER> list2) {
        HashMap<Integer, IPredicate> hashMap = new HashMap<Integer, IPredicate>();
        ArrayDeque<IPredicate> arrayDeque = new ArrayDeque<IPredicate>();
        Iterator<StateTriple<P, LETTER>> iterator = this.mTripleList.getIterator();
        int n = 0;
        while (iterator.hasNext()) {
            StateTriple<P, LETTER> stateTriple = iterator.next();
            if (stateTriple.getTransition() instanceof ICallAction) {
                arrayDeque.addFirst((IPredicate)stateTriple.getFirstState());
            } else if (stateTriple.getTransition() instanceof IReturnAction) {
                IPredicate iPredicate = (IPredicate)arrayDeque.removeFirst();
                assert (!hashMap.containsKey(n));
                hashMap.put(n, iPredicate);
            }
            ++n;
        }
        return hashMap;
    }

    private List<P> generateResult(List<P> list, List<LETTER> list2) {
        assert (list2 != null);
        TripleList<P, LETTER> tripleList = new TripleList<P, LETTER>(list, list2, this.mPrecondition, this.mPostcondition);
        TripleList.TripleListReverseIterator<P, LETTER> tripleListReverseIterator = tripleList.getReverseIterator();
        int n = list2.size() - 1;
        if (!tripleListReverseIterator.hasNext()) {
            throw new IllegalStateException("There is no letter in the list to analyze.");
        }
        Object object = tripleListReverseIterator.next();
        IPredicate iPredicate2 = (IPredicate)((StateTriple)object).getSecondState();
        ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>();
        while (true) {
            IPredicate iPredicate3 = (IPredicate)((StateTriple)object).getFirstState();
            IAction iAction = (IAction)((StateTriple)object).getTransition();
            if (iPredicate3 == this.mPrecondition) break;
            IPredicate iPredicate4 = this.refinePreState(iPredicate3, iAction, iPredicate2, n);
            this.addSizeDifferential(iPredicate3, iPredicate4);
            arrayList.add(iPredicate4);
            iPredicate2 = iPredicate4;
            if (!tripleListReverseIterator.hasNext()) break;
            object = tripleListReverseIterator.next();
            --n;
        }
        Collections.reverse(arrayList);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Predicate list before weakening   : " + String.valueOf(list.stream().map(iPredicate -> iPredicate.getFormula()).collect(Collectors.toList()))));
            this.mLogger.debug((Object)("New predicate list after weakening: " + String.valueOf(arrayList.stream().map(iPredicate -> iPredicate.getFormula()).collect(Collectors.toList()))));
        }
        return arrayList;
    }

    private void addSizeDifferential(P p, P p2) {
        int n;
        int n2 = p.getVars().size();
        if (n2 == (n = p2.getVars().size())) {
            return;
        }
        if (n2 < n) {
            throw new AssertionError((Object)"Weakening cannot introduce more variables");
        }
        ++this.mSuccessfulWeakenings;
        Rational rational = Rational.valueOf((long)n, (long)n2);
        this.mSizeDifferential.add(rational);
    }

    private void reportStatistics() {
        if (this.mSuccessfulWeakenings == 0) {
            this.mLogger.info((Object)"Could never weaken!");
        } else {
            Rational rational3 = this.mSizeDifferential.stream().reduce(Rational.ZERO, (rational, rational2) -> rational.add(rational2));
            Rational rational4 = rational3.div(Rational.valueOf((long)this.mSuccessfulWeakenings, (long)1L));
            double d = 100.0 - rational4.numerator().doubleValue() / rational4.denominator().doubleValue() * 100.0;
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMaximumFractionDigits(2);
            this.mLogger.info((Object)String.format("Weakened %s states. On average, predicates are now at %s%% of their original sizes.", this.mSuccessfulWeakenings, decimalFormat.format(d)));
        }
    }

    protected abstract P refinePreState(P var1, LETTER var2, P var3, int var4);

    protected void reportWeakeningRatio(double d) {
        this.mStats.addRatio(CegarAbsIntRunner.AbsIntStats.WEAKENING_RATIO, d);
    }

    protected void reportWeakeningVarsNumRemoved(int n) {
        this.mStats.addRatio(CegarAbsIntRunner.AbsIntStats.AVG_VARS_REMOVED_DURING_WEAKENING, n);
    }

    protected void reportConjunctReduction(int n) {
        this.mStats.addRatio(CegarAbsIntRunner.AbsIntStats.AVG_WEAKENED_CONJUNCTS, n);
    }

    public List<P> getResult() {
        return this.mResult;
    }

    private static final class StateTriple<P, LETTER> {
        private final P mFirstState;
        private final P mSecondState;
        private final LETTER mTransition;

        public StateTriple(P p, LETTER LETTER, P p2) {
            this.mFirstState = p;
            this.mSecondState = p2;
            this.mTransition = LETTER;
        }

        public P getFirstState() {
            return this.mFirstState;
        }

        public P getSecondState() {
            return this.mSecondState;
        }

        public LETTER getTransition() {
            return this.mTransition;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{").append(this.mFirstState).append("} ").append(this.mTransition).append(" {").append(this.mSecondState).append("}");
            return stringBuilder.toString();
        }
    }

    private static final class TripleList<P, LETTER> {
        private final List<P> mPredicates;
        private final List<LETTER> mTrace;
        private final P mPostcondition;
        private final P mPrecondition;

        private TripleList(List<P> list, List<LETTER> list2, P p, P p2) {
            this.mPredicates = list;
            this.mTrace = list2;
            this.mPrecondition = p;
            this.mPostcondition = p2;
        }

        private Iterator<StateTriple<P, LETTER>> getIterator() {
            return new TripleListIterator<P, LETTER>(this.mPredicates, this.mTrace, this.mPrecondition, this.mPostcondition);
        }

        private TripleListReverseIterator<P, LETTER> getReverseIterator() {
            return new TripleListReverseIterator<P, LETTER>(this.mPredicates, this.mTrace, this.mPrecondition, this.mPostcondition);
        }

        private static final class TripleListIterator<P, LETTER>
        implements Iterator<StateTriple<P, LETTER>> {
            private final List<P> mPredicates;
            private final List<LETTER> mTrace;
            private final P mPostcondition;
            private final P mPrecondition;
            private int mLetterIndex;

            private TripleListIterator(List<P> list, List<LETTER> list2, P p, P p2) {
                this.mPredicates = list;
                this.mTrace = list2;
                this.mPrecondition = p;
                this.mPostcondition = p2;
                this.mLetterIndex = 0;
            }

            @Override
            public boolean hasNext() {
                return this.mLetterIndex < this.mTrace.size();
            }

            @Override
            public StateTriple<P, LETTER> next() {
                P p = this.mLetterIndex == 0 ? this.mPrecondition : this.mPredicates.get(this.mLetterIndex - 1);
                LETTER LETTER = this.mTrace.get(this.mLetterIndex);
                P p2 = this.mLetterIndex == this.mTrace.size() - 1 ? this.mPostcondition : this.mPredicates.get(this.mLetterIndex);
                ++this.mLetterIndex;
                return new StateTriple<P, LETTER>(p, LETTER, p2);
            }
        }

        private static final class TripleListReverseIterator<P, LETTER>
        implements Iterator<StateTriple<P, LETTER>> {
            private final List<P> mPredicates;
            private final List<LETTER> mTrace;
            private final P mPostcondition;
            private final P mPrecondition;
            private int mLetterIndex;

            private TripleListReverseIterator(List<P> list, List<LETTER> list2, P p, P p2) {
                this.mPredicates = list;
                this.mTrace = list2;
                this.mPrecondition = p;
                this.mPostcondition = p2;
                this.mLetterIndex = this.mTrace.size() - 1;
            }

            @Override
            public boolean hasNext() {
                return this.mLetterIndex >= 0;
            }

            @Override
            public StateTriple<P, LETTER> next() {
                P p = this.mLetterIndex == 0 ? this.mPrecondition : this.mPredicates.get(this.mLetterIndex - 1);
                LETTER LETTER = this.mTrace.get(this.mLetterIndex);
                P p2 = this.mLetterIndex == this.mTrace.size() - 1 ? this.mPostcondition : this.mPredicates.get(this.mLetterIndex);
                --this.mLetterIndex;
                return new StateTriple<P, LETTER>(p, LETTER, p2);
            }
        }
    }
}

