/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class IterableIntersection<E>
implements Iterable<E> {
    private final Collection<E> mIteratedCollection;
    private final Set<E> mFilterSet;

    public IterableIntersection(Set<E> set, Set<E> set2) {
        if (set.size() <= set2.size()) {
            this.mIteratedCollection = set;
            this.mFilterSet = set2;
        } else {
            this.mIteratedCollection = set2;
            this.mFilterSet = set;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<E> mIt;
            E mNext;
            {
                this.mIt = IterableIntersection.this.mIteratedCollection.iterator();
                this.mNext = this.preComputeNext();
            }

            @Override
            public boolean hasNext() {
                return this.mNext != null;
            }

            private E preComputeNext() {
                Object e = null;
                while (e == null && this.mIt.hasNext()) {
                    Object e2 = this.mIt.next();
                    if (!IterableIntersection.this.mFilterSet.contains(e2)) continue;
                    e = e2;
                }
                return e;
            }

            @Override
            public E next() {
                Object e = this.mNext;
                this.mNext = this.preComputeNext();
                return e;
            }
        };
    }
}

